//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface IFormOption {
  id: string;
  label?: string;
  value?: any;
  initValue: any;
  show?: boolean;
  associated: IAuthorityEnum;
  tip?: string;
  change?: () => void;
  disabled?: boolean;
}
export interface ISwitchOption extends IFormOption {
  value: boolean;
  initValue: boolean;
  tip?: string;
  valida?: string;
}
export interface ICheckOption {
  label: string;
  tip?: string;
  options: ICheckboxItem[];
  value: ICheckboxItem[];
  initValue: ICheckboxItem[];
}
export interface ICheckboxItem extends IFormOption {
  id: TLSVersions;
  text: TLSVersions;
  value: boolean;
  initValue: boolean;
}

export interface IInputOption extends IFormOption {
  controll: any;
  validation: any;
  initValue: string | number;
  recommendValue?: string;
}
export interface ISelectOption extends IFormOption {
  options: ISelectItem[];
  value: string | number;
  initValue: string | number;
  tip?: string;
}

export interface ILoginFailSelect extends ISelectOption {
  options: ILoginFailOption[];
  value: string | number;
  changeFn: () => void;
}

export interface ISelectItem {
  value: string | number;
  label: string | number;
}

export interface ILoginFailOption extends ISelectItem {
  isIgnoreTime: boolean;
}

export interface IAuthorityData {
  user?: IAccount[];
  systemLockDownEnabled?: boolean;
  OSAdministratorPrivilegeEnabled?: boolean;
  tls12Configurable: boolean;
  passwordComplexityCheckEnabled?: boolean;
  sshPasswordAuthenticationEnabled?: boolean;
  passwordValidityDays?: number;
  emergencyLoginUser?: string;
  previousPasswordsDisallowedCount?: number;
  minimumPasswordAgeDays?: number;
  minimumPasswordLength?: number;
  accountInactiveTimelimit?: number;
  certificateOverdueWarningTime?: number;
  tlsVersion: TLSVersions[];
  accountLockoutThreshold: number;
  accountLockoutDuration: number;
  antiDNSRebindEnabled: boolean;
  error?: any;
  tlsSupported: boolean;
  crlOverdueWarningMode: string;
  crlOverdueWarningTime: number;
  localAccountPasswordRulePolicy: string;
  localAccountPasswordPattern: string;
  snmpCommunityPasswordRulePolicy: string;
  snmpCommunityPasswordPattern: string;
  vncPasswordRulePolicy: string;
  vncPasswordPattern: string;
}

export enum IAuthorityEnum {
  systemLockDownEnabled = 'SystemLockDownEnabled',
  OSAdministratorPrivilegeEnabled = 'OSAdministratorPrivilegeEnabled',
  passwordComplexityCheckEnabled = 'PasswordComplexityCheckEnabled',
  SSHPasswordAuthenticationEnabled = 'SSHAuthenticationMode',
  passwordValidityDays = 'PasswordValidityDays',
  emergencyLoginUser = 'EmergencyLoginUser',
  previousPasswordsDisallowedCount = 'PreviousPasswordsDisallowedCount',
  minimumPasswordAgeDays = 'MinimumPasswordAgeDays',
  minimumPasswordLength = 'MinimumPasswordLength',
  accountInactiveTimelimit = 'AccountInactiveTimelimitDays',
  certificateOverdueWarningTime = 'CertificateOverdueWarningTime',
  tlsVersion = 'TLSVersion',
  accountLockoutThreshold = 'AccountLockoutThreshold',
  accountLockoutDuration = 'AccountLockoutDuration',
  antiDNSRebindEnabled = 'AntiDNSRebindEnabled',
  crlOverdueWarningMode = 'CRLOverdueWarningMode',
  crlOverdueWarningTime = 'CRLOverdueWarningTime',
  localAccountPasswordRulePolicy = 'LocalAccountPasswordRulePolicy',
  localAccountPasswordPattern = 'LocalAccountPasswordPattern',
  snmpCommunityPasswordRulePolicy = 'SnmpCommunityPasswordRulePolicy',
  snmpCommunityPasswordPattern = 'SnmpCommunityPasswordPattern',
  vncPasswordRulePolicy = 'VNCPasswordRulePolicy',
  vncPasswordPattern = 'VNCPasswordPattern',
}

export interface IAccount {
  value: string;
  label: string;
}

export enum TLSVersions {
  'TLS10' = 'Tls1.0',
  'TLS11' = 'Tls1.1',
  'TLS12' = 'Tls1.2'
}

export enum SSHAuthenticationMode {
  password = 'Password',
  publicKey = 'PublicKey'
}
