//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { traduction } from '@/utils/language';
import { reactive } from 'vue';

// 角色列表
export const roleList = [
  {
    id: 'Administrator',
    label: traduction('COMMON_ROLE_ADMINISTRATOR'),
  },
  {
    id: 'Operator',
    label: traduction('COMMON_ROLE_OPERATOR'),
  },
  {
    id: 'CommonUser',
    label: traduction('COMMON_ROLE_COMMONUSER'),
  },
  {
    id: 'CustomRole1',
    label: traduction('COMMON_ROLE_CUSTOMROLE1'),
  },
  {
    id: 'CustomRole2',
    label: traduction('COMMON_ROLE_CUSTOMROLE2'),
  },
  {
    id: 'CustomRole3',
    label: traduction('COMMON_ROLE_CUSTOMROLE3'),
  },
  {
    id: 'CustomRole4',
    label: traduction('COMMON_ROLE_CUSTOMROLE4'),
  },
  {
    id: 'NoAccess',
    label: traduction('COMMON_ROLE_NOACCESS'),
  },
];

// 首次登录密码修改策略
export const modifyPwdStrategy = [
  {
    label: traduction('USER_MODIFY_PWD_HINT'),
    value: 1,
  },
  {
    label: traduction('USER_MODIFY_PWD_FORCE'),
    value: 2,
  },
];

// 接口列表
export const interfaceList: string[] = ['SSH', 'IPMI', 'Local', 'SFTP', 'Web', 'SNMP', 'Redfish'];

// 鉴权算法数据和加密算法数据
export const authorityOptions: any = reactive([
  { label: 'MD5', id: 'MD5' },
  { label: 'SHA', id: 'SHA' },
  { label: 'SHA1', id: 'SHA1', disabled: true },
  { label: 'SHA256', id: 'SHA256' },
  { label: 'SHA384', id: 'SHA384' },
  { label: 'SHA512', id: 'SHA512' },
]);

export const authorityOptions2: any = reactive([
  { label: 'SHA256', id: 'SHA256' },
  { label: 'SHA384', id: 'SHA384' },
  { label: 'SHA512', id: 'SHA512' },
]);

export const encrypOptions = reactive([
  { label: 'DES', id: 'DES' },
  { label: 'AES', id: 'AES' },
  { label: 'AES256', id: 'AES256' },
]);

// 新增或修改用户名时，以下几种错误应该在页面的输入框后做提示
export const userErrorList: string[] = [
  'ResourceAlreadyExists',
  'ConflictWithLinuxDefaultUser',
  'UserIsLoggingIn',
  'UserNameIsRestricted',
  'InvalidUserName',
];

// 密码修改失败时的错误类型
export const pwdErrorList: string[] = [
  'PasswordNotSatisfyComplexity',
  'PasswordComplexityCheckFail',
  'DuringMinimumPasswordAge',
  'InvalidPasswordSameWithHistory',
  'PasswordInWeakPWDDict',
  'PropertyValueExceedsMaxLength',
  'InvalidPassword',
];
