//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { IRadio, IOptions } from '../storage-interface';

export class VolumeSelectData {
  public name: string;
  public bootDiskSelect: IRadio;
  public sscdFuncSelect: IRadio;
  public driveCacheSelect: IOptions;
  public accessSelect: IOptions;
  public bgiStateSelect: IOptions;
  public ioPolicySelect: IOptions;
  public writePolicySelect: IOptions;
  public readPolicySelect: IOptions;

  constructor(
    name: string,
    bootDiskSelect: IRadio,
    sscdFuncSelect: IRadio,
    driveCacheSelect: IOptions,
    accessSelect: IOptions,
    bgiStateSelect: IOptions,
    ioPolicySelect: IOptions,
    writePolicySelect: IOptions,
    readPolicySelect: IOptions,
  ) {
    this.name = name;
    this.bootDiskSelect = bootDiskSelect;
    this.sscdFuncSelect = sscdFuncSelect;
    this.driveCacheSelect = driveCacheSelect;
    this.accessSelect = accessSelect;
    this.bgiStateSelect = bgiStateSelect;
    this.ioPolicySelect = ioPolicySelect;
    this.writePolicySelect = writePolicySelect;
    this.readPolicySelect = readPolicySelect;
  }
}
