//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { TreeNode } from '../storage-interface';
import { Volume } from './volume.model';

export class VolumeNode implements TreeNode {
  id: string;
  label: string;
  url: string;
  children!: TreeNode[];
  checked: boolean | string;
  active!: boolean;
  labelId: string;
  readonly disabled: boolean = false;
  private raidUrl: string;
  private volume!: Volume;
  private raidIndex: number;
  private ssdCachecadeVolume: boolean;
  private ssdCachingEnabled: boolean;
  private capacityBytes: number;
  private raidLevel: string;
  readonly componentName: string = 'VolumeNode';
  readonly className: string = 'volumeClass';
  private raidType: string;


  constructor(
    lable: string,
    url: string,
    raidUrl: string,
    id: string,
    raidIndex: number,
    raidLevel: string,
    labelId: string,
    raidType: string,
    ssdCachecadeVolume: boolean,
    ssdCachingEnabled: boolean,
    capacityBytes: number,
  ) {
    this.id = id;
    this.label = lable;
    this.url = url;
    this.raidUrl = raidUrl;
    this.checked = false;
    this.raidIndex = raidIndex;
    this.raidLevel = raidLevel;
    this.labelId = labelId;
    this.raidType = raidType;
    this.ssdCachecadeVolume = ssdCachecadeVolume;
    this.ssdCachingEnabled = ssdCachingEnabled;
    this.capacityBytes = capacityBytes;
  }

  get getRaidType() {
    return this.raidType;
  }

  get getSSDCachecadeVolume(): boolean {
    return this.ssdCachecadeVolume;
  }

  get getSSDCachingEnabled(): boolean {
    return this.ssdCachingEnabled;
  }

  get getCapacityBytes(): number {
    return this.capacityBytes;
  }

  get getRaidIndex(): number {
    return this.raidIndex;
  }

  get getUrl(): string {
    return this.url;
  }

  get getRaidUrl(): string {
    return this.raidUrl;
  }

  get getRaidLevel() {
    return this.raidLevel;
  }

  get getVolume(): Volume {
    return this.volume;
  }

  set setChildren(children: TreeNode[]) {
    this.children = children;
  }

  set setVolume(volume: Volume) {
    this.volume = volume;
  }

  addChildren(children: TreeNode): void {
    if (!this.children) { this.children = []; }
    this.children.push(children);
  }

  addTreeNode(children: TreeNode[]) {
    if (!this.children) { this.children = []; }
    this.children = this.children.concat(children);
  }
}
