//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { TreeNode } from './storage-interface';
/**
 *
 * 用于封装给树组件 [TiTreeComponent]{@link ../components/TiTreeComponent.html}
 * 提供公共方法，包括增、删、改、查、选中、取消选中、遍历、筛选、获取选中项等操作
 */
export declare class TiTreeUtil {
  private static selectedData;
  private static pnode;
  /**
   * 根据某node节点查找其父节点
   * @param  data 所有节点数据
   * @param node 已知node节点
   */
  static getParentNode(data: Array<TreeNode>, node: TreeNode): TreeNode;
  /**
   * 遍历整个树
   * @param data 所有节点数据
   * @param traverseFn 对各个节点执行的操作
   */
  static traverse(data: Array<TreeNode>, traverseFn: any): void;
  /**
   * 多选树，更新各节点的选中状态。
   * 适用场景：手动添加或删除若干节点，当前节点的兄弟节点和父节点的选中状态不一致。
   * 10.0.1 新增
   * @param data  所有节点数据
   */
  static updateChecked(data: Array<TreeNode>): void;
  /**
   * 检查当前数据的多选状态
   * @param data 当前节点集合
   * @param allData 全部数据集合
   */
  private static check;
  /**
   * 当前节点是否是叶子节点的父节点，
   * 因为更新节点的选中状态时，根据叶子节点的选中状态计算出父节点的选中状态，再更新父节点的选中状态。
   * @param node 当前节点
   */
  private static isLeafsParentNode;
  /**
   * 根据子节点的多选状态，计算出当前节点的多选状态
   * @param node 当前节点
   */
  private static computeChecked;
  /**
   * 添加节点
   * @param data 所有节点数据
   * @param node  需要添加的节点：一个或多个节点
   * @param index  添加的位置: -1表示从尾部追加
   * @param pNode 指定要添加的节点的父节点，如果没有指定的话默认添加到根节点
   */
  static addNode(data: Array<TreeNode>, node: Array<TreeNode>, index: any, pNode?: TreeNode): void;
  /**
   * 删除一个节点
   * @param  data 所有节点数据
   * @param  node  节点
   */
  static removeNode(data: Array<TreeNode>, node: TreeNode): void;
  /**
   * 选中某个节点
   * @param  data 所有节点数据
   * @param  node  节点
   * @param  multiple 是否多选模式
   */
  static selectNode(data: Array<TreeNode>, node: TreeNode, multiple: boolean): void;
  /**
   * 取消选中某个节点
   * @param data 所有节点数据
   * @param node  节点
   * @param multiple 是否多选模式
   */
  static deSelectNode(data: Array<TreeNode>, node: TreeNode, multiple: boolean): void;
  /**
   * 展开id所有父节点
   * @param  data 所有节点数据
   * @param  node  节点
   */
  static expandNode(data: Array<TreeNode>, node: TreeNode): boolean;
  /**
   * 根据用户传入的方法筛选节点的数据
   * @param data 所有节点数据
   * @param  matchFn 用户传入匹配节点的方法
   * @returns 是否找到
   */
  static search(data: Array<TreeNode>, matchFn: (node: TreeNode) => boolean): boolean;
  /**
   * 获取选中项
   * @param data 所有节点数据
   * @param  onlySelectLeaf 选中项中是否只包含叶子节点
   * @param  multiple 是否多选模式
   */
  static getSelectedData(data: Array<TreeNode>, onlySelectLeaf: boolean, multiple: boolean): Array<TreeNode>;
  /**
   * @ignore
   * @description 根据整棵树的节点数据，查询所有选中项，并更新selectedData
   * @param data 全部节点数据
   * @param onlySelectLeaf 全部节点数据
   */
  static querySelectedNode(data: Array<TreeNode>, onlySelectLeaf: boolean, multiple: boolean): void;
  /**
   * @ignore
   * @description 判断节点node是否是一个处于选中或半选状态的父节点
   * @param node 节点数据
   */
  static checkedParentNode(node: TreeNode): boolean;
  /**
   * @ignore
   * @description 判断节点node是否是一个处于选中状态的叶子节点
   * @param node 节点数据
   */
  static checkedLeafNode(node: TreeNode): boolean;
  /**
   * @ignore
   * 判断是否为叶子节点
   */
  static isLeaf(item: TreeNode): boolean;
  /**
   * @ignore
   * 从数组arr中删除下标为index的节点
   */
  static deleteArr(arr: Array<TreeNode>, index: number): void;
  /**
   * @ignore
   * 当子节点选中时，设置祖先元素的选中状态
   * @param item 子节点的数据
   * @param allData 全部节点数据
   * @param checked 取值为：true/false/'indeterminate'
   */
  static selectParents(item: TreeNode, allData: Array<TreeNode>, checked: boolean | string): void;
  /**
   * @ignore
   * 根据父节点选择子节点
   */
  static selectAllChildren(item: TreeNode): void;
  /**
   * @ignore
   * 多选状态下，父节点取消选中，置子节点都为取消选中状态
   * @param item 子节点的数据
   */
  static deSelectAllChildren(item: TreeNode): void;
  /**
   * @ignore
   * 当前节点取消选中时，设置祖先元素的选中状态
   * @param item 当前节点的数据
   * @param allData 全部的节点数据
   */
  static deSelectParents(item: TreeNode, allData: Array<TreeNode>): void;
}
