//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { reqPath } from '@/api/reqPath';
import $http from '@/utils/http-service';
import {
  UI_REST_PROCESSOR,
  UI_REST_PRODUCT_INFO,
  UI_REST_SYSTEM_MEMORY,
  UI_REST_SYSTEM_UNITS,
  UI_REST_SYSTEM_BOARDS,
  UI_REST_SYSTEM_THERMAL,
  UI_REST_CLEAR_INLET_HISTORY,
  UI_REST_FRU,
} from '@/api/api';
import { IUpdateBody } from '../product.datatype';

export function getProductInfo(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(UI_REST_PRODUCT_INFO)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function getProcessors(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(UI_REST_PROCESSOR)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function getMemory(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(UI_REST_SYSTEM_MEMORY)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function getOneMemory(url: string): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(url)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function getBoards(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(UI_REST_SYSTEM_BOARDS)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function getUnitsBoards(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(UI_REST_SYSTEM_UNITS)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function getBoard(url: string): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(url)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}
export function getThermals(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(UI_REST_SYSTEM_THERMAL)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function getFru(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(UI_REST_FRU)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function clearInletHistoryTemperature() {
  return $http.post(UI_REST_CLEAR_INLET_HISTORY, {});
}

export function intelligentUpdate(param: any) {
  return $http.patch('/UI/Rest/System/Thermal', param);
}

export function updateProductInfo(value: IUpdateBody) {
  return $http.patch(reqPath.system.info.productionInfo, value);
}

export function sendNmi(param: any) {
  return $http.post('/UI/Rest/System/PCIeDevices/SetSDICardNMI', param);
}

export function setLevel(param: any): any {
  return $http.post('/UI/Rest/System/PCIeDevices/SetSDICardLogLevel', param);
}

export function setPower(param: any): any {
  return $http.post('/UI/Rest/System/PCIeDevices/SetSDICardPowerState', param);
}

export function resetPower(param: any): any {
  return $http.post('/UI/Rest/System/PCIeDevices/ResetSDICard', param);
}
