//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export enum productId {
  productInfoName = 'productInfoName',
  productSerialNum = 'productSerialNum',
  assetTag = 'assetTag',
  position = 'position',
  productManufacturer = 'productManufacturer',
  bomNumber = 'bomNumber',
  systemSN = 'systemSN',
  biosVersion = 'biosVersion',
  ibmcVersion = 'ibmcVersion',
  mainBoot = 'mainBoot',
  backupBoot = 'backupBoot',
}

export enum systemId {
  localDomain = 'localDomain',
  ibmaService = 'ibmaService',
  description = 'description',
  ibmaStatus = 'ibmaStatus',
  kernalVersion = 'kernalVersion',
  ibmaDriver = 'ibmaDriver',
  domain = 'domain',
  operator = 'operator'
}

export enum DigitalWarrantyId {
  productNamePolicy = 'productNamePolicy',
  serialNumber = 'serialNumber',
  manufactureDate = 'manufactureDate',
  UUID = 'UUID',
  unitType = 'unitType',
  startPoint = 'startPoint',
  lifespan = 'lifespan'
}

export interface ISystemInfo {
  title?: string;
  backgroundClassName: string;
  id: string;
  data: ISystemItem[];
}
export interface ISystemItem {
  label: string;
  id: string;
  content: any;
  hide?: boolean;
  editContent?: string;
  isEditable?: boolean;
  inputShow?: boolean;
  inputError?: boolean;
  placeholderText?: string;
  confirm?: (param: ISystemItem) => void;
  cancel?: (param: ISystemItem) => void;
  editInfo?: (param: ISystemItem) => void;
  change?: (value: string, param: ISystemItem) => void;
  maxSize?: number;
  toolTipText?: string;
  errorTip?: string;
}

interface IProcessorRow {
  name: string;
  manufacturer: string;
  model: string;
  serialNumber: string;
  extendTitleArr?: IExtendTitle[];
}

export interface IColumn {
  title: string;
  content: string;
  width?: string;
  hide?: boolean;
}
export interface IExtendTitleItem {
  label: string;
  content: string;
  hide?: boolean;
}

export interface IExtendTitle {
  title?: string;
  data: IExtendTitleItem[];
}

export interface ICpuTableRow extends IProcessorRow {
  frequency: string;
  frequencyMHz: string;
  cache: string;
  cacheKiB: string;
  otherParameters: string;
  partNumber: string;
  totalCoresNum: string;
  totalCores: string;
  totalEnabledCores: string;
  processorState: string;
  id: string;
  position: string;
  hbmCapacityMiB?: string;
  hbmWidthBits?: string;
  hbmSpeedsMHz?: string;
}
export interface INpuTableRow extends IProcessorRow {
  powerWatts: string;
  firmwareVersion: string;
  boardSerialNumber: string;
}
export interface IRow {
  cpu: ICpuTableRow[];
  npu: INpuTableRow[];
  totalCpuLength: number;
  totalNpuLength: number;
}

export interface IDetail {
  label: string;
  content: string;
  needPipe?: boolean;
  // 当content内容占据多行时，label应该放在顶部
  labelTop?: boolean;
  hide: boolean;
}

export interface IMemory {
  allowedSpeedsMHz: string;
  bomNumber: string;
  capacityMiB: string;
  dataWidthBits: string;
  deviceLocator: string;
  deviceType: string;
  manufacturer: string;
  minVoltageMillivolt: string;
  operatingSpeedMHz: string;
  partNumber: string;
  position: string;
  rankCount: string;
  serialNumber: string;
  typeDetail: string;
  aepInfo?: IAEPInfo;
  extendTitleArr?: IExtendTitle[];
  url?: string;
  expandFlag?: string;
  expandShow?: boolean;
}

export interface IMemoryList {
  memory: IMemory[];
  totalMemorylength: number;
}

export interface IAEPInfo {
  remainPercent: string;
  mediumTemp: string;
  revision: string;
  volatileMib: string;
  controlTemp: string;
  persistMib: string;
}

export interface IOtherTab {
  label: string;
  type: string;
  currentNumber: number;
  detailLink: string;
  maxNumber: number;
  isCheck: boolean;
}

export interface ICpuBoard {
  boardName: string;
  manufacturer: string;
  id: number;
  deviceType: string;
  pCBVersion: string;
  cPLDVersion: string;
  boardId: string;
  power: string;
}

export interface IDiskBackplane {
  boardName: string;
  location: string;
  manufacturer: string;
  cardNo: number;
  description: string;
  pCBVersion: string;
  cPLDVersion: string;
  boardId: string;
  partNumber: string;
  serialNumber: number;
}

export interface IExpandBoard {
  boardName: string;
  boardId: string;
  cPLDVersion: string;
  cardNo: string;
  description: string;
  location: string;
  manufacturer: string;
  pCBVersion: string;
  partNumber: string;
  serialNumber: string;
}

export interface IBackupBatteryUnits {
  boardName: string;
  id: number;
  firmwareVersion: string;
  workingState: string;
  capacity: string;
  batteryModel: string;
  serialNumber: string;
  manufacturer: string;
  inPosition: string;
}

export interface IChassisBackplane {
  productName: string;
  location: string;
  manufacturer: string;
  pCBVersion: string;
  boardId: string;
}

export interface ICicBoard {
  boardName: string;
  manufacturer: string;
  pcbVer: string;
  boardId: string;
  description: string;
  serialNumber: string;
  partNum: string;
  m2Device1Presence: string;
  m2Device2Presence: string;
  extendTitleArr?: IExtendTitle[];
}

export interface IFanBackPlane {
  boardName: string;
  position: string;
  manufacturer: string;
  deviceType: string;
  pCBVersion: string;
  boardId: string;
}

export interface IGPUBoard {
  boardName: string;
  slot: string;
  boardId: string;
  pCBVersion: string;
  cPLDVersion: string;
}

export interface IHorizontalAdapter {
  boardName: string;
  pCBVersion: string;
  boardId: string;
}

export interface IIOBoard {
  boardName: string;
  location: string;
  manufacturer: string;
  description: string;
  firmwareVersion: string;
  pCBVersion: string;
  cPLDVersion: string;
  boardId: string;
  power: string;
  partNumber: string;
  serialNumber: number;
}

export interface ILCD {
  lcdFirmwareVersion: string;
}

export interface ILeakDetection {
  boardName: string;
  pCBVersion: string;
  boardId: string;
  partNumber: string;
}

export interface IM2TransformCard {
  boardName: string;
  description: string;
  id: number;
  pCBVersion: string;
  boardId: string;
  partNumber: string;
  serialNumber: number;
}

export interface IMemoryBoard {
  boardName: string;
  manufacturer: string;
  id: number;
  deviceType: string;
  pCBVersion: string;
  boardId: string;
}

export interface IMezzCard {
  productName: string;
  description: string;
  cardNo: number;
  pCBVersion: string;
  boardId: string;
  associatedResource: string;
  linkWidth: string;
  linkSpeed: string;
  linkWidthAbility: string;
  linkSpeedAbility: string;
  partNumber: string;
  serialNumber: number;
}

export interface IOCPCard {
  description: string;
  position: string;
  manufacturer: string;
  id: number;
  vendorId: number;
  deviceId: number;
  subsystemVendorId: number;
  subsystemId: number;
  associatedResource: string;
  productName: string;
  extendTitleArr?: IExtendTitle[];
}

export interface IPassThroughCard {
  boardName: string;
  manufacturer: string;
  description: string;
  cardNo: number;
  pCBVersion: string;
  boardId: string;
  partNumber: string;
  serialNumber: number;
}

export interface IPCIeCard {
  description: string;
  position: string;
  manufacturer: string;
  id: number;
  vendorId: number;
  deviceId: number;
  partNumber: string;
  subsystemVendorId: number;
  subsystemId: number;
  associatedResource: string;
  extendAttr?: any;
  componentUniqueID?: string;
  slotId: string;
}

export interface IPCIERiserCard {
  boardName: string;
  manufacturer: string;
  cardNo: number;
  description: string;
  pCBVersion: string;
  boardId: string;
  partNumber: string;
  serialNumber: number;
}

export interface IPCIETransformCard {
  boardName: string;
  description: string;
  cardNo: number;
  pCBVersion: string;
  boardId: string;
}

export interface IPeripheralCard {
  boardName: string;
  description: string;
  manufacturer: string;
  pCBVersion: string;
  boardId: string;
}

export interface IPeripheralFirmware {
  boardName: string;
  manufacturer: string;
  version: string;
}

export interface IPowerBoard {
  boardName: string;
  deviceType: string;
  pCBVersion: string;
  boardId: string;
}

export interface IRaidCard {
  productName: string;
  location: string;
  manufacturer: string;
  cardNo: number;
  description: string;
  pCBVersion: string;
  cPLDVersion: string;
  boardId: string;
  partNumber: string;
  serialNumber: number;
  associatedResource: string;
}

export interface ISDCard {
  id: number;
  manufacturer: string;
  serialNumber: string;
  capacity: any;
}

export interface ISDStorage {
  manufacturer: string;
  firmwareVersion: string;
}

export interface ISecurity {
  protocolType: string;
  protocolVersion: string;
  manufacturer: string;
  firmwareVersion: string;
  selfTestResult: string;
}

// Units的扩展卡
export interface UnitsCard {
  serialNumber: string;
  pcbVersion: string;
  cpldVersion: string;
  hwsrVersion: string;
  partNumber: string;
  npuName: string;
  extendTitleArr?: object[];
}

// PCIE的扩展卡
export interface INetCard {
  productName: string;
  boardId: string;
  pcbVersion: string;
  cpldVersion: string;
  firmwareVersion: string;
  linkWidth: string;
  linkWidthAbility: string;
  linkSpeed: string;
  linkSpeedAbility: string;
  subsystemVendorId: string;
  subsystemId: string;
  extendTitleArr?: object[];
}

export interface IDpuCard {
  productName: string;
  storageManagementIP: string;
  storageManagementIPv6: string;
  linkWidthAbility: string;
  subsystemVendorId: string;
  subsystemId: string;
  pcbVersion: string;
  portStatus: string;
  vrdInfo: Array<{ VrdName: string; VrdVersion: string }>;
  extendTitleArr?: object[];
}

export interface IGPUCard {
  productName: string;
  serialNumber: string;
  firmwareVersion: string;
  extendTitleArr?: object[];
}

export interface IFPGACard {
  productName: string;
  boardId: string;
  pcbVersion: string;
  mcuFirmwareVersion: string;
  platformId: number;
  power: string;
  memoryCapacity: number;
  firmwareVersion: string;
  extendTitleArr?: object[];
}
export interface ISDICard {
  productName: string;
  boardId: string;
  pcbVersion: string;
  storageManageIP: string;
  vlanId: string;
  bootOption: string;
  mcuFirmwareVersion: string;
  power: string;
  ports: IPorts;
  sODimm?: string;
  extendCardNum?: string;
  m2Device1Presence?: string;
  extendCards?: ISDIExtendCard[];
  extendTitleArr?: object[];
  MRCLogLevel?: string;
  UEFILogLevel?: string;
  powerState?: string;
  vrdFirmwareVersion?: string;
  ossUpported?: boolean;
}

export interface ISDIExtendCard {
  title: string;
  productName: string;
  pcbVersion: string;
  boardName: string;
  boardId: string;
  deviceId: string;
  vendorId: string;
  subsystemVendorId: string;
  subsystemId: string;
  manufacturer: string;
  description: string;
  chipManufacturer: string;
  chipModel: string;
  ports: IPorts;
  extendCardTitleArr?: object[];
}

export interface IPort {
  Port: string;
  PfId: string;
  PermanentMac: string;
}

export interface IPorts {
  title: string;
  portArray: IPort[];
  showPort: boolean;
  columns: object[];
}
export interface IStorageCard {
  productName: string;
  boardId: number;
  pcbVersion: string;
  serialNumber: string;
  pcbVersionuctName?: string;
  ssd1Presence?: string;
  ssd2Presence?: string;
  model?: string;
  firmwareVersion?: string;
  residualWearRate?: string;
  extendTitleArr?: object[];
}
export interface IAccelerateCard {
  productName: string;
  boardId: number;
  pcbVersion: string;
  serialNumber: string;
  firmwareVersion: string;
  bomId: number;
  extendTitleArr?: object[];
}

export interface IUpdateBody {
  AssetTag?: string;
  DeviceLocation?: string;
  DigitalWarranty?: Record<string, unknown>;
}
