//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { reqPath } from '@/api/reqPath';
import $http from '@/utils/http-service';

// 获取Net数据
export function getNetData() {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.net.getNetData)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

export function getNetDataDetail(id: string, type?: string): any {
  let url = '';
  if (type === 'Bridge') {
    url = reqPath.net.getBridgeData;
  } else if (type === 'Team') {
    url = reqPath.net.getTeamData;
  } else {
    url = reqPath.net.getNetData;
  }
  return new Promise((resolve, reject) => {
    $http
      .get(`${url}/${id}`)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 点击 热插拔操作的请求
export function getNetworkSettings() {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.manager.networkSettings)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 确认热插拔操作
export function networkAdapter(id: string, param: { HotPlugAttention?: boolean }) {
  return new Promise((resolve, reject) => {
    $http
      .patch(`${reqPath.net.networkAdapter}/${id}`, param)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
