// Copyright (c) Huawei Technologies Co., Ltd. 2022-2024. All rights reserved.
// 
// this file licensed under the Mulan PSL v2.
// You can use this software according to the terms and conditions of the Mulan PSL v2.
// You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
//
// THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
// PURPOSE.
// See the Mulan PSL v2 for more details.
export enum FRUINFOTYPE {
    PRODUCT = 0,
    CHASSIS = 1,
    BOARD = 3
}
 
export interface ExtendArrItem {
    label: string;
    content: string;
    hide: boolean;
}
 
export interface FruTableItem {
    fruId: string | number;
    fruName: string;
    extendProduct: {
        extendTitleArr: ExtendArrItem[];
        productName: string;
        assetTag: string;
        productFruFileId: string;
        productCustomInfo: string;
        productPartNumber: string;
        productVersion: string;
        manufacturerName: string;
        productSerialNumber: string;
    };
    extendChassis: {
        extendTitleArr: ExtendArrItem[];
        chassisPartNumber: string;
        chassisCustomInfo: string;
        chassisType: string;
        chassisSerialNumber: string;
    };
    extendBoard: {
        extendTitleArr: ExtendArrItem[];
        mfgDate: string;
        boardCustomInfo: string;
        boardSerialNumber: string;
        boardProductName: string;
        boardManufacturer: string;
        boardFRUFileID: string;
        boardPartNumber: string;
    };
}