//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { UI_REST_GENERALDOWNLOAD } from '@/api/api';
import { reqPath } from '@/api/reqPath';
import { downloadFileWithResponse } from '@/utils/common-service';
import $http from '@/utils/http-service';

export function getOverView(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get('/UI/Rest/Overview')
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function getThermalOverView(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get('/UI/Rest/Overview/Summary')
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

// 恢复配置
export function reset(params: any): Promise<any> {
  const url = '/UI/Rest/RestoreFactory';
  return $http.post(url, params);
}

// 一键收集
export function oneKeyCollect(fileName: string): Promise<any> {
  const url = '/UI/Rest/Dump';
  const data = {};
  return $http.post(url, {});
}

// 一键收集进度
export function collectProgress(url: string): Promise<any> {
  return $http.get(url, {}, { keepAlive: true });
}

export function sendHeartBeat() {
  const url = '/UI/Rest/KeepAlive';
  const postData = {
    Mode: 'Activate',
  };

  const header = {
    headers: {
      'Content-Type': 'application/json;charset=utf-8',
      From: 'WebUI',
    },
  };
  return $http.post(url, postData, header);
}

export function exportKvmStartupFile(postData: object) {
  const url = '/UI/Rest/Services/KVM/GenerateStartupFile';
  const headers = {
    'Content-Type': 'application/json;charset=utf-8',
    Accept: 'application/json',
  };
  return $http.post(url, postData, {
    headers,
    responseType: 'blob',
  });
}

export function getGenericInfo(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.manager.exportConfig.genericInfo)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function oneKeyDownloadFile(url: string, fileName: string) {
  return new Promise<void>((resolve, reject) => {
    $http.get(url, { responseType: 'blob' }).then(
      response => {
        downloadFileWithResponse(response.data, fileName);
        resolve();
      },
      error => {
        reject(error);
      },
    );
  });
}

export function getDownLoadFileContent() {
  const data = {
    Path: '/tmp/dump_info.tar.gz',
    TransferProtocol: 'HTTPS',
  };
  return $http.post(UI_REST_GENERALDOWNLOAD, data, { responseType: 'blob' });
}

export function getDownLoadRaidFileContent(fileName: string) {
  const data = {
    Path: `/tmp/${fileName}`,
    TransferProtocol: 'HTTPS',
  };
  return $http.post(UI_REST_GENERALDOWNLOAD, data, { responseType: 'blob' });
}
