//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { getStoreData } from '@/utils/composition';
import { Ref, computed } from 'vue';
import { useWindowSize } from '@vueuse/core';

export enum WebStyleType {
  DEFAULT = 'default',
  IBMA = 'ibma',
  SIMPLE = 'simple',
  STANDARD = 'standard',
  BEAUTIFUL = 'beautiful',
}

export enum Resolution {
  DEFAULT = 'default',
  MID = 'middle',
  SMALL = 'small',
}

export interface WindowSize {
  width: Ref<number>;
  height: Ref<number>;
}

export function useHome() {
  const SMALL_WIDTH = 1281;
  const MID_WIDTH = 1823;
  const { width } = getWindowSize();

  function getWebStyle(): string {
    return getStoreData('glob', 'webStyle') || WebStyleType.DEFAULT;
  }

  function getWindowSize(): WindowSize {
    return useWindowSize();
  }

  const getResolution = computed(() => {
    if (width.value < SMALL_WIDTH) {
      return Resolution.SMALL;
    } else if (width.value < MID_WIDTH) {
      return Resolution.MID;
    }
    return Resolution.DEFAULT;
  });

  return { SMALL_WIDTH, getWebStyle, getWindowSize, getResolution };
}

export enum IPVersionType {
  IPV4_AND_IPV6 = 'IPv4AndIPv6',
  IPV6_ONLY = 'IPv6',
  IPV4_ONLY = 'IPv4',
}