//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface IMonitorInfo {
  diskThresholdPercent?: number;
  diskUsagePercent?: number;
  proThresholdPercent?: number;
  proUseagePercent?: number;
  memThresholdPercent?: number;
  memUseagePercent?: number;
  inletTemperature?: number;
  inletTempMinorThreshold?: number;
  inletTempMajorThreshold?: number;
  powerConsumedWatts?: number;
  powerCapacityWatts?: number;
  upperPowerThresholdWatts?: number;
}

export interface IEChartOption {
  id: string;
  navigatorUrl: string[];
  option: any;
  routerParam?: string;
  show?: boolean;
  title?: string;
}

export interface IResourceInfo {
  proMaxNum?: number;
  proCurrentNum?: number;
  memMaxNum?: number;
  memCurrentNum?: number;
  capacityGiB?: number;
  raidControllerNum?: number;
  logicalDriveNum?: number;
  physicalDriveNum?: number;
  powMaxNum?: number;
  powCurrentNum?: number;
  presentPSUNum?: number;
  fanMaxNum?: number;
  fanCurrentNum?: number;
  netMaxNum?: number;
  netCurrentNum?: number;
}

export interface IAccessInfo {
  nodeIp: string;
  FusionPartition: SystemModel;
  VGAUSBDVDEnabled: boolean;
  mode: string;
  address: string;
}

export enum SystemModel {
  SingleSystem = 'SingleSystem',
  DualSystem = 'DualSystem'
}

export interface IAccess {
  show: boolean;
  title: string;
  icon: string;
  id: string;
  imgUrl: string;
  state?: string;
  disable?: boolean;
  onKeySelect?: boolean;
  restoreSet?: boolean;
  nodeChange?: boolean;
  nodeIp?: string;
  lock?: boolean;
}

export interface IDetailInfo {
  id: string;
  label: string;
  detail: string;
}
export interface IResourceDetail {
  label: string;
  infor: string | number;
}
export interface IResource {
  title: string;
  backgroundClassName: string;
  details: IResourceDetail[];
  targetNav: string[];
  id: string;
  hide?: boolean;
}
export interface IVirtualButton {
  label: string;
  disabled: boolean;
  id: string;
  show: boolean;
}
export enum VirtualBtnId {
  h5Only = 'h5Only',
  h5Share = 'h5Share',
  more = 'more'
}

export interface IMonitorParams {
  value: number;
  formatter?: string;
  minorValue: number;
  title?: string;
  lineHeight?: number;
  startAngle?: number;
  clockwise?: boolean;
  computedValue?: number;
  majorVal?: number;
  minVal?: number;
  maxVal?: number;
  isSimpleTemp?: boolean;
}

export interface ICollectProgress {
  state: string;
  taskPercentage: string;
  downloadUrl?: string;
}

export interface ChartElement extends Element {
  resize: () => void;
  update: (opt: any, notMerge?: boolean) => void;
}
