//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { getThemeMode } from '@/utils/utils';
/* eslint-disable max-len*/
const lightRedCircle =
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+57qi6ImyQDF4PC90aXRsZT4KICAgIDxnIGlkPSLns7vnu5/nrqHnkIYiIHN0cm9rZT0ibm9uZSIgc3Ryb2tlLXdpZHRoPSIxIiBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPgogICAgICAgIDxnIGlkPSLnvJbnu4QtNyI+CiAgICAgICAgICAgIDxjaXJjbGUgaWQ9IuakreWchuW9oiIgZmlsbD0iI0ZGRkZGRiIgY3g9IjYiIGN5PSI2IiByPSI2Ij48L2NpcmNsZT4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5b2i54q257uT5ZCIIiBmaWxsPSIjRkZGRkZGIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5qSt5ZyG5b2i5aSH5Lu9LTciIGZpbGw9IiNFMzIwMjAiIGZpbGwtcnVsZT0ibm9uemVybyI+PC9wYXRoPgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+';

const darkRedCircle =
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+57qi6ImyZGFya0AxeDwvdGl0bGU+CiAgICA8ZyBpZD0i57O757uf566h55CGIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0i57yW57uELTciPgogICAgICAgICAgICA8Y2lyY2xlIGlkPSLmpK3lnIblvaIiIGZpbGw9IiMxRjIzMjkiIGN4PSI2IiBjeT0iNiIgcj0iNiI+PC9jaXJjbGU+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuW9oueKtue7k+WQiCIgZmlsbD0iI0ZGRkZGRiIgZmlsbC1ydWxlPSJub256ZXJvIj48L3BhdGg+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuakreWchuW9ouWkh+S7vS03IiBmaWxsPSIjRTMyMDIwIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==';

const lightCircles = [
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+6JOd6ImyMkAxeDwvdGl0bGU+CiAgICA8ZyBpZD0i57O757uf566h55CGIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0i5ZOB54mM6JOdIj4KICAgICAgICAgICAgPGNpcmNsZSBpZD0i5qSt5ZyG5b2iIiBmaWxsPSIjRkZGRkZGIiBjeD0iNiIgY3k9IjYiIHI9IjYiPjwvY2lyY2xlPgogICAgICAgICAgICA8cGF0aCBkPSJNNiwyIEMzLjc5MDg2MSwyIDIsMy43OTA4NjEgMiw2IEMyLDguMjA5MTM5IDMuNzkwODYxLDEwIDYsMTAgQzguMjA5MTM5LDEwIDEwLDguMjA5MTM5IDEwLDYgQzEwLDMuNzkwODYxIDguMjA5MTM5LDIgNiwyIFogTTYsNCBDNy4xMDQ1Njk1LDQgOCw0Ljg5NTQzMDUgOCw2IEM4LDcuMTA0NTY5NSA3LjEwNDU2OTUsOCA2LDggQzQuODk1NDMwNSw4IDQsNy4xMDQ1Njk1IDQsNiBDNCw0Ljg5NTQzMDUgNC44OTU0MzA1LDQgNiw0IFoiIGlkPSLlvaLnirbnu5PlkIgiIGZpbGw9IiNGRkZGRkYiIGZpbGwtcnVsZT0ibm9uemVybyI+PC9wYXRoPgogICAgICAgICAgICA8cGF0aCBkPSJNNiwyIEMzLjc5MDg2MSwyIDIsMy43OTA4NjEgMiw2IEMyLDguMjA5MTM5IDMuNzkwODYxLDEwIDYsMTAgQzguMjA5MTM5LDEwIDEwLDguMjA5MTM5IDEwLDYgQzEwLDMuNzkwODYxIDguMjA5MTM5LDIgNiwyIFogTTYsNCBDNy4xMDQ1Njk1LDQgOCw0Ljg5NTQzMDUgOCw2IEM4LDcuMTA0NTY5NSA3LjEwNDU2OTUsOCA2LDggQzQuODk1NDMwNSw4IDQsNy4xMDQ1Njk1IDQsNiBDNCw0Ljg5NTQzMDUgNC44OTU0MzA1LDQgNiw0IFoiIGlkPSLmpK3lnIblvaLlpIfku70tNyIgZmlsbD0iIzAwNjJEQyIgZmlsbC1ydWxlPSJub256ZXJvIj48L3BhdGg+CiAgICAgICAgPC9nPgogICAgPC9nPgo8L3N2Zz4=',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+5aSp56m66JOdQDF4PC90aXRsZT4KICAgIDxnIGlkPSLns7vnu5/nrqHnkIYiIHN0cm9rZT0ibm9uZSIgc3Ryb2tlLXdpZHRoPSIxIiBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPgogICAgICAgIDxnIGlkPSLnvJbnu4QtNyI+CiAgICAgICAgICAgIDxjaXJjbGUgaWQ9IuakreWchuW9oiIgZmlsbD0iI0ZGRkZGRiIgY3g9IjYiIGN5PSI2IiByPSI2Ij48L2NpcmNsZT4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5b2i54q257uT5ZCIIiBmaWxsPSIjRkZGRkZGIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5qSt5ZyG5b2i5aSH5Lu9LTciIGZpbGw9IiMzREI2RkMiIGZpbGwtcnVsZT0ibm9uemVybyI+PC9wYXRoPgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+5p2o5p+z57u/QDF4PC90aXRsZT4KICAgIDxnIGlkPSLns7vnu5/nrqHnkIYiIHN0cm9rZT0ibm9uZSIgc3Ryb2tlLXdpZHRoPSIxIiBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPgogICAgICAgIDxnIGlkPSLnvJbnu4QtNyI+CiAgICAgICAgICAgIDxjaXJjbGUgaWQ9IuakreWchuW9oiIgZmlsbD0iI0ZGRkZGRiIgY3g9IjYiIGN5PSI2IiByPSI2Ij48L2NpcmNsZT4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5b2i54q257uT5ZCIIiBmaWxsPSIjRkZGRkZGIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5qSt5ZyG5b2i5aSH5Lu9LTciIGZpbGw9IiM4MUJBMDYiIGZpbGwtcnVsZT0ibm9uemVybyI+PC9wYXRoPgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+56Kn546J6Z2SQDF4PC90aXRsZT4KICAgIDxnIGlkPSLns7vnu5/nrqHnkIYiIHN0cm9rZT0ibm9uZSIgc3Ryb2tlLXdpZHRoPSIxIiBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPgogICAgICAgIDxnIGlkPSLnvJbnu4QtNyI+CiAgICAgICAgICAgIDxjaXJjbGUgaWQ9IuakreWchuW9oiIgZmlsbD0iI0ZGRkZGRiIgY3g9IjYiIGN5PSI2IiByPSI2Ij48L2NpcmNsZT4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5b2i54q257uT5ZCIIiBmaWxsPSIjRkZGRkZGIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5qSt5ZyG5b2i5aSH5Lu9LTciIGZpbGw9IiMzRENGRDQiIGZpbGwtcnVsZT0ibm9uemVybyI+PC9wYXRoPgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+6aaZ6IqL57SrQDF4PC90aXRsZT4KICAgIDxnIGlkPSLns7vnu5/nrqHnkIYiIHN0cm9rZT0ibm9uZSIgc3Ryb2tlLXdpZHRoPSIxIiBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPgogICAgICAgIDxnIGlkPSLnvJbnu4QtNyI+CiAgICAgICAgICAgIDxjaXJjbGUgaWQ9IuakreWchuW9oiIgZmlsbD0iI0ZGRkZGRiIgY3g9IjYiIGN5PSI2IiByPSI2Ij48L2NpcmNsZT4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5b2i54q257uT5ZCIIiBmaWxsPSIjRkZGRkZGIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5qSt5ZyG5b2i5aSH5Lu9LTciIGZpbGw9IiM2RDQ3RjUiIGZpbGwtcnVsZT0ibm9uemVybyI+PC9wYXRoPgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+57u/6ImyQDF4PC90aXRsZT4KICAgIDxnIGlkPSLns7vnu5/nrqHnkIYiIHN0cm9rZT0ibm9uZSIgc3Ryb2tlLXdpZHRoPSIxIiBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPgogICAgICAgIDxnIGlkPSLnvJbnu4QtNyI+CiAgICAgICAgICAgIDxjaXJjbGUgaWQ9IuakreWchuW9oiIgZmlsbD0iI0ZGRkZGRiIgY3g9IjYiIGN5PSI2IiByPSI2Ij48L2NpcmNsZT4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5b2i54q257uT5ZCIIiBmaWxsPSIjRkZGRkZGIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5qSt5ZyG5b2i5aSH5Lu9LTciIGZpbGw9IiMyREI0N0MiIGZpbGwtcnVsZT0ibm9uemVybyI+PC9wYXRoPgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+6aOO5L+h57SrQDF4PC90aXRsZT4KICAgIDxnIGlkPSLns7vnu5/nrqHnkIYiIHN0cm9rZT0ibm9uZSIgc3Ryb2tlLXdpZHRoPSIxIiBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPgogICAgICAgIDxnIGlkPSLnvJbnu4QtNyI+CiAgICAgICAgICAgIDxjaXJjbGUgaWQ9IuakreWchuW9oiIgZmlsbD0iI0ZGRkZGRiIgY3g9IjYiIGN5PSI2IiByPSI2Ij48L2NpcmNsZT4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5b2i54q257uT5ZCIIiBmaWxsPSIjRkZGRkZGIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICAgICAgPHBhdGggZD0iTTYsMiBDMy43OTA4NjEsMiAyLDMuNzkwODYxIDIsNiBDMiw4LjIwOTEzOSAzLjc5MDg2MSwxMCA2LDEwIEM4LjIwOTEzOSwxMCAxMCw4LjIwOTEzOSAxMCw2IEMxMCwzLjc5MDg2MSA4LjIwOTEzOSwyIDYsMiBaIE02LDQgQzcuMTA0NTY5NSw0IDgsNC44OTU0MzA1IDgsNiBDOCw3LjEwNDU2OTUgNy4xMDQ1Njk1LDggNiw4IEM0Ljg5NTQzMDUsOCA0LDcuMTA0NTY5NSA0LDYgQzQsNC44OTU0MzA1IDQuODk1NDMwNSw0IDYsNCBaIiBpZD0i5qSt5ZyG5b2i5aSH5Lu9LTciIGZpbGw9IiNCRDQ1RTgiIGZpbGwtcnVsZT0ibm9uemVybyI+PC9wYXRoPgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+',
];

const darkCircles = [
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+6JOd6ImyZGFya0AxeDwvdGl0bGU+CiAgICA8ZyBpZD0i57O757uf566h55CGIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0i5ZOB54mM6JOdIj4KICAgICAgICAgICAgPGNpcmNsZSBpZD0i5qSt5ZyG5b2iIiBmaWxsPSIjMUYyMzI5IiBjeD0iNiIgY3k9IjYiIHI9IjYiPjwvY2lyY2xlPgogICAgICAgICAgICA8cGF0aCBkPSJNNiwyIEMzLjc5MDg2MSwyIDIsMy43OTA4NjEgMiw2IEMyLDguMjA5MTM5IDMuNzkwODYxLDEwIDYsMTAgQzguMjA5MTM5LDEwIDEwLDguMjA5MTM5IDEwLDYgQzEwLDMuNzkwODYxIDguMjA5MTM5LDIgNiwyIFogTTYsNCBDNy4xMDQ1Njk1LDQgOCw0Ljg5NTQzMDUgOCw2IEM4LDcuMTA0NTY5NSA3LjEwNDU2OTUsOCA2LDggQzQuODk1NDMwNSw4IDQsNy4xMDQ1Njk1IDQsNiBDNCw0Ljg5NTQzMDUgNC44OTU0MzA1LDQgNiw0IFoiIGlkPSLlvaLnirbnu5PlkIgiIGZpbGw9IiNGRkZGRkYiIGZpbGwtcnVsZT0ibm9uemVybyI+PC9wYXRoPgogICAgICAgICAgICA8cGF0aCBkPSJNNiwyIEMzLjc5MDg2MSwyIDIsMy43OTA4NjEgMiw2IEMyLDguMjA5MTM5IDMuNzkwODYxLDEwIDYsMTAgQzguMjA5MTM5LDEwIDEwLDguMjA5MTM5IDEwLDYgQzEwLDMuNzkwODYxIDguMjA5MTM5LDIgNiwyIFogTTYsNCBDNy4xMDQ1Njk1LDQgOCw0Ljg5NTQzMDUgOCw2IEM4LDcuMTA0NTY5NSA3LjEwNDU2OTUsOCA2LDggQzQuODk1NDMwNSw4IDQsNy4xMDQ1Njk1IDQsNiBDNCw0Ljg5NTQzMDUgNC44OTU0MzA1LDQgNiw0IFoiIGlkPSLmpK3lnIblvaLlpIfku70tNyIgZmlsbD0iIzAwNzdGRiIgZmlsbC1ydWxlPSJub256ZXJvIj48L3BhdGg+CiAgICAgICAgPC9nPgogICAgPC9nPgo8L3N2Zz4=',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+5aSp56m66JOdZGFya0AxeDwvdGl0bGU+CiAgICA8ZyBpZD0i57O757uf566h55CGIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0i57yW57uELTciPgogICAgICAgICAgICA8Y2lyY2xlIGlkPSLmpK3lnIblvaIiIGZpbGw9IiMxRjIzMjkiIGN4PSI2IiBjeT0iNiIgcj0iNiI+PC9jaXJjbGU+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuW9oueKtue7k+WQiCIgZmlsbD0iI0ZGRkZGRiIgZmlsbC1ydWxlPSJub256ZXJvIj48L3BhdGg+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuakreWchuW9ouWkh+S7vS03IiBmaWxsPSIjMzdBNEUzIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+5p2o5p+z57u/ZGFya0AxeDwvdGl0bGU+CiAgICA8ZyBpZD0i57O757uf566h55CGIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0i57yW57uELTciPgogICAgICAgICAgICA8Y2lyY2xlIGlkPSLmpK3lnIblvaIiIGZpbGw9IiMxRjIzMjkiIGN4PSI2IiBjeT0iNiIgcj0iNiI+PC9jaXJjbGU+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuW9oueKtue7k+WQiCIgZmlsbD0iI0ZGRkZGRiIgZmlsbC1ydWxlPSJub256ZXJvIj48L3BhdGg+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuakreWchuW9ouWkh+S7vS03IiBmaWxsPSIjNzNBNDA5IiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+56Kn546J6Z2SZGFya0AxeDwvdGl0bGU+CiAgICA8ZyBpZD0i57O757uf566h55CGIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0i57yW57uELTciPgogICAgICAgICAgICA8Y2lyY2xlIGlkPSLmpK3lnIblvaIiIGZpbGw9IiMxRjIzMjkiIGN4PSI2IiBjeT0iNiIgcj0iNiI+PC9jaXJjbGU+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuW9oueKtue7k+WQiCIgZmlsbD0iI0ZGRkZGRiIgZmlsbC1ydWxlPSJub256ZXJvIj48L3BhdGg+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuakreWchuW9ouWkh+S7vS03IiBmaWxsPSIjMzBCN0JCIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+6aaZ6IqL57SrZGFya0AxeDwvdGl0bGU+CiAgICA8ZyBpZD0i57O757uf566h55CGIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0i57yW57uELTciPgogICAgICAgICAgICA8Y2lyY2xlIGlkPSLmpK3lnIblvaIiIGZpbGw9IiMxRjIzMjkiIGN4PSI2IiBjeT0iNiIgcj0iNiI+PC9jaXJjbGU+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuW9oueKtue7k+WQiCIgZmlsbD0iI0ZGRkZGRiIgZmlsbC1ydWxlPSJub256ZXJvIj48L3BhdGg+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuakreWchuW9ouWkh+S7vS03IiBmaWxsPSIjNjEzREU0IiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+57u/6ImyZGFya0AxeDwvdGl0bGU+CiAgICA8ZyBpZD0i57O757uf566h55CGIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0i57yW57uELTciPgogICAgICAgICAgICA8Y2lyY2xlIGlkPSLmpK3lnIblvaIiIGZpbGw9IiMxRjIzMjkiIGN4PSI2IiBjeT0iNiIgcj0iNiI+PC9jaXJjbGU+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuW9oueKtue7k+WQiCIgZmlsbD0iI0ZGRkZGRiIgZmlsbC1ydWxlPSJub256ZXJvIj48L3BhdGg+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuakreWchuW9ouWkh+S7vS03IiBmaWxsPSIjMjlBMzcwIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==',
  'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTJweCIgaGVpZ2h0PSIxMnB4IiB2aWV3Qm94PSIwIDAgMTIgMTIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+6aOO5L+h57SrZGFya0AxeDwvdGl0bGU+CiAgICA8ZyBpZD0i57O757uf566h55CGIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0i57yW57uELTciPgogICAgICAgICAgICA8Y2lyY2xlIGlkPSLmpK3lnIblvaIiIGZpbGw9IiMxRjIzMjkiIGN4PSI2IiBjeT0iNiIgcj0iNiI+PC9jaXJjbGU+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuW9oueKtue7k+WQiCIgZmlsbD0iI0ZGRkZGRiIgZmlsbC1ydWxlPSJub256ZXJvIj48L3BhdGg+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik02LDIgQzMuNzkwODYxLDIgMiwzLjc5MDg2MSAyLDYgQzIsOC4yMDkxMzkgMy43OTA4NjEsMTAgNiwxMCBDOC4yMDkxMzksMTAgMTAsOC4yMDkxMzkgMTAsNiBDMTAsMy43OTA4NjEgOC4yMDkxMzksMiA2LDIgWiBNNiw0IEM3LjEwNDU2OTUsNCA4LDQuODk1NDMwNSA4LDYgQzgsNy4xMDQ1Njk1IDcuMTA0NTY5NSw4IDYsOCBDNC44OTU0MzA1LDggNCw3LjEwNDU2OTUgNCw2IEM0LDQuODk1NDMwNSA0Ljg5NTQzMDUsNCA2LDQgWiIgaWQ9IuakreWchuW9ouWkh+S7vS03IiBmaWxsPSIjQTg0M0NEIiBmaWxsLXJ1bGU9Im5vbnplcm8iPjwvcGF0aD4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg==',
];

export const showCircles = {
  redCircle: lightRedCircle,
  normalCircles: lightCircles,
};

// 根据主题设置展示的圆圈
export function setCircles() {
  const mode = getThemeMode();
  if (mode === 'light') {
    showCircles.redCircle = lightRedCircle;
    showCircles.normalCircles = lightCircles;
  } else {
    showCircles.redCircle = darkRedCircle;
    showCircles.normalCircles = darkCircles;
  }
}
