//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface ILoginRule {
  Enabled?: boolean;
  ID: string;
  IP?: string;
  Mac?: string;
  EndTime?: string;
  StartTime?: string;
}

// VNC数据
export interface IVncData {
  Enabled?: boolean;
  Port?: number | string;
  SessionTimeoutMinutes?: number | string;
  KeyboardLayout?: string;
  VNCPassword?: string;
  sureVNCPassword?: string;
  PasswordValidityDays?: number | string;
  LoginRuleInfo?: ILoginRule[];
  LoginRule?: string[];
  SSLEncryptionEnabled?: boolean;
  MaximumNumberOfSessions?: number | string;
  NumberOfActiveSessions?: number | string;
  ActivatedSessionsType?: string | null;
  PasswordComplexityCheckEnabled?: boolean | null;
  // 其他的
  [propName: string]: any;
}

// 校验
export interface IRule {
  // 数据类型
  type?: string;
  // 是否必须
  required?: boolean;
  // 最小值
  min?: number;
  // 最大值
  max?: number;
  // 是否要求是整数
  isInteger?: boolean;
  // 长度
  length?: number;
  // 最小长度
  minLength?: number;
  // 最大长度
  maxLength?: number;
  // 和谁相等  直接和一个字符串相等 或者 和传入的某个对象的属性相等
  equals?: string | IEqualsObj;
  // 错误的校验提示信息
  message?: string;
  // popover的文本
  tipText?: string;
  // 自定义校验函数
  validator?: any;
  // 校验触发方式
  trigger?: string;
  // 其他的
  [propName: string]: any;
}

// 和谁相等
export interface IEqualsObj {
  // 相等的对象的父亲-即属于哪个对象
  aimObj: {
    [propName: string]: any;
  };
  // 在该对象中的键
  aimObjKey: string;
  [propName: string]: any;
}
