//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MainMenuId, SysId, MaintanceId, UserId, ServiceId, ManageId } from '@/model/base-enum';
import { IMainMenu, ISecondMenu, IThirdMenu } from '@/model/base-interface';

// 系统管理子菜单
const systemSecondMenu: Array<ISecondMenu> = [
  {
    id: SysId.Info,
    navId: 'secSysInfo',
    hide: false,
    label: 'COMMON_SYSTEM_INFO',
    router: '/navigate/system/info',
    iconClass: 'icon-info',
  },
  {
    id: SysId.Monitor,
    navId: 'secSysMonitor',
    hide: false,
    label: 'COMMON_SYSTEM_PERFORM',
    router: '/navigate/system/monitor',
    iconClass: 'icon-monitor',
  },
  {
    id: SysId.Storage,
    navId: 'secSysStorage',
    hide: false,
    label: 'COMMON_SYSTEM_STORAGE',
    router: '/navigate/system/storage',
    iconClass: 'icon-store',
  },
  {
    id: SysId.Power,
    navId: 'secSysPower',
    hide: false,
    label: 'COMMON_SYSTEM_POWER',
    router: '/navigate/system/power',
    iconClass: 'icon-power',
  },
  {
    id: SysId.Fans,
    navId: 'secSysFans',
    hide: true,
    label: 'COMMON_SYSTEM_FANS',
    router: '/navigate/system/fans',
    iconClass: 'icon-fans',
  },
  {
    id: SysId.Bios,
    navId: 'secSysBios',
    hide: false,
    label: 'COMMON_SYSTEM_BIOS',
    router: '/navigate/system/bios-settings',
    iconClass: 'icon-bios',
  },
  {
    id: SysId.Partity,
    navId: 'secSysPartity',
    hide: true,
    label: 'COMMON_SYSTEM_PARTITY',
    router: '/navigate/system/fusion-par',
    iconClass: 'icon-partity',
  },
];
// 维护诊断子菜单
const maintanceSecondMenu: Array<ISecondMenu> = [
  {
    label: 'ALARM_EVENT',
    router: '/navigate/maintenance/alarm',
    iconClass: 'icon-alarm',
    id: MaintanceId.Event,
    navId: 'secMainEvent',
    hide: false,
  },
  {
    label: 'ALARM_REPORT',
    router: '/navigate/maintenance/report/',
    iconClass: 'icon-report',
    id: MaintanceId.Report,
    navId: 'secMainReport',
    hide: false,
  },
  {
    label: 'COMMON_MAINTANCE_FDM',
    router: '/navigate/maintenance/fdm',
    iconClass: 'icon-fdm',
    id: MaintanceId.Fdm,
    navId: 'secMainFdm',
    hide: true,
  },
  {
    label: 'VIDEO_SCREEN',
    router: '/navigate/maintenance/video',
    iconClass: 'icon-video',
    id: MaintanceId.Video,
    navId: 'secMainVideo',
    hide: true,
  },
  {
    label: 'SYSTEM_LOG',
    router: '/navigate/maintenance/diagnostics',
    iconClass: 'icon-systemLog',
    id: MaintanceId.SysLog,
    navId: 'secMainSysLog',
    hide: true,
  },
  {
    label: 'COMMON_MAINTANCE_IBMC_LOG',
    router: '/navigate/maintenance/ibmc-logs',
    iconClass: 'icon-ibmcLog',
    id: MaintanceId.IbmcLog,
    navId: 'secMainIbmcLog',
    hide: false,
  },
  {
    label: 'WORK_NOTE',
    router: '/navigate/maintenance/work-records',
    iconClass: 'icon-work',
    id: MaintanceId.Note,
    navId: 'secMainNote',
    hide: false,
  },
  {
    label: 'ASSET_MAINTANCE',
    router: '/navigate/maintenance/asset-maintance',
    iconClass: 'icon-asset',
    id: MaintanceId.Asset,
    navId: 'secMainAsset',
    hide: false,
  },
];
// 用户与安全子菜单
const userSafeSecondMenu: Array<ISecondMenu> = [
  {
    label: 'COMMON_USER_LOCALUSERS',
    router: '/navigate/user/local-users',
    iconClass: 'icon-local',
    id: UserId.LocalUsers,
    navId: 'secUserLocalUsers',
    hide: false,
  },
  {
    label: 'COMMON_USER_LDAP',
    router: '/navigate/user/ldap',
    iconClass: 'icon-ldap',
    id: UserId.Ldap,
    navId: 'secUserLDAP',
    hide: false,
  },
  {
    label: 'COMMON_USER_KERBEROS',
    router: '/navigate/user/kerberos',
    iconClass: 'icon-kerberos',
    id: UserId.Kerberos,
    navId: 'secUserKerberos',
    hide: true,
  },
  {
    label: 'COMMON_USER_TWO_FACTOR',
    router: '/navigate/user/two-factor',
    iconClass: 'icon-twoFac',
    id: UserId.TwoFactor,
    navId: 'secUserTwoFactor',
    hide: true,
  },
  {
    label: 'COMMON_USER_ONLINE',
    router: '/navigate/user/online-users',
    iconClass: 'icon-online',
    id: UserId.Online,
    navId: 'secUserOnline',
    hide: true,
  },
  {
    label: 'COMMON_USER_SECURITY',
    router: '/navigate/user/security',
    iconClass: 'icon-security',
    id: UserId.Security,
    navId: 'secUserSecurity',
    hide: false,
  },
  {
    label: 'TPCM_TITLE',
    router: '/navigate/user/tpcm',
    iconClass: 'icon-tpcm',
    id: UserId.TrustedCompute,
    navId: 'tpcmPage',
    hide: true,
  },
  {
    label: 'IBMC_CERT_MANAGEMENT',
    router: '/navigate/user/certificate',
    iconClass: 'icon-security',
    id: UserId.Certificate,
    navId: 'secUserCertificate',
    hide: false,
  },
];
// 服务管理子菜单
const serviceManageSecondMenu: Array<ISecondMenu> = [
  {
    label: 'SERVICE_PORT_SERVICE',
    router: '/navigate/service/port',
    iconClass: 'icon-port',
    id: ServiceId.Port,
    navId: 'secPortService',
    hide: false,
  },
  {
    label: 'SERVICE_WEB_SERVICE',
    router: '/navigate/service/web',
    iconClass: 'icon-web',
    id: ServiceId.Web,
    navId: 'secWebService',
    hide: false,
  },
  {
    label: 'HOME_VIRTUALCONSOLE_TITLE',
    router: '/navigate/service/kvm',
    iconClass: 'icon-kvm',
    id: ServiceId.Kvm,
    navId: 'secKvmService',
    hide: false,
  },
  {
    label: 'SERVICE_VMM_ENABLE_LABEL',
    router: '/navigate/service/vmm',
    iconClass: 'icon-vmm',
    id: ServiceId.Vmm,
    navId: 'secVmmService',
    hide: false,
  },
  {
    label: 'SERVICE_VNC',
    router: '/navigate/service/vnc',
    iconClass: 'icon-vnc',
    id: ServiceId.Vnc,
    navId: 'secVncService',
    hide: false,
  },
  {
    label: 'SERVICE_SNMP',
    router: '/navigate/service/snmp',
    iconClass: 'icon-snmp',
    id: ServiceId.Snmp,
    navId: 'secSnmpService',
    hide: false,
  },
];
// IBMC管理子菜单
export const ibmcManageMentSecondMenu: Array<ISecondMenu> = [
  {
    label: 'IBMC_NETWORK',
    router: '/navigate/manager/network',
    iconClass: 'icon-network',
    id: ManageId.Network,
    navId: 'secNetworkConfig',
    hide: false,
  },
  {
    label: 'IBMC_LEFTMENU_NTP_TIME',
    router: '/navigate/manager/ntp',
    iconClass: 'icon-ntp',
    id: ManageId.Ntp,
    navId: 'secTimezoneConfig',
    hide: false,
  },
  {
    label: 'IBMC_FIMWARE_UPDATE',
    router: '/navigate/manager/upgrade',
    iconClass: 'icon-upgrade',
    id: ManageId.Upgrade,
    navId: 'secUpgradeConfig',
    hide: true,
  },
  {
    label: 'COMMON_CONFIG_UPDATE',
    router: '/navigate/manager/config-update',
    iconClass: 'icon-config',
    id: ManageId.Update,
    navId: 'secUpdateConfig',
    hide: true,
  },
  {
    label: 'COMMON_CONFIG_LANGUAGE',
    router: '/navigate/manager/language',
    iconClass: 'icon-language',
    id: ManageId.Language,
    navId: 'secLanguageConfig',
    hide: false,
  },
  {
    label: 'IBMC_LICENSE_MANAGE',
    router: '/navigate/manager/license',
    iconClass: 'icon-license',
    id: ManageId.License,
    navId: 'secLicenseConfig',
    hide: true,
  },
  {
    label: 'IBMA_TITLE',
    router: '/navigate/manager/ibma',
    iconClass: 'icon-ibma',
    id: ManageId.Ibma,
    navId: 'secIbmaConfig',
    hide: false,
  },
  {
    label: 'IBMC_SP_TITLE',
    router: '/navigate/manager/sp',
    iconClass: 'icon-sp',
    id: ManageId.Sp,
    navId: 'secSpConfig',
    hide: false,
  },
  {
    label: 'IBMC_USB_TITLE',
    router: '/navigate/manager/usb',
    iconClass: 'icon-usb',
    id: ManageId.USB,
    navId: 'secUSBConfig',
    hide: true,
  },
];

// 主菜单
const mainMenu: Array<IMainMenu> = [
  {
    id: MainMenuId.Home,
    label: 'COMMON_HEADER_HOME',
    router: '/navigate/home',
    children: [],
    dropState: false,
  },
  {
    id: MainMenuId.System,
    label: 'COMMON_HEADER_SYSTEM',
    router: '/navigate/system',
    children: systemSecondMenu,
    dropState: false,
  },
  {
    id: MainMenuId.Maintance,
    label: 'COMMON_HEADER_MAINTANCE',
    router: '/navigate/maintenance',
    children: maintanceSecondMenu,
    dropState: false,
  },
  {
    id: MainMenuId.User,
    label: 'COMMON_HEADER_USERS',
    router: '/navigate/user',
    children: userSafeSecondMenu,
    dropState: false,
  },
  {
    id: MainMenuId.Service,
    label: 'COMMON_HEADER_SERVICE',
    router: '/navigate/service',
    children: serviceManageSecondMenu,
    dropState: false,
  },
  {
    id: MainMenuId.Manager,
    label: 'IBMC_HEAD_IBMC_MAGAGE',
    router: '/navigate/manager',
    children: ibmcManageMentSecondMenu,
    dropState: false,
  },
];

// 用户与安全 - 安全配置 菜单
export const securityMenu: Array<IThirdMenu> = [
  {
    index: '1',
    label: 'SECURITY_ENHANCE',
    router: '/navigate/user/security/enhance',
    id: 'securityTabs_securityEnhance_a',
  },
  {
    index: '2',
    label: 'SECURITY_LOGIN_RULES',
    router: '/navigate/user/security/rule',
    id: 'securityTabs_loginRule_a',
  },
  {
    index: '3',
    label: 'SECURITY_AUTHORITY_MANAGEMENT',
    router: '/navigate/user/security/permission',
    id: 'securityTabs_authorityManagement_a',
  },
  {
    index: '4',
    label: 'SECURITY_LOGIN_SECURITY',
    router: '/navigate/user/security/notice',
    id: 'securityTabs_securityNotice_a',
  },
];

// 用户与安全 - 证书管理 菜单
export const certificateListMenu: Array<IThirdMenu> = [
  {
    index: '1',
    label: 'AUTOMATIC_CERTIFICATE_UPDATE',
    router: '/navigate/user/certificate/auto-certificate-update',
    id: 'certificateTabs_type3',
  },
  {
    index: '2',
    label: 'SERVICE_WBS_SSL_CRE_INFO',
    router: '/navigate/user/certificate/ssl-certificate',
    id: 'certificateTabs_type2',
  },
  {
    index: '3',
    label: 'IBMC_CA_CERT',
    router: '/navigate/user/certificate/ca-certificate-list',
    id: 'certificateTabs_type1',
  },
];

export const fansListMenu: Array<IThirdMenu> = [
  {
    index: '1',
    label: 'FAN_NAME',
    router: '/navigate/system/fans/fans-info',
    id: 'fans_type1',
  },
  {
    index: '2',
    label: 'SERVICE_WBS_SSL_CRE_INFO',
    router: '/navigate/system/fans/fans-sensor',
    id: 'fans_type2',
  },
];

export default mainMenu;
