//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouteRecordRaw } from 'vue-router';
import securityRoutes from './security/security-router';
import certificateRoutes from './certificate/certificate-router';
import twoFactorRoutes from './twofactor/twofactor-router';
import { forbidGuard } from '@/apps/app-bmc/guard/forbid.guard';
const userRouters: Array<RouteRecordRaw> = [
  {
    path: '/navigate/user/local-users',
    component: () => import('@/pages/User/Localuser/Localuser.vue'),
  },
  {
    path: '/navigate/user/ldap',
    component: () => import('@/pages/User/Ldap/Ldap.vue'),
  },
  {
    path: '/navigate/user/kerberos',
    component: () => import('@/pages/User/Kerberos/Kerberos.vue'),
    beforeEnter: [forbidGuard],
  },
  {
    path: '/navigate/user/two-factor',
    component: () => import('@/pages/User/TwoFactor/TwoFactor.vue'),
    redirect: '/navigate/user/two-factor/client',
    children: twoFactorRoutes,
  },
  {
    path: '/navigate/user/online-users',
    component: () => import('@/pages/User/OnlineUser/OnlineUser.vue'),
  },
  {
    path: '/navigate/user/security',
    component: () => import('@/pages/User/Security/Security.vue'),
    redirect: securityRoutes[0].path,
    children: securityRoutes,
  },
  {
    path: '/navigate/user/tpcm',
    component: () => import('@/pages/User/Tpcm/tpcm.vue'),
  },
  {
    path: '/navigate/user/certificate',
    component: () => import('@/pages/User/Certificate/Certificate.vue'),
    redirect: certificateRoutes[0].path,
    children: certificateRoutes,
  },
];

export default userRouters;
