//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouteRecordRaw } from 'vue-router';
import { securityMenu } from '@/apps/app-bmc/store/menu-list';

const securityRoutes: Array<RouteRecordRaw> = [
  {
    path: securityMenu[0].router,
    component: () => import('@/pages/User/Security/securtyPages/SecurityEnhancement.vue'),
  },
  {
    path: securityMenu[1].router,
    component: () => import('@/pages/User/Security/securtyPages/LoginRules/LoginRules.vue'),
  },
  {
    path: securityMenu[2].router,
    component: () => import('@/pages/User/Security/securtyPages/PermissionManagement/PermissionManagement.vue'),
  },
  {
    path: securityMenu[3].router,
    component: () => import('@/pages/User/Security/securtyPages/SecurityBulletin/SecurityBulletin.vue'),
  },
];
export default securityRoutes;
