//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouteRecordRaw } from 'vue-router';
import {
  powerPredictedGuard,
  multihostGuard,
  infoPredictedGuard,
  powerConverterGuard,
  energySavingGuard,
} from '@/apps/app-bmc/guard';
import { storageGuard } from '@/apps/app-bmc/guard/storage.guard';

const powerRoutes: Array<RouteRecordRaw> = [
  {
    path: '/navigate/system/power/info',
    component: () => import('@/pages/System/Power/components/info/PowerInfo.vue'),
    beforeEnter: infoPredictedGuard,
  },
  {
    path: '/navigate/system/power/converter',
    component: () => import('@/pages/System/Power/components/converter/PowerConverter.vue'),
    beforeEnter: powerConverterGuard,
  },
  {
    path: '/navigate/system/power/capping',
    component: () => import('@/pages/System/Power/components/capping/PowerCapping.vue'),
  },
  {
    path: '/navigate/system/power/control',
    component: () => import('@/pages/System/Power/components/control/PowerControl.vue'),
    beforeEnter: storageGuard,
  },
  {
    path: '/navigate/system/power/multi-control',
    component: () => import('@/pages/System/Power/components/control/MultiPowerControl.vue'),
    beforeEnter: multihostGuard,
  },
  {
    path: '/navigate/system/power/energy',
    component: () => import('@/pages/System/Power/components/energy/PowerEnergy.vue'),
    beforeEnter: powerPredictedGuard,
  },
  {
    path: '/navigate/system/power',
    redirect: '/navigate/system/power/info',
  },
  {
    path: '/navigate/system/power/energy-saving',
    component: () => import('@/pages/System/Power/components/EnergySaving/EnergySaving.vue'),
    beforeEnter: energySavingGuard,
  },
];
export default powerRoutes;