//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { setStoreData } from '@/utils/composition';
import { RouteLocationNormalized, NavigationGuardNext, RouteLocationRaw } from 'vue-router';
import { getOverView } from '@/pages/Home/services/home.service';

// 判断是否为字节
export function reportGuard(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext
): void | Error | RouteLocationRaw | boolean | Promise<any> {
  getOverView()
    .then((res: any) => {
      const type = res.data.Customer || '';
      if (type === 'ByteDance') {
        if (to.path === '/navigate/maintenance/report/syslog') {
          next('/navigate/maintenance/report/syslogdb');
          setStoreData('loct', 'customerType', 'ByteDance');
        } else {
          next();
        }
      } else {
        setStoreData('loct', 'customerType', '');
        next();
      }
    })
    .catch((err: any) => {
      next();
      setStoreData('loct', 'customerType', '');
    });
}
