//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouterChangeReason } from '@/model/base-enum';
import { getGenericInfo } from '@/services/header/header.service';
import { getStoreData, setStoreData } from '@/utils/composition';
import { NavigationGuardNext, RouteLocationNormalized } from 'vue-router';
import { getRandomNumber } from '@/utils/utils';

// 这类具体的路由守卫主要是验证环境是否支持该功能，以防止不支持该功能的环境可以通过路由跳转的方式进入该页面
export function armGuard(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext,
): void {
  const supported = getStoreData('loct', 'armspt');
  if (supported !== null && supported !== undefined) {
    // 非Arm架构时，允许跳转，Arm架构阻止跳转
    if (supported === true) {
      setStoreData('event', 'routeChangeError', RouterChangeReason.invalid + getRandomNumber());
    } else {
      next();
    }
  } else {
    getGenericInfo().then(res => {
      if (res.armSupport === true) {
        setStoreData('event', 'routeChangeError', RouterChangeReason.invalid + getRandomNumber());
      } else {
        next();
      }
    });
  }
}
