//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import {
  downloadOpData,
  downloadRunData,
  downloadOpUrlData,
  downloadRunUrlData,
  downloadSecurityLogData,
  downloadSerUrlData,
} from '../../mock/maintance/ibmclog/data/index';

const info = {
  productionInfo: '/UI/Rest/System/ProductInfo',
  processor: '/UI/Rest/System/Processor',
  memory: '/UI/Rest/System/Memory',
  boards: '/UI/Rest/System/Boards',
};

const system = {
  info,
};

const monitor = {
  cpu: '/UI/Rest/System/ProcesserUsage',
  memory: '/UI/Rest/System/MemoryUsage',
  network: '/UI/Rest/System/NetworkBandwidthUsage',
  hardDisk: '/UI/Rest/System/DiskUsage',
  clearHistory: '/UI/Rest/System/NetworkBandwidthUsage/ClearHistory',
  setCpuThreshold: '/UI/Rest/System/ProcesserUsage',
};

const userAndSecurity = {
  permissionManagement: '/UI/Rest/AccessMgnt/RightManagement',
  securityBulletin: '/UI/Rest/AccessMgnt/SecurityBanner',
  loginRules: '/UI/Rest/AccessMgnt/LoginRule',
  kerberos: '/UI/Rest/AccessMgnt/Kerberos',
  kerberosState: '/UI/Rest/AccessMgnt/Kerberos/State',
  ImportKeyTab: '/UI/Rest/AccessMgnt/Kerberos/ImportKeyTab',
  sslCertificates: '/UI/Rest/AccessMgnt/CertMgnt/CertsInformation/1',
};

const ibma = {
  getIbmaData: '/UI/Rest/BMCSettings/BMA',
  getIbmaLogData: '/UI/Rest/BMCSettings/BMA/Logs',
  getIbmaLogTempData: '/UI/Rest/BMCSettings/BMA/Logs/Temp',
  usbStickControl: '/UI/Rest/BMCSettings/BMA/USBStickControl',
  generateStartupFile: '/UI/Rest/Services/KVM/GenerateStartupFile',
  keepAlive: '/UI/Rest/KeepAlive',
};

const ibmc = {
  getUpgrade: '/UI/Rest/BMCSettings/UpdateService',
  SPUpdateFileList: '/UI/Rest/BMCSettings/UpdateService/SPUpdateFileList',
  firmwareUpdate: '/UI/Rest/BMCSettings/UpdateService/FirmwareUpdate',
  SPFWUpdate: '/UI/Rest/BMCSettings/UpdateService/SPFWUpdate',
  resetFirmware: '/UI/Rest/BMCSettings/UpdateService/Reset',
  rollBackFirmware: '/UI/Rest/BMCSettings/UpdateService/SwitchImage',
  queryTaskProgress: '/UI/Rest/BMCSettings/UpdateService/UpdateProgress',
  getPowerControl: '/UI/Rest/System/PowerControl',
  getMultiPowerControl: '/UI/Rest/Chassis/PowerControl',
  DeleteSPUpdateFile: '/UI/Rest/BMCSettings/UpdateService/DeleteSPUpdateFile',
};
const exportConfig = {
  genericInfo: '/UI/Rest/GenericInfo',
  exportConfig: '/UI/Rest/BMCSettings/Configuration/ExportConfig',
};

const maintance = {
  systemlog: {
    systemDiagnostic: '/UI/Rest/Maintenance/SystemDiagnostic',
    processor: '/UI/Rest/System/Processor',
    downloadBlackBox: '/UI/Rest/Maintenance/SystemDiagnostic/DownloadBlackBox',
    downloadSDIBlackBox: '/UI/Rest/Maintenance/SystemDiagnostic/DownloadBlackBoxofSdi',
    downloadBlackBoxResUrl: '/UI/Rest/Maintenance/SystemDiagnostic/downloadBlackBoxResUrl',
    downloadSerialPortData: '/UI/Rest/Maintenance/SystemDiagnostic/DownloadSerialPortData',
    DownloadSerialPortDataResUrl:
      '/UI/Rest/Maintenance/SystemDiagnostic/DownloadSerialPortDataResUrl',
    downloadNpuLog: '/UI/Rest/Maintenance/SystemDiagnostic/DownloadNpuLog',
    downloadNpuLogResUrl: '/UI/Rest/Maintenance/SystemDiagnostic/downloadNpuLogResUrl',
  },
  worknote: {
    workRecord: '/UI/Rest/Maintenance/WorkRecord',
    sessions: '/UI/Rest/Sessions',
  },
  fdm: {
    getFdmData: '/UI/Rest/Maintenance/FDM',
    cpu1: '/UI/Rest/Maintenance/FDM/Device/Cpu1',
    comMotherBoard: '/UI/Rest/Maintenance/FDM/Device/ComMotherBoard',
    memory000: '/UI/Rest/Maintenance/FDM/Device/Memory000',
    lomCard: '/UI/Rest/Maintenance/FDM/Device/LomCard',
    raid1: '/UI/Rest/Maintenance/FDM/Device/Raid-1',
    hddBackplane2: '/UI/Rest/Maintenance/FDM/Device/HDDBackplane-2',
    hdd1: '/UI/Rest/Maintenance/FDM/Device/Hdd1-2',
    hdd2: '/UI/Rest/Maintenance/FDM/Device/Hdd2-2',
    cpu2: '/UI/Rest/Maintenance/FDM/Device/Cpu2',
    onepower1: '/UI/Rest/Maintenance/FDM/Device/onepower-4',
    onepower2: '/UI/Rest/Maintenance/FDM/Device/onepower-5',
    fan1: '/UI/Rest/Maintenance/FDM/Device/fan1',
    fan2: '/UI/Rest/Maintenance/FDM/Device/fan2',
    fan3: '/UI/Rest/Maintenance/FDM/Device/fan3',
    fan4: '/UI/Rest/Maintenance/FDM/Device/fan4',
    comChassis: '/UI/Rest/Maintenance/FDM/Device/ComChassis',
    eventReports65537: '/UI/Rest/Maintenance/FDM/65537/EventReports',
    eventReports69632: '/UI/Rest/Maintenance/FDM/69632/EventReports',
    eventReports65793: '/UI/Rest/Maintenance/FDM/65793/EventReports',
    eventReports68864: '/UI/Rest/Maintenance/FDM/68864/EventReports',
    eventReports67073: '/UI/Rest/Maintenance/FDM/67073/EventReports',
    eventReports66817: '/UI/Rest/Maintenance/FDM/66817/EventReports',
    eventReports66049: '/UI/Rest/Maintenance/FDM/66049/EventReports',
    eventReports66050: '/UI/Rest/Maintenance/FDM/66050/EventReports',
    eventReports65538: '/UI/Rest/Maintenance/FDM/65538/EventReports',
    eventReports66305: '/UI/Rest/Maintenance/FDM/66305/EventReports',
    eventReports66306: '/UI/Rest/Maintenance/FDM/66306/EventReports',
    eventReports66561: '/UI/Rest/Maintenance/FDM/66561/EventReports',
    eventReports66562: '/UI/Rest/Maintenance/FDM/66562/EventReports',
    eventReports66563: '/UI/Rest/Maintenance/FDM/66563/EventReports',
    eventReports66564: '/UI/Rest/Maintenance/FDM/66564/EventReports',
    eventReports70145: '/UI/Rest/Maintenance/FDM/70145/EventReports',
  },
  ibmcLog: {
    ibmcLogOperation: '/UI/Rest/Maintenance/OperationLog',
    ibmcLogRun: '/UI/Rest/Maintenance/RunLog',
    ibmcLogSecurity: '/UI/Rest/Maintenance/SecurityLog',
    DownloadOperation: '/UI/Rest/Maintenance/DownloadOperationLog',
    DownloadRunLog: '/UI/Rest/Maintenance/DownloadRunLog',
    DownloadSecurityLog: '/UI/Rest/Maintenance/DownloadSecurityLog',
    Optask: downloadOpData.url,
    Runtask: downloadRunData.url,
    Sertask: downloadSecurityLogData.url,
    downloadOpUrl: downloadOpUrlData.url,
    downloadRunUrl: downloadRunUrlData.url,
    downloadSerUrl: downloadSerUrlData.url,
  },
  video: {
    systemDiagnostic: '/UI/Rest/Maintenance/SystemDiagnostic',
    exportVideoStartupFile: '/UI/Rest/Maintenance/SystemDiagnostic/ExportVideoStartupFile',
    stopVideo: '/UI/Rest/Maintenance/VideoPlayLogout',
    downloadVideo: '/UI/Rest/Maintenance/SystemDiagnostic/DownloadVideo',
    captureScreenshot: '/UI/Rest/Maintenance/SystemDiagnostic/CaptureScreenshot',
    deleteScreenshot: '/UI/Rest/Maintenance/SystemDiagnostic/DeleteScreenshot',
    videoPlayLogin: '/UI/Rest/Maintenance/VideoPlayLogin',
  },
  alarm: {
    alarm: '/UI/Rest/Maintenance/Alarm',
    queryEvent: '/UI/Rest/Maintenance/QueryEvent',
    querySensorEvent: '/UI/Rest/Maintenance/QuerySel',
    clearEvent: '/UI/Rest/Maintenance/ClearEvent',
    downloadEvent: '/UI/Rest/Maintenance/DownloadEvent',
    downloadSelEvent: '/UI/Rest/Maintenance/DownloadSel',
    eventObjectType: '/UI/Rest/Maintenance/EventObjectType',
    recordType: '/UI/Rest/Maintenance/SelOverWritePolicy',
    recordTypeEvent: '/UI/Rest/Maintenance/EventMode',
  },
  asset: {
    retire: '/UI/Rest/System/Lifecycle/RetireSystem',
    retireProcess: '/UI/Rest/System/Lifecycle/RetireSystem',
    getAssetChange: '/UI/Rest/Maintenance/HardwareAsset/Change',
    refreshChange: '/UI/Rest/Maintenance/HardwareAsset/Change/UpdateTrustStatus',
    inventory: '/UI/Rest/Maintenance/HardwareAsset/Inventory',
    supplyChainChange: '/UI/Rest/Maintenance/TrustedSupplyChain',
    supplyChainConfirm: '/UI/Rest/Maintenance/TrustedSupplyChain/Confirm',
  },
};

const language = {
  getLanguageUrl: '/UI/Rest/BMCSettings/Language',
  setLanguageUrl: '/UI/Rest/BMCSettings/Language/CloseLanguage',
};

const configUpdate = {
  import: '/UI/Rest/BMCSettings/Configuration/ImportConfig',
  export: '/UI/Rest/BMCSettings/Configuration/ExportConfig',
  progress: '/UI/Rest/BMCSettings/Configuration/ImportExportProgress',
};

const manager = {
  ibma,
  networkSettings: '/UI/Rest/BMCSettings/NetworkSettings',
  exportConfig,
  language,
  configUpdate,
  usb: '/UI/Rest/BMCSettings/USBMgmtService',
  sp: {
    SPData: '/UI/Rest/BMCSettings/SP',
    SPRestore: '/UI/Rest/BMCSettings/SPService/SystemErase',
    result: '/UI/Rest/BMCSettings/SPService/Result',
  },
};

const net = {
  getNetData: '/UI/Rest/System/NetworkAdapter',
  getBridgeData: '/UI/Rest/System/Bridge',
  getTeamData: '/UI/Rest/System/Team',
  networkAdapter: '/UI/Rest/System/NetworkAdapter',
};

const onlineUser = {
  sessions: '/UI/Rest/Sessions',
};

const vnc = {
  getVncData: '/UI/Rest/Services/VNC',
  password: '/UI/Rest/Services/VNC/Password',
};

export const reqPath = {
  user: '/UI/Rest/user',
  net: net,
  sensor: '/UI/Rest/System/ThresholdSensor',
  monitor: monitor,
  vnc: vnc,
  onlineUser: onlineUser,
  userAndSecurity: userAndSecurity,
  maintance,
  manager,
  ibmc,
  snmp: '/UI/Rest/Services/SNMP',
  system,
  discreteSensor: '/UI/Rest/System/DiscreteSensor',
};
