//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MockMethod } from 'vite-plugin-mock';
import {
  permissionManagementData,
  securityBulletinData,
  loginRulesData,
  securityEnhanceData,
  patchSecurityEnhanceData
} from './data/index';
import { reqPath } from '@/api/reqPath';
import { UI_REST_ACCESSMGNT_ADVANCEDSECURITY } from '@/api/api';

export default [
  {
    url: reqPath.userAndSecurity.permissionManagement,
    method: 'get',
    timeout: 500,
    response: permissionManagementData
  },
  {
    url: reqPath.userAndSecurity.securityBulletin,
    method: 'get',
    timeout: 500,
    response: securityBulletinData
  },
  {
    url: reqPath.userAndSecurity.loginRules,
    method: 'get',
    timeout: 500,
    response: loginRulesData
  },
  {
    url: UI_REST_ACCESSMGNT_ADVANCEDSECURITY,
    method: 'get',
    timeout: 500,
    response: securityEnhanceData
  },
  {
    url: UI_REST_ACCESSMGNT_ADVANCEDSECURITY,
    method: 'patch',
    timeout: 500,
    response: patchSecurityEnhanceData
  }
] as MockMethod[];
