//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export const netWorkData = {
  NetworkProtocols: {
    IPv4Config: {
      SubnetMask: '255.255.255.255',
      IPAddress: '255.255.255.255',
      Gateway: '255.255.255.255',
      PermanentMACAddress: '20:20:05:13:08:42',
      IPAddressMode: 'Static'
    },
    IPv6Config: {
      IPv6Addresses: [
        {
          PrefixLength: 64,
          IPAddress: 'fec0:70:4000::48:f3:cede',
          IPAddressMode: 'DHCPv6'
        },
        {
          PrefixLength: 64,
          IPAddress: 'fe80::2220:5ff:fe13:842',
          IPAddressMode: 'LinkLocal'
        }
      ],
      Gateway: 'fe80::5613:10ff:fea2:1eb3'
    },
    ProtocolMode: 'IPv4AndIPv6'
  },
  LLDP: {
    WorkMode: 'Tx',
    TxDelaySeconds: 2,
    Enabled: false,
    TxHold: 4,
    TxIntervalSeconds: 30
  },
  VLAN: {
    Enabled: false,
    ID: 0
  },
  HostName: 'iBMC',
  DNS: {
    TertiaryServer: '',
    PrimaryServer: '',
    Domain: 'zys.com',
    BackupServer: '',
    AddressMode: 'Static'
  },
  NetworkPort: {
    Mode: 'Automatic',
    Members: {
      Aggregation: [],
      OCP2: [],
      FlexIO: [],
      LOM: [
        {
          PortNumber: 1,
          LinkStatus: 'Connected',
          AdaptiveFlag: true
        },
        {
          PortNumber: 2,
          LinkStatus: 'Disabled',
          AdaptiveFlag: true
        },
        {
          PortNumber: 3,
          LinkStatus: 'Disconnected',
          AdaptiveFlag: true
        },
        {
          PortNumber: 4,
          LinkStatus: 'Connected',
          AdaptiveFlag: true
        }
      ],
      Dedicated: {
        PortNumber: 1,
        LinkStatus: 'Connected',
        AdaptiveFlag: true
      },
      OCP: [],
      ExternalPCIe: []
    },
    ManagementNetworkPort: {
      PortNumber: 1,
      Type: 'Dedicated'
    }
  }
};

export const netWorkData2 = {
  NetworkProtocols: {
    IPv4Config: {
      SubnetMask: '255.255.255.255',
      IPAddress: '255.255.255.255',
      Gateway: '255.255.255.255',
      PermanentMACAddress: '20:20:05:13:08:42',
      IPAddressMode: 'Static'
    },
    IPv6Config: {
      IPv6Addresses: [
        {
          PrefixLength: 64,
          IPAddress: 'fec0:70:4000::48:f3:cede',
          IPAddressMode: 'DHCPv6'
        },
        {
          PrefixLength: 64,
          IPAddress: 'fe80::2220:5ff:fe13:842',
          IPAddressMode: 'LinkLocal'
        }
      ],
      Gateway: 'fe80::5613:10ff:fea2:1eb3'
    },
    ProtocolMode: 'IPv4AndIPv6'
  },
  LLDP: {
    WorkMode: 'Tx',
    TxDelaySeconds: 2,
    Enabled: false,
    TxHold: 4,
    TxIntervalSeconds: 30
  },
  VLAN: {
    Enabled: false,
    ID: 0
  },
  HostName: 'iBMC',
  DNS: {
    TertiaryServer: '',
    PrimaryServer: '',
    Domain: 'zys.com',
    BackupServer: '',
    AddressMode: 'Static'
  },
  NetworkPort: {
    Mode: 'Fixed',
    Members: {
      Aggregation: [],
      OCP2: [],
      FlexIO: [],
      LOM: [
        {
          PortNumber: 1,
          LinkStatus: 'Connected',
          AdaptiveFlag: true
        },
        {
          PortNumber: 2,
          LinkStatus: 'Disabled',
          AdaptiveFlag: true
        },
        {
          PortNumber: 3,
          LinkStatus: 'Disconnected',
          AdaptiveFlag: true
        },
        {
          PortNumber: 4,
          LinkStatus: 'Connected',
          AdaptiveFlag: true
        }
      ],
      Dedicated: {
        PortNumber: 1,
        LinkStatus: 'Connected',
        AdaptiveFlag: true
      },
      OCP: [],
      ExternalPCIe: []
    },
    ManagementNetworkPort: {
      PortNumber: 1,
      Type: 'Dedicated'
    }
  }
};
