//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MockMethod } from 'vite-plugin-mock';
import {
  ibmcOpLogData,
  ibmcRunlogData,
  ibmcSecurityLogData,
  downloadOpData,
  downloadRunData,
  downloadSecurityLogData,
  downloadOp_res,
  downloadRun_res,
  downloadSer_res,
  opLogRes,
  runLogRes,
  serLogRes
} from './data/index';
import { reqPath } from '@/api/reqPath';
import { resultPageSuccess } from './_util';

export default [
  // 获取操作日志table数据地址
  {
    url: reqPath.maintance.ibmcLog.ibmcLogOperation,
    timeout: 500,
    method: 'get',
    response: ({ query }) => {
      const { Skip = 0, Top = 10 } = query;
      return resultPageSuccess(Skip, Top, ibmcOpLogData.Logs, ibmcOpLogData.TotalCount);
    }
  },
  // 获取运行日志table数据地址
  {
    url: reqPath.maintance.ibmcLog.ibmcLogRun,
    timeout: 500,
    method: 'get',
    response: ({ query }) => {
      const { Skip = 0, Top = 10 } = query;
      return resultPageSuccess(Skip, Top, ibmcRunlogData.Logs, ibmcRunlogData.TotalCount);
    }
  },
  // 获取安全日志table数据地址
  {
    url: reqPath.maintance.ibmcLog.ibmcLogSecurity,
    timeout: 500,
    method: 'get',
    response: ({ query }) => {
      const { Skip = 0, Top = 10 } = query;
      return resultPageSuccess(Skip, Top, ibmcSecurityLogData.Logs, ibmcSecurityLogData.TotalCount);
    }
  },
  // 获取操作日志下载地址
  {
    url: reqPath.maintance.ibmcLog.DownloadOperation,
    method: 'post',
    timeout: 500,
    response: downloadOpData
  },
  // 获取运行日志下载地址
  {
    url: reqPath.maintance.ibmcLog.DownloadRunLog,
    method: 'post',
    timeout: 500,
    response: downloadRunData
  },
  // 获取安全日志下载地址
  {
    url: reqPath.maintance.ibmcLog.DownloadSecurityLog,
    method: 'post',
    timeout: 500,
    response: downloadSecurityLogData
  },
  // 操作日志进度;
  {
    url: reqPath.maintance.ibmcLog.Optask,
    method: 'get',
    timeout: 500,
    response: downloadOp_res
  },
  // 运行日志进度
  {
    url: reqPath.maintance.ibmcLog.Runtask,
    method: 'get',
    timeout: 500,
    response: downloadRun_res
  },
  // 安全日志进度
  {
    url: reqPath.maintance.ibmcLog.Sertask,
    method: 'get',
    timeout: 500,
    response: downloadSer_res
  },
  // 下载操作日志
  {
    url: reqPath.maintance.ibmcLog.downloadOpUrl,
    method: 'get',
    timeout: 300,
    rawResponse: async (req, res) => {
      res.setHeader('Content-Disposition', 'attachment; filename=operate.log');
      res.end(opLogRes);
    }
  },
  //下载运行日志
  {
    url: reqPath.maintance.ibmcLog.downloadRunUrl,
    method: 'get',
    timeout: 300,
    rawResponse: async (req, res) => {
      res.setHeader('Content-Disposition', 'attachment; filename=runlog.log');
      res.end(runLogRes);
    }
  },
  //下载安全日志
  {
    url: reqPath.maintance.ibmcLog.downloadSerUrl,
    method: 'get',
    timeout: 300,
    rawResponse: async (req, res) => {
      res.setHeader('Content-Disposition', 'attachment; filename=security.log');
      res.end(serLogRes);
    }
  }
] as MockMethod[];
