# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.
from conanbase import ConanBase
import os

required_conan_version = ">=1.42.0"

class WebUIConan(ConanBase):
    name = "webui"
    license = "BSD licence"
    generators="make"
    homepage = "https://www.huawei.com/"
    description = ""
    chost = None
    settings = "os", "arch"

    def build(self):
        self.run(f"npm install")
        self.run(f"npm run build")

    def package(self):
        self.run(f"rm -rf node_modules")
        self.run(f"npm install --production")
        if os.path.isfile("public/permissions.ini"):
            self.copy("permissions.ini", src="public")
        # 切换dist为工作目录
        self.copy("*", src="dist", dst="opt/bmc/web/htdocs/")
