# iBMC_V3/interface/webui

iBMC_V3/interface/webui项目系统作为华为服务器智能管理系统iBMC的用户交互系统，提供系统访问控制、安全管理、硬件管理、资源管理、诊断监控等功能。

## 框架方案

系统采用Vue3+ElementPlus+OpenDesignV2作为前端组件框架，遵循体验部设计规范进行交互界面设计。iBMC V3 WebUI使用vue框架，和基于vue3的opendesign组件库；
交互上继承了V2 angular+tinyui的框架交互，基本交互保持不变；业务功能包含：登录系统、首页查询、系统管理查询设置、系统的维护诊断、用户与安全的查询和配置、服务的查询配置、iBMC配置信息管理等功能。前端业务相较于V2功能不做更改，详细交互遵循《iBMC Web界面规格说明书》。

## 开发指导
Node配置请参考最新华为中心仓地址进行配置；

```shell
# 安装开源软件依赖
npm ci

# 本地调试启动，需要在vite.config.ts中配置转发地址
# .env.development调整启动配置项，例如：Mock默认开启
npm run dev

# 构建前端目标代码
# npm run build:custom 生成定制工具目标代码
npm run build
```

目标代码会生成到 `dist` 目录下。

## 目录结构
+ mock:存放前端模拟服务和模拟数据。
+ node_modules:存放前端项目依赖包，如：element-plus组件库。
+ public:存放公共资源。
+ src: 存放所有的业务模块功能。
+ types:存放项目配置文件。
+ .env.development:开发中的公共配置。
+ .env.production:生产环境中的公共配置。
+ .eslintignore:不进行eslint代码检查配置。
+ .eslintrc.js:eslint代码格式检查的配置。
+ .prettierrc.js:代码格式基本配置。
+ index.html：前端单页应用程序容器。
+ package-lock.json:项目依赖包的版本锁定配置。
+ package.json:项目运行和打包以及依赖包版本的配置。
+ postcss.config.js:处理移动端适配的配置文件。
+ README.md:项目描述文件。
+ tsconfig.json:tslint代码检查配置。
+ vite.config.ts:项目基本配置，包括打包、mock、代理等。

### src目录功能
+ api:存放项目中涉及的请求地址。
+ apps:存放项目的app。
+ assets:存放项目资源，如样式资源、图片资源。
+ components:存放项目公共组件。
+ data:存放公共数据。
+ directive:存放自定义指令。
+ hooks:存放组件的通用方法。
+ model:存放接口和枚举数据。
+ pages:存放各个页面的相关目录和相关文件。
+ plugins:存放插件，如open-design。
+ services:存放服务资源。
+ static:存放静态资源，如样式或者图片资源。
+ stores:pinia的相关配置。
+ utils:存放公共方法。
+ validators:存放公共校验规则。
+ App.vue:项目的主组件。
+ env.d.ts:做全局数据声明。
+ main.ts:应用程序入口文件。

## 兼容性标准
浏览器最大版本只列出截止资料刷新时浏览器最新版本，不代表不支持最新版本；可能存在误差，具体请以联机帮助和SEG最新结论为准；

|  浏览器   | 版本  |
|  ----  | ----  |
| Edge  | 79 - 97 |
| Firefox  | 78 - 96 |
| Chrome  | 64 - 97 |
| Safari  | 12 -15.2 |

## 分辨率标准
V3支持的分辨率标准继承自V2的浏览器标准，建议使用以下屏幕分辨率：

•	1280 × 800

•	1366 × 768

•	1440 × 900

•	1600 × 900

•	1600 × 1200

•	1680 × 1050

•	1920 × 1080

•	1920 × 1200

