-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_valve = require 'valve_object'
local c_object_manage = require 'mc.orm.object_manage'
local c_tasks = require 'mc.orm.tasks'
local thermal_db = require 'thermal_mgmt.db'
local hook_tasks = require 'test_common.hook_tasks'
local test_utils = require 'test_utils'

TestValve = {}

function TestValve:flush()
    c_tasks.get_instance():run_all_task()
    self.database.db:flush()
end

function TestValve:setUp()
    self.database = thermal_db(':memory:')

    hook_tasks.hook()
    self.object_manage = c_object_manage.new(self.database)
    self.object_manage.app = self

    local valve  = {
        Id = 0,
        LastPatrolTimestamp = 9999,
        PatrolState = "Idle",
        PatrolType = 0,
        InvalidLocationId = 1,
        StartPatrol = function ()
            return 1
        end
    }

    local valve_obj = test_utils.add_valve_obj(self.object_manage, 'Valve_1', valve)
    self.object_manage.mc:before_add_object(c_valve.__class_name, valve_obj)
    self.object_manage.mc:add_object(c_valve.__class_name, valve_obj, '010107')
    self.object_manage.mc:prepare_ok()
    self:flush()
end

function TestValve:tearDown()
    c_object_manage.destroy()
    self.database.db:close()
    hook_tasks.unhook()
end

function TestValve:test_fan_group_ctor_init()
    local obj = c_valve.collection:find({
        Id = 0
    })
    lu.assertEquals(obj.PatrolState,  "Idle")
    lu.assertIsFunction(obj.StartPatrol)
end
