-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_fan_object = require 'fan_object'
local c_fan_type_object = require 'fan_type_object'
local c_object_manage = require 'mc.orm.object_manage'
local c_tasks = require 'mc.orm.tasks'
local thermal_db = require 'thermal_mgmt.db'
local hook_tasks = require 'test_common.hook_tasks'
local test_utils = require 'test_utils'

TestFanType = {}

function TestFanType:flush()
    c_tasks.get_instance():run_all_task()
    self.database.db:flush()
end

function TestFanType:setUp()
    self.database = thermal_db(':memory:')

    hook_tasks.hook()
    self.object_manage = c_object_manage.new(self.database)
    self.object_manage.app = self

    local fan_type  = {
        Name = "02314QEB 4056+",
        FanTypeObjectName = "FanType_4056P_010107",
        Index = 1,
        IsDefaultType = true,
        IsTwins = true,
        FrontMaxSpeed = 16500,
        RearMaxSpeed = 16500,
        PartNumber = "32030389-004",
        BOM = "BOM 32030389-004",
        SystemId = 1,
        IdentifyRangeLow = 4207,
        IdentifyRangeHigh = 5692,
        __position = "010107"
    }

    local fan_type_obj = test_utils.add_fan_type_obj(self.object_manage, 'FanType_1', fan_type)
    self.object_manage.mc:before_add_object(c_fan_type_object.__class_name, fan_type_obj)
    self.object_manage.mc:add_object(c_fan_type_object.__class_name, fan_type_obj, '010107')
    self.object_manage.mc:prepare_ok()
    self:flush()
end

function TestFanType:tearDown()
    c_object_manage.destroy()
    self.database.db:close()
    hook_tasks.unhook()
end

function TestFanType:test_fan_type_ctor_init()
    local obj = c_fan_type_object.collection:find({
        Index = 1
    })
    lu.assertEquals(obj.fan_num, 0)
end

function TestFanType:test_get_fan_type_name()
    local obj = c_fan_type_object.collection:find({
        Index = 1
    })
    local res = obj:get_fan_type_name()
    lu.assertEquals(res, "02314QEB 4056+")
end

function TestFanType:test_get_identify_low_speed()
    local obj = c_fan_type_object.collection:find({
        Index = 1
    })
    local res = obj:get_identify_low_speed()
    lu.assertEquals(res, 4207)
end

function TestFanType:test_get_identify_high_speed()
    local obj = c_fan_type_object.collection:find({
        Index = 1
    })
    local res = obj:get_identify_high_speed()
    lu.assertEquals(res, 5692)
end

function TestFanType:test_get_is_twins()
    local obj = c_fan_type_object.collection:find({
        Index = 1
    })
    local res = obj:get_is_twins()
    lu.assertEquals(res, true)
end

function TestFanType:test_get_type_part_num()
    local obj = c_fan_type_object.collection:find({
        Index = 1
    })
    local res = obj:get_type_part_num()
    lu.assertEquals(res, "32030389-004")
end
function TestFanType:test_get_type_bom_id()
    local obj = c_fan_type_object.collection:find({
        Index = 1
    })
    local res = obj:get_type_bom_id()
    lu.assertEquals(res, "BOM 32030389-004")
end

function TestFanType:test_get_front_max_speed()
    local obj = c_fan_type_object.collection:find({
        Index = 1
    })
    local res = obj:get_front_max_speed()
    lu.assertEquals(res, 16500)
end

function TestFanType:test_get_rear_max_speed()
    local obj = c_fan_type_object.collection:find({
        Index = 1
    })
    local res = obj:get_rear_max_speed()
    lu.assertEquals(res, 16500)
end