-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local valve_enums = {}

valve_enums.Patrol_State =
{
    Patrol_State_Idle = 'Idle',   -- 未开始（也包括刚刚完成）
    Patrol_State_Ready = 'Ready',     -- 准备开始但尚未开始，即到达巡检时间（每月1日，偏移[slotid]小时）,巡检线程已启动，但尚未开始（存在随机事件间隔）
    Patrol_State_Running = 'Running'    -- 巡检进行中
}

valve_enums.Opening_Degree_State =
{
    Normal = 0,         -- 正常
    Abnormal = 1        -- 异常
}

valve_enums.Patrol_Result =
{
    Success = 0,        -- 成功
    Failed = 1          -- 失败
}

valve_enums.OPENING_DEGREE_MAX = 1000   -- 开度最大值

return valve_enums