-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_object = require 'mc.orm.object'
local log = require 'mc.logging'

local fan_type_obj_manager = c_object('FanType')

function fan_type_obj_manager:ctor()
    self.fan_num = 0
end

function fan_type_obj_manager:get_fan_type_name()
    return self.Name
end

function fan_type_obj_manager:get_identify_low_speed()
    return self.IdentifyRangeLow
end

function fan_type_obj_manager:get_identify_high_speed()
    return self.IdentifyRangeHigh
end

function fan_type_obj_manager:get_is_twins()
    return self.IsTwins
end

function fan_type_obj_manager:get_type_part_num()
    return self.PartNumber
end

function fan_type_obj_manager:get_type_bom_id()
    return self.BOM
end

function fan_type_obj_manager:get_front_max_speed()
    return self.FrontMaxSpeed
end

function fan_type_obj_manager:get_rear_max_speed()
    return self.RearMaxSpeed
end

function fan_type_obj_manager:get_speed_range()
    return self.SpeedRange
end

function fan_type_obj_manager:get_power_range()
    return self.PowerRange
end

function fan_type_obj_manager:init()
    self:connect_signal(self.on_add_object, function()
    end)
    self:connect_signal(self.on_add_object_complete, function()
        log:notice('on_add_object_complete fan_type: %d, model: %s, identify interval: %d : %d',
            self.Index, self.Name, self.IdentifyRangeLow, self.IdentifyRangeHigh)
    end)
    fan_type_obj_manager.super.init(self)
end

return fan_type_obj_manager
