-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local cooling_ipmi_service = require 'thermal_mgmt.ipmi.ipmi'
local cooling_ipmi_init = {}

-- 注册风扇ipmi接口
local function register_fan_ipmi(cooling_ipmi, register_ipmi_func)
    register_ipmi_func(cooling_ipmi_service.SetFanCtlMode, function(...)
        return cooling_ipmi:SetFanCtlMode(...)
    end)
    register_ipmi_func(cooling_ipmi_service.GetFanCtlMode, function(...)
        return cooling_ipmi:GetFanCtlMode(...)
    end)
    register_ipmi_func(cooling_ipmi_service.SetFanLevel, function(...)
        return cooling_ipmi:SetFanLevel(...)
    end)
    register_ipmi_func(cooling_ipmi_service.GetFanLevel, function(...)
        return cooling_ipmi:GetFanLevel(...)
    end)
    register_ipmi_func(cooling_ipmi_service.SetCoolingMode, function(...)
        return cooling_ipmi:SetCoolingMode(...)
    end)
    register_ipmi_func(cooling_ipmi_service.GetCoolingMode, function(...)
        return cooling_ipmi:GetCoolingMode(...)
    end)
    register_ipmi_func(cooling_ipmi_service.GetFanSpdProps, function(...)
        return cooling_ipmi:GetFanSpdProps(...)
    end)
    register_ipmi_func(cooling_ipmi_service.GetInletPolicy, function(...)
        return cooling_ipmi:GetInletPolicy(...)
    end)
    register_ipmi_func(cooling_ipmi_service.SetInletPolicy, function(...)
        return cooling_ipmi:SetInletPolicy(...)
    end)
    register_ipmi_func(cooling_ipmi_service.GetInitCoolingUnitLevel, function(...)
        return cooling_ipmi:GetInitCoolingUnitLevel(...)
    end)
    register_ipmi_func(cooling_ipmi_service.SetInitCoolingUnitLevel, function(...)
        return cooling_ipmi:SetInitCoolingUnitLevel(...)
    end)
end

-- 注册液冷调速ipmi接口
local function register_liquid_ipmi(cooling_ipmi, register_ipmi_func)
    register_ipmi_func(cooling_ipmi_service.GetCoolingDeviceMode, function(...)
        return cooling_ipmi:GetCoolingDeviceMode(...)
    end)
    register_ipmi_func(cooling_ipmi_service.GetCoolingDeviceLevel, function(...)
        return cooling_ipmi:GetCoolingDeviceLevel(...)
    end)
    register_ipmi_func(cooling_ipmi_service.SetCoolingDeviceMode, function(...)
        return cooling_ipmi:SetCoolingDeviceMode(...)
    end)
    register_ipmi_func(cooling_ipmi_service.SetCoolingDeviceLevel, function(...)
        return cooling_ipmi:SetCoolingDeviceLevel(...)
    end)
end

function cooling_ipmi_init.register_ipmi(cooling_ipmi, register_ipmi_func)
    register_fan_ipmi(cooling_ipmi, register_ipmi_func)
    register_liquid_ipmi(cooling_ipmi, register_ipmi_func)
end

return cooling_ipmi_init