-- Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local props = require 'basic_cooling.define.cooling_properties'

local config_base = class()

function config_base:get_obj()
    return self.obj
end

-- 获取手动转速
function config_base:get_manual_level()
    if not self.obj then
        return nil
    end
    return self.obj[props.CONF_MANUAL_LEVEL]
end

-- 获取控制模式
function config_base:get_ctrl_mode()
    if not self.obj then
        return nil
    end
    return self.obj[props.CTL_MODE]
end

-- 获取超时时间
function config_base:get_manual_timeout()
    if not self.obj then
        return nil
    end
    return self.obj[props.TIME_OUT]
end
-- 获取转速区间
function config_base:get_level_range()
    if not self.obj then
        return nil
    end
    return self.obj[props.LEVEL_RANGE]
end

-- 设置控制模式(手动/自动)
function config_base:set_ctrl_mode(value)
    if not self.obj then
        return false
    end
    self.obj[props.CTL_MODE] = value
    return true
end

-- 设置超时时间
function config_base:set_manual_timeout(value)
    if not self.obj then
        return false
    end
    self.obj[props.TIME_OUT] = value
    return true
end

return config_base