-- Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local log = require 'mc.logging'
local cooling_enums = require 'basic_cooling.define.cooling_enums'
local utils = require 'basic_cooling.cooling_utils'
local props = require 'basic_cooling.define.cooling_properties'
local custom_msg = require 'messages.custom'
local privilege = require 'mc.privilege'
local Singleton = require 'mc.singleton'
local cooling_config_base = require 'basic_cooling.cooling_config.base'

local air_config = class(cooling_config_base)

function air_config:ctor()
    self.obj = nil
    self.cooling_config_obj = nil
    self.manual_mode_status_table = {
        last_timeout = nil, -- 上次更新的timeout
        expir_time = nil,   -- timeout结束的时间
        pre_manual_level_tab = nil
    }
end

function air_config:set_cooling_config_obj(object)
    self.cooling_config_obj = object
end

function air_config:set_obj(object)
    self.obj = object
    object:get_mdb_object('bmc.kepler.Systems.AirCoolingConfig').property_changed:on(function(name, value, sender)
        self:props_changed_callback(object, name, value, sender)
    end)
end

function air_config:props_changed_callback(object, name, value, sender)
    if name == props.INITIAL_SPEED_PERCENT then
        if self.cooling_config_obj then
            self.cooling_config_obj[props.INIT_LEVEL_IN_STARTUP] = value
        end
    elseif name == "MinAllowedSpeedPercent" then
        if self.cooling_config_obj then
            self.cooling_config_obj.MinAllowedFanSpeedPercent = value
        end
    end
end

function air_config:is_obj_added()
    if self.obj then
        return true
    end
    return false
end

function air_config:set_min_allowed_speed_percent(value)
    if not self.obj then
        return
    end
    self.obj.MinAllowedSpeedPercent = value
end

function air_config:set_init_level_in_startup(value)
    if not self.obj then
        return
    end
    self.obj[props.INITIAL_SPEED_PERCENT] = value
end

function air_config:get_init_level_in_startup()
    if not self.obj then
        return nil
    end
    return self.obj[props.INITIAL_SPEED_PERCENT]
end

-- 获取手动转速
function air_config:set_manual_level(value)
    if not self.obj then
        return
    end
    self.obj[props.MANUAL_SPEED_PERCENT] = value
end

-- 获取手动转速
function air_config:get_manual_level()
    if not self.obj then
        return nil
    end
    return self.obj[props.MANUAL_SPEED_PERCENT]
end

-- 获取转速区间
function air_config:get_level_range()
    if not self.obj then
        return nil
    end
    return self.obj[props.SPEED_PERCENT_RANGE]
end

return Singleton(air_config)