-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Valves = {}

---@class Valves.PatrolState
---@field PatrolState string
local TPatrolState = {}
TPatrolState.__index = TPatrolState
TPatrolState.group = {}

local function TPatrolState_from_obj(obj) return setmetatable(obj, TPatrolState) end

function TPatrolState.new(PatrolState)
    return TPatrolState_from_obj({PatrolState = PatrolState})
end
---@param obj Valves.PatrolState
function TPatrolState:init_from_obj(obj) self.PatrolState = obj.PatrolState end

function TPatrolState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPatrolState.group)
end

TPatrolState.from_obj = TPatrolState_from_obj

TPatrolState.proto_property = {'PatrolState'}

TPatrolState.default = {''}

TPatrolState.struct = {{name = 'PatrolState', is_array = false, struct = nil}}

function TPatrolState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PatrolState', self.PatrolState, "string", true,
                      errs, need_convert)

    if self.PatrolState ~= nil then
        validate.Enum(prefix .. 'PatrolState', self.PatrolState, '',
                      {"Idle", "Ready", "Running"}, errs, need_convert)
    end

    TPatrolState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPatrolState.proto_property, errs,
                                 need_convert)
    return self
end

function TPatrolState:unpack(_) return self.PatrolState end

Valves.PatrolState = TPatrolState

---@class Valves.LastPatrolTimestamp
---@field LastPatrolTimestamp integer
local TLastPatrolTimestamp = {}
TLastPatrolTimestamp.__index = TLastPatrolTimestamp
TLastPatrolTimestamp.group = {}

local function TLastPatrolTimestamp_from_obj(obj)
    return setmetatable(obj, TLastPatrolTimestamp)
end

function TLastPatrolTimestamp.new(LastPatrolTimestamp)
    return TLastPatrolTimestamp_from_obj({
        LastPatrolTimestamp = LastPatrolTimestamp
    })
end
---@param obj Valves.LastPatrolTimestamp
function TLastPatrolTimestamp:init_from_obj(obj)
    self.LastPatrolTimestamp = obj.LastPatrolTimestamp
end

function TLastPatrolTimestamp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLastPatrolTimestamp.group)
end

TLastPatrolTimestamp.from_obj = TLastPatrolTimestamp_from_obj

TLastPatrolTimestamp.proto_property = {'LastPatrolTimestamp'}

TLastPatrolTimestamp.default = {0}

TLastPatrolTimestamp.struct = {
    {name = 'LastPatrolTimestamp', is_array = false, struct = nil}
}

function TLastPatrolTimestamp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LastPatrolTimestamp', self.LastPatrolTimestamp,
                      "uint32", true, errs, need_convert)

    TLastPatrolTimestamp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLastPatrolTimestamp.proto_property,
                                 errs, need_convert)
    return self
end

function TLastPatrolTimestamp:unpack(_) return self.LastPatrolTimestamp end

Valves.LastPatrolTimestamp = TLastPatrolTimestamp

---@class Valves.StartPatrolRsp
local TStartPatrolRsp = {}
TStartPatrolRsp.__index = TStartPatrolRsp
TStartPatrolRsp.group = {}

local function TStartPatrolRsp_from_obj(obj)
    return setmetatable(obj, TStartPatrolRsp)
end

function TStartPatrolRsp.new() return TStartPatrolRsp_from_obj({}) end
---@param obj Valves.StartPatrolRsp
function TStartPatrolRsp:init_from_obj(obj) end

function TStartPatrolRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartPatrolRsp.group)
end

TStartPatrolRsp.from_obj = TStartPatrolRsp_from_obj

TStartPatrolRsp.proto_property = {}

TStartPatrolRsp.default = {}

TStartPatrolRsp.struct = {}

function TStartPatrolRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStartPatrolRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartPatrolRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TStartPatrolRsp:unpack(_) end

Valves.StartPatrolRsp = TStartPatrolRsp

---@class Valves.StartPatrolReq
---@field DelaySeconds integer
local TStartPatrolReq = {}
TStartPatrolReq.__index = TStartPatrolReq
TStartPatrolReq.group = {}

local function TStartPatrolReq_from_obj(obj)
    return setmetatable(obj, TStartPatrolReq)
end

function TStartPatrolReq.new(DelaySeconds)
    return TStartPatrolReq_from_obj({DelaySeconds = DelaySeconds})
end
---@param obj Valves.StartPatrolReq
function TStartPatrolReq:init_from_obj(obj) self.DelaySeconds = obj.DelaySeconds end

function TStartPatrolReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartPatrolReq.group)
end

TStartPatrolReq.from_obj = TStartPatrolReq_from_obj

TStartPatrolReq.proto_property = {'DelaySeconds'}

TStartPatrolReq.default = {0}

TStartPatrolReq.struct = {
    {name = 'DelaySeconds', is_array = false, struct = nil}
}

function TStartPatrolReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DelaySeconds', self.DelaySeconds, "uint32",
                      false, errs, need_convert)

    TStartPatrolReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartPatrolReq.proto_property, errs,
                                 need_convert)
    return self
end

function TStartPatrolReq:unpack(_) return self.DelaySeconds end

Valves.StartPatrolReq = TStartPatrolReq

Valves.interface = mdb.register_interface('bmc.kepler.Chassis.Valves', {
    LastPatrolTimestamp = {'u', {}, true, nil, false},
    PatrolState = {'s', {}, true, nil, false}
}, {StartPatrol = {'a{ss}u', '', TStartPatrolReq, TStartPatrolRsp}}, {})

return Valves
