-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Valve = {}

---@class Valve.PatrolResult
---@field PatrolResult integer
local TPatrolResult = {}
TPatrolResult.__index = TPatrolResult
TPatrolResult.group = {}

local function TPatrolResult_from_obj(obj)
    return setmetatable(obj, TPatrolResult)
end

function TPatrolResult.new(PatrolResult)
    return TPatrolResult_from_obj({PatrolResult = PatrolResult})
end
---@param obj Valve.PatrolResult
function TPatrolResult:init_from_obj(obj) self.PatrolResult = obj.PatrolResult end

function TPatrolResult:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPatrolResult.group)
end

TPatrolResult.from_obj = TPatrolResult_from_obj

TPatrolResult.proto_property = {'PatrolResult'}

TPatrolResult.default = {0}

TPatrolResult.struct = {{name = 'PatrolResult', is_array = false, struct = nil}}

function TPatrolResult:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PatrolResult', self.PatrolResult, "uint8",
                      true, errs, need_convert)

    TPatrolResult:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPatrolResult.proto_property, errs,
                                 need_convert)
    return self
end

function TPatrolResult:unpack(_) return self.PatrolResult end

Valve.PatrolResult = TPatrolResult

---@class Valve.OpeningDegreeState
---@field OpeningDegreeState integer
local TOpeningDegreeState = {}
TOpeningDegreeState.__index = TOpeningDegreeState
TOpeningDegreeState.group = {}

local function TOpeningDegreeState_from_obj(obj)
    return setmetatable(obj, TOpeningDegreeState)
end

function TOpeningDegreeState.new(OpeningDegreeState)
    return TOpeningDegreeState_from_obj({
        OpeningDegreeState = OpeningDegreeState
    })
end
---@param obj Valve.OpeningDegreeState
function TOpeningDegreeState:init_from_obj(obj)
    self.OpeningDegreeState = obj.OpeningDegreeState
end

function TOpeningDegreeState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOpeningDegreeState.group)
end

TOpeningDegreeState.from_obj = TOpeningDegreeState_from_obj

TOpeningDegreeState.proto_property = {'OpeningDegreeState'}

TOpeningDegreeState.default = {0}

TOpeningDegreeState.struct = {
    {name = 'OpeningDegreeState', is_array = false, struct = nil}
}

function TOpeningDegreeState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OpeningDegreeState', self.OpeningDegreeState,
                      "uint8", true, errs, need_convert)

    TOpeningDegreeState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOpeningDegreeState.proto_property, errs,
                                 need_convert)
    return self
end

function TOpeningDegreeState:unpack(_) return self.OpeningDegreeState end

Valve.OpeningDegreeState = TOpeningDegreeState

---@class Valve.Status
---@field Status integer
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj) return setmetatable(obj, TStatus) end

function TStatus.new(Status) return TStatus_from_obj({Status = Status}) end
---@param obj Valve.Status
function TStatus:init_from_obj(obj) self.Status = obj.Status end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {0}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, "uint16", true, errs,
                      need_convert)

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs,
                                 need_convert)
    return self
end

function TStatus:unpack(_) return self.Status end

Valve.Status = TStatus

---@class Valve.StandardOpeningDegree
---@field StandardOpeningDegree integer
local TStandardOpeningDegree = {}
TStandardOpeningDegree.__index = TStandardOpeningDegree
TStandardOpeningDegree.group = {}

local function TStandardOpeningDegree_from_obj(obj)
    return setmetatable(obj, TStandardOpeningDegree)
end

function TStandardOpeningDegree.new(StandardOpeningDegree)
    return TStandardOpeningDegree_from_obj({
        StandardOpeningDegree = StandardOpeningDegree
    })
end
---@param obj Valve.StandardOpeningDegree
function TStandardOpeningDegree:init_from_obj(obj)
    self.StandardOpeningDegree = obj.StandardOpeningDegree
end

function TStandardOpeningDegree:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStandardOpeningDegree.group)
end

TStandardOpeningDegree.from_obj = TStandardOpeningDegree_from_obj

TStandardOpeningDegree.proto_property = {'StandardOpeningDegree'}

TStandardOpeningDegree.default = {0}

TStandardOpeningDegree.struct = {
    {name = 'StandardOpeningDegree', is_array = false, struct = nil}
}

function TStandardOpeningDegree:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StandardOpeningDegree',
                      self.StandardOpeningDegree, "uint32", true, errs,
                      need_convert)

    TStandardOpeningDegree:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStandardOpeningDegree.proto_property,
                                 errs, need_convert)
    return self
end

function TStandardOpeningDegree:unpack(_) return self.StandardOpeningDegree end

Valve.StandardOpeningDegree = TStandardOpeningDegree

---@class Valve.OpeningDegree
---@field OpeningDegree integer
local TOpeningDegree = {}
TOpeningDegree.__index = TOpeningDegree
TOpeningDegree.group = {}

local function TOpeningDegree_from_obj(obj)
    return setmetatable(obj, TOpeningDegree)
end

function TOpeningDegree.new(OpeningDegree)
    return TOpeningDegree_from_obj({OpeningDegree = OpeningDegree})
end
---@param obj Valve.OpeningDegree
function TOpeningDegree:init_from_obj(obj) self.OpeningDegree =
    obj.OpeningDegree end

function TOpeningDegree:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOpeningDegree.group)
end

TOpeningDegree.from_obj = TOpeningDegree_from_obj

TOpeningDegree.proto_property = {'OpeningDegree'}

TOpeningDegree.default = {0}

TOpeningDegree.struct = {
    {name = 'OpeningDegree', is_array = false, struct = nil}
}

function TOpeningDegree:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OpeningDegree', self.OpeningDegree, "uint32",
                      false, errs, need_convert)

    TOpeningDegree:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOpeningDegree.proto_property, errs,
                                 need_convert)
    return self
end

function TOpeningDegree:unpack(_) return self.OpeningDegree end

Valve.OpeningDegree = TOpeningDegree

---@class Valve.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj) return setmetatable(obj, TPresence) end

function TPresence.new(Presence) return
    TPresence_from_obj({Presence = Presence}) end
---@param obj Valve.Presence
function TPresence:init_from_obj(obj) self.Presence = obj.Presence end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, "uint8", true, errs,
                      need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs,
                                 need_convert)
    return self
end

function TPresence:unpack(_) return self.Presence end

Valve.Presence = TPresence

---@class Valve.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj) return setmetatable(obj, TSlot) end

function TSlot.new(Slot) return TSlot_from_obj({Slot = Slot}) end
---@param obj Valve.Slot
function TSlot:init_from_obj(obj) self.Slot = obj.Slot end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, "uint8", true, errs,
                      need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_) return self.Slot end

Valve.Slot = TSlot

---@class Valve.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj) return setmetatable(obj, TId) end

function TId.new(Id) return TId_from_obj({Id = Id}) end
---@param obj Valve.Id
function TId:init_from_obj(obj) self.Id = obj.Id end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, "uint8", true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_) return self.Id end

Valve.Id = TId

Valve.interface = mdb.register_interface('bmc.kepler.Chassis.Valve', {
    Id = {'y', {'CONST'}, true, nil, false},
    Slot = {'y', {'CONST'}, true, nil, false},
    Presence = {'y', nil, true, nil, false},
    OpeningDegree = {'u', {}, false, nil, false},
    StandardOpeningDegree = {'u', {}, true, nil, false},
    Status = {'q', {'EMIT_CHANGE'}, true, nil, false},
    OpeningDegreeState = {'y', {'EMIT_CHANGE'}, true, nil, false},
    PatrolResult = {'y', {'EMIT_CHANGE'}, true, nil, false}
}, {}, {})

return Valve
