-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Status = {}

---@class Status.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj) return setmetatable(obj, TEnabled) end

function TEnabled.new(Enabled) return TEnabled_from_obj({Enabled = Enabled}) end
---@param obj Status.Enabled
function TEnabled:init_from_obj(obj) self.Enabled = obj.Enabled end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, "bool", true, errs,
                      need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs,
                                 need_convert)
    return self
end

function TEnabled:unpack(_) return self.Enabled end

Status.Enabled = TEnabled

---@class Status.Mode
---@field Mode integer
local TMode = {}
TMode.__index = TMode
TMode.group = {}

local function TMode_from_obj(obj) return setmetatable(obj, TMode) end

function TMode.new(Mode) return TMode_from_obj({Mode = Mode}) end
---@param obj Status.Mode
function TMode:init_from_obj(obj) self.Mode = obj.Mode end

function TMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMode.group)
end

TMode.from_obj = TMode_from_obj

TMode.proto_property = {'Mode'}

TMode.default = {0}

TMode.struct = {{name = 'Mode', is_array = false, struct = nil}}

function TMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, "uint8", true, errs,
                      need_convert)

    TMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMode.proto_property, errs, need_convert)
    return self
end

function TMode:unpack(_) return self.Mode end

Status.Mode = TMode

Status.interface = mdb.register_interface('bmc.kepler.Manufacture.Status', {
    Mode = {'y', nil, true, nil, false},
    Enabled = {'b', {}, true, nil, false}
}, {}, {})

return Status
