-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PCIeCard = {}

---@class PCIeCard.CardForServers
---@field CardForServers integer[]
local TCardForServers = {}
TCardForServers.__index = TCardForServers
TCardForServers.group = {}

local function TCardForServers_from_obj(obj)
    return setmetatable(obj, TCardForServers)
end

function TCardForServers.new(CardForServers)
    return TCardForServers_from_obj({CardForServers = CardForServers})
end
---@param obj PCIeCard.CardForServers
function TCardForServers:init_from_obj(obj)
    self.CardForServers = obj.CardForServers
end

function TCardForServers:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCardForServers.group)
end

TCardForServers.from_obj = TCardForServers_from_obj

TCardForServers.proto_property = {'CardForServers'}

TCardForServers.default = {{}}

TCardForServers.struct = {
    {name = 'CardForServers', is_array = true, struct = nil}
}

function TCardForServers:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'CardForServers', self.CardForServers,
                           "uint8", true, errs, need_convert)

    TCardForServers:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCardForServers.proto_property, errs,
                                 need_convert)
    return self
end

function TCardForServers:unpack(_) return self.CardForServers end

PCIeCard.CardForServers = TCardForServers

---@class PCIeCard.CardManufacturer
---@field CardManufacturer string
local TCardManufacturer = {}
TCardManufacturer.__index = TCardManufacturer
TCardManufacturer.group = {}

local function TCardManufacturer_from_obj(obj)
    return setmetatable(obj, TCardManufacturer)
end

function TCardManufacturer.new(CardManufacturer)
    return TCardManufacturer_from_obj({CardManufacturer = CardManufacturer})
end
---@param obj PCIeCard.CardManufacturer
function TCardManufacturer:init_from_obj(obj)
    self.CardManufacturer = obj.CardManufacturer
end

function TCardManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCardManufacturer.group)
end

TCardManufacturer.from_obj = TCardManufacturer_from_obj

TCardManufacturer.proto_property = {'CardManufacturer'}

TCardManufacturer.default = {''}

TCardManufacturer.struct = {
    {name = 'CardManufacturer', is_array = false, struct = nil}
}

function TCardManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CardManufacturer', self.CardManufacturer,
                      "string", true, errs, need_convert)

    TCardManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCardManufacturer.proto_property, errs,
                                 need_convert)
    return self
end

function TCardManufacturer:unpack(_) return self.CardManufacturer end

PCIeCard.CardManufacturer = TCardManufacturer

---@class PCIeCard.CardModel
---@field CardModel string
local TCardModel = {}
TCardModel.__index = TCardModel
TCardModel.group = {}

local function TCardModel_from_obj(obj) return setmetatable(obj, TCardModel) end

function TCardModel.new(CardModel)
    return TCardModel_from_obj({CardModel = CardModel})
end
---@param obj PCIeCard.CardModel
function TCardModel:init_from_obj(obj) self.CardModel = obj.CardModel end

function TCardModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCardModel.group)
end

TCardModel.from_obj = TCardModel_from_obj

TCardModel.proto_property = {'CardModel'}

TCardModel.default = {''}

TCardModel.struct = {{name = 'CardModel', is_array = false, struct = nil}}

function TCardModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CardModel', self.CardModel, "string", true,
                      errs, need_convert)

    TCardModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCardModel.proto_property, errs,
                                 need_convert)
    return self
end

function TCardModel:unpack(_) return self.CardModel end

PCIeCard.CardModel = TCardModel

---@class PCIeCard.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj) return setmetatable(obj, TPresence) end

function TPresence.new(Presence) return
    TPresence_from_obj({Presence = Presence}) end
---@param obj PCIeCard.Presence
function TPresence:init_from_obj(obj) self.Presence = obj.Presence end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, "uint8", true, errs,
                      need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs,
                                 need_convert)
    return self
end

function TPresence:unpack(_) return self.Presence end

PCIeCard.Presence = TPresence

---@class PCIeCard.NodeID
---@field NodeID string
local TNodeID = {}
TNodeID.__index = TNodeID
TNodeID.group = {}

local function TNodeID_from_obj(obj) return setmetatable(obj, TNodeID) end

function TNodeID.new(NodeID) return TNodeID_from_obj({NodeID = NodeID}) end
---@param obj PCIeCard.NodeID
function TNodeID:init_from_obj(obj) self.NodeID = obj.NodeID end

function TNodeID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNodeID.group)
end

TNodeID.from_obj = TNodeID_from_obj

TNodeID.proto_property = {'NodeID'}

TNodeID.default = {''}

TNodeID.struct = {{name = 'NodeID', is_array = false, struct = nil}}

function TNodeID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NodeID', self.NodeID, "string", true, errs,
                      need_convert)

    TNodeID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNodeID.proto_property, errs,
                                 need_convert)
    return self
end

function TNodeID:unpack(_) return self.NodeID end

PCIeCard.NodeID = TNodeID

---@class PCIeCard.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj) return setmetatable(obj, TModel) end

function TModel.new(Model) return TModel_from_obj({Model = Model}) end
---@param obj PCIeCard.Model
function TModel:init_from_obj(obj) self.Model = obj.Model end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, "string", true, errs,
                      need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_) return self.Model end

PCIeCard.Model = TModel

---@class PCIeCard.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj) return setmetatable(obj, THealth) end

function THealth.new(Health) return THealth_from_obj({Health = Health}) end
---@param obj PCIeCard.Health
function THealth:init_from_obj(obj) self.Health = obj.Health end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, "uint8", true, errs,
                      need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs,
                                 need_convert)
    return self
end

function THealth:unpack(_) return self.Health end

PCIeCard.Health = THealth

---@class PCIeCard.RefComponent
---@field RefComponent string
local TRefComponent = {}
TRefComponent.__index = TRefComponent
TRefComponent.group = {}

local function TRefComponent_from_obj(obj)
    return setmetatable(obj, TRefComponent)
end

function TRefComponent.new(RefComponent)
    return TRefComponent_from_obj({RefComponent = RefComponent})
end
---@param obj PCIeCard.RefComponent
function TRefComponent:init_from_obj(obj) self.RefComponent = obj.RefComponent end

function TRefComponent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefComponent.group)
end

TRefComponent.from_obj = TRefComponent_from_obj

TRefComponent.proto_property = {'RefComponent'}

TRefComponent.default = {''}

TRefComponent.struct = {{name = 'RefComponent', is_array = false, struct = nil}}

function TRefComponent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefComponent', self.RefComponent, "string",
                      true, errs, need_convert)

    TRefComponent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefComponent.proto_property, errs,
                                 need_convert)
    return self
end

function TRefComponent:unpack(_) return self.RefComponent end

PCIeCard.RefComponent = TRefComponent

---@class PCIeCard.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj PCIeCard.SerialNumber
function TSerialNumber:init_from_obj(obj) self.SerialNumber = obj.SerialNumber end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, "string",
                      true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs,
                                 need_convert)
    return self
end

function TSerialNumber:unpack(_) return self.SerialNumber end

PCIeCard.SerialNumber = TSerialNumber

---@class PCIeCard.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj) return setmetatable(obj, TPartNumber) end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj PCIeCard.PartNumber
function TPartNumber:init_from_obj(obj) self.PartNumber = obj.PartNumber end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, "string", true,
                      errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs,
                                 need_convert)
    return self
end

function TPartNumber:unpack(_) return self.PartNumber end

PCIeCard.PartNumber = TPartNumber

---@class PCIeCard.FirmwareVersion
---@field FirmwareVersion string
local TFirmwareVersion = {}
TFirmwareVersion.__index = TFirmwareVersion
TFirmwareVersion.group = {}

local function TFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TFirmwareVersion)
end

function TFirmwareVersion.new(FirmwareVersion)
    return TFirmwareVersion_from_obj({FirmwareVersion = FirmwareVersion})
end
---@param obj PCIeCard.FirmwareVersion
function TFirmwareVersion:init_from_obj(obj)
    self.FirmwareVersion = obj.FirmwareVersion
end

function TFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareVersion.group)
end

TFirmwareVersion.from_obj = TFirmwareVersion_from_obj

TFirmwareVersion.proto_property = {'FirmwareVersion'}

TFirmwareVersion.default = {''}

TFirmwareVersion.struct = {
    {name = 'FirmwareVersion', is_array = false, struct = nil}
}

function TFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion,
                      "string", true, errs, need_convert)

    TFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareVersion.proto_property, errs,
                                 need_convert)
    return self
end

function TFirmwareVersion:unpack(_) return self.FirmwareVersion end

PCIeCard.FirmwareVersion = TFirmwareVersion

---@class PCIeCard.LaneOwner
---@field LaneOwner integer
local TLaneOwner = {}
TLaneOwner.__index = TLaneOwner
TLaneOwner.group = {}

local function TLaneOwner_from_obj(obj) return setmetatable(obj, TLaneOwner) end

function TLaneOwner.new(LaneOwner)
    return TLaneOwner_from_obj({LaneOwner = LaneOwner})
end
---@param obj PCIeCard.LaneOwner
function TLaneOwner:init_from_obj(obj) self.LaneOwner = obj.LaneOwner end

function TLaneOwner:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLaneOwner.group)
end

TLaneOwner.from_obj = TLaneOwner_from_obj

TLaneOwner.proto_property = {'LaneOwner'}

TLaneOwner.default = {0}

TLaneOwner.struct = {{name = 'LaneOwner', is_array = false, struct = nil}}

function TLaneOwner:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LaneOwner', self.LaneOwner, "uint8", true,
                      errs, need_convert)

    TLaneOwner:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLaneOwner.proto_property, errs,
                                 need_convert)
    return self
end

function TLaneOwner:unpack(_) return self.LaneOwner end

PCIeCard.LaneOwner = TLaneOwner

---@class PCIeCard.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj PCIeCard.Manufacturer
function TManufacturer:init_from_obj(obj) self.Manufacturer = obj.Manufacturer end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, "string",
                      true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs,
                                 need_convert)
    return self
end

function TManufacturer:unpack(_) return self.Manufacturer end

PCIeCard.Manufacturer = TManufacturer

---@class PCIeCard.Position
---@field Position string
local TPosition = {}
TPosition.__index = TPosition
TPosition.group = {}

local function TPosition_from_obj(obj) return setmetatable(obj, TPosition) end

function TPosition.new(Position) return
    TPosition_from_obj({Position = Position}) end
---@param obj PCIeCard.Position
function TPosition:init_from_obj(obj) self.Position = obj.Position end

function TPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPosition.group)
end

TPosition.from_obj = TPosition_from_obj

TPosition.proto_property = {'Position'}

TPosition.default = {''}

TPosition.struct = {{name = 'Position', is_array = false, struct = nil}}

function TPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Position', self.Position, "string", true, errs,
                      need_convert)

    TPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPosition.proto_property, errs,
                                 need_convert)
    return self
end

function TPosition:unpack(_) return self.Position end

PCIeCard.Position = TPosition

---@class PCIeCard.SubDeviceID
---@field SubDeviceID integer
local TSubDeviceID = {}
TSubDeviceID.__index = TSubDeviceID
TSubDeviceID.group = {}

local function TSubDeviceID_from_obj(obj) return setmetatable(obj, TSubDeviceID) end

function TSubDeviceID.new(SubDeviceID)
    return TSubDeviceID_from_obj({SubDeviceID = SubDeviceID})
end
---@param obj PCIeCard.SubDeviceID
function TSubDeviceID:init_from_obj(obj) self.SubDeviceID = obj.SubDeviceID end

function TSubDeviceID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubDeviceID.group)
end

TSubDeviceID.from_obj = TSubDeviceID_from_obj

TSubDeviceID.proto_property = {'SubDeviceID'}

TSubDeviceID.default = {0}

TSubDeviceID.struct = {{name = 'SubDeviceID', is_array = false, struct = nil}}

function TSubDeviceID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubDeviceID', self.SubDeviceID, "uint16", true,
                      errs, need_convert)

    TSubDeviceID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubDeviceID.proto_property, errs,
                                 need_convert)
    return self
end

function TSubDeviceID:unpack(_) return self.SubDeviceID end

PCIeCard.SubDeviceID = TSubDeviceID

---@class PCIeCard.SubVendorID
---@field SubVendorID integer
local TSubVendorID = {}
TSubVendorID.__index = TSubVendorID
TSubVendorID.group = {}

local function TSubVendorID_from_obj(obj) return setmetatable(obj, TSubVendorID) end

function TSubVendorID.new(SubVendorID)
    return TSubVendorID_from_obj({SubVendorID = SubVendorID})
end
---@param obj PCIeCard.SubVendorID
function TSubVendorID:init_from_obj(obj) self.SubVendorID = obj.SubVendorID end

function TSubVendorID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubVendorID.group)
end

TSubVendorID.from_obj = TSubVendorID_from_obj

TSubVendorID.proto_property = {'SubVendorID'}

TSubVendorID.default = {0}

TSubVendorID.struct = {{name = 'SubVendorID', is_array = false, struct = nil}}

function TSubVendorID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubVendorID', self.SubVendorID, "uint16", true,
                      errs, need_convert)

    TSubVendorID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubVendorID.proto_property, errs,
                                 need_convert)
    return self
end

function TSubVendorID:unpack(_) return self.SubVendorID end

PCIeCard.SubVendorID = TSubVendorID

---@class PCIeCard.DeviceID
---@field DeviceID integer
local TDeviceID = {}
TDeviceID.__index = TDeviceID
TDeviceID.group = {}

local function TDeviceID_from_obj(obj) return setmetatable(obj, TDeviceID) end

function TDeviceID.new(DeviceID) return
    TDeviceID_from_obj({DeviceID = DeviceID}) end
---@param obj PCIeCard.DeviceID
function TDeviceID:init_from_obj(obj) self.DeviceID = obj.DeviceID end

function TDeviceID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceID.group)
end

TDeviceID.from_obj = TDeviceID_from_obj

TDeviceID.proto_property = {'DeviceID'}

TDeviceID.default = {0}

TDeviceID.struct = {{name = 'DeviceID', is_array = false, struct = nil}}

function TDeviceID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceID', self.DeviceID, "uint16", true, errs,
                      need_convert)

    TDeviceID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceID.proto_property, errs,
                                 need_convert)
    return self
end

function TDeviceID:unpack(_) return self.DeviceID end

PCIeCard.DeviceID = TDeviceID

---@class PCIeCard.VendorID
---@field VendorID integer
local TVendorID = {}
TVendorID.__index = TVendorID
TVendorID.group = {}

local function TVendorID_from_obj(obj) return setmetatable(obj, TVendorID) end

function TVendorID.new(VendorID) return
    TVendorID_from_obj({VendorID = VendorID}) end
---@param obj PCIeCard.VendorID
function TVendorID:init_from_obj(obj) self.VendorID = obj.VendorID end

function TVendorID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVendorID.group)
end

TVendorID.from_obj = TVendorID_from_obj

TVendorID.proto_property = {'VendorID'}

TVendorID.default = {0}

TVendorID.struct = {{name = 'VendorID', is_array = false, struct = nil}}

function TVendorID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VendorID', self.VendorID, "uint16", true, errs,
                      need_convert)

    TVendorID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVendorID.proto_property, errs,
                                 need_convert)
    return self
end

function TVendorID:unpack(_) return self.VendorID end

PCIeCard.VendorID = TVendorID

---@class PCIeCard.LinkSpeed
---@field LinkSpeed string
local TLinkSpeed = {}
TLinkSpeed.__index = TLinkSpeed
TLinkSpeed.group = {}

local function TLinkSpeed_from_obj(obj) return setmetatable(obj, TLinkSpeed) end

function TLinkSpeed.new(LinkSpeed)
    return TLinkSpeed_from_obj({LinkSpeed = LinkSpeed})
end
---@param obj PCIeCard.LinkSpeed
function TLinkSpeed:init_from_obj(obj) self.LinkSpeed = obj.LinkSpeed end

function TLinkSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkSpeed.group)
end

TLinkSpeed.from_obj = TLinkSpeed_from_obj

TLinkSpeed.proto_property = {'LinkSpeed'}

TLinkSpeed.default = {''}

TLinkSpeed.struct = {{name = 'LinkSpeed', is_array = false, struct = nil}}

function TLinkSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkSpeed', self.LinkSpeed, "string", true,
                      errs, need_convert)

    TLinkSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkSpeed.proto_property, errs,
                                 need_convert)
    return self
end

function TLinkSpeed:unpack(_) return self.LinkSpeed end

PCIeCard.LinkSpeed = TLinkSpeed

---@class PCIeCard.LinkSpeedCapability
---@field LinkSpeedCapability string
local TLinkSpeedCapability = {}
TLinkSpeedCapability.__index = TLinkSpeedCapability
TLinkSpeedCapability.group = {}

local function TLinkSpeedCapability_from_obj(obj)
    return setmetatable(obj, TLinkSpeedCapability)
end

function TLinkSpeedCapability.new(LinkSpeedCapability)
    return TLinkSpeedCapability_from_obj({
        LinkSpeedCapability = LinkSpeedCapability
    })
end
---@param obj PCIeCard.LinkSpeedCapability
function TLinkSpeedCapability:init_from_obj(obj)
    self.LinkSpeedCapability = obj.LinkSpeedCapability
end

function TLinkSpeedCapability:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkSpeedCapability.group)
end

TLinkSpeedCapability.from_obj = TLinkSpeedCapability_from_obj

TLinkSpeedCapability.proto_property = {'LinkSpeedCapability'}

TLinkSpeedCapability.default = {''}

TLinkSpeedCapability.struct = {
    {name = 'LinkSpeedCapability', is_array = false, struct = nil}
}

function TLinkSpeedCapability:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkSpeedCapability', self.LinkSpeedCapability,
                      "string", true, errs, need_convert)

    TLinkSpeedCapability:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkSpeedCapability.proto_property,
                                 errs, need_convert)
    return self
end

function TLinkSpeedCapability:unpack(_) return self.LinkSpeedCapability end

PCIeCard.LinkSpeedCapability = TLinkSpeedCapability

---@class PCIeCard.LinkWidth
---@field LinkWidth string
local TLinkWidth = {}
TLinkWidth.__index = TLinkWidth
TLinkWidth.group = {}

local function TLinkWidth_from_obj(obj) return setmetatable(obj, TLinkWidth) end

function TLinkWidth.new(LinkWidth)
    return TLinkWidth_from_obj({LinkWidth = LinkWidth})
end
---@param obj PCIeCard.LinkWidth
function TLinkWidth:init_from_obj(obj) self.LinkWidth = obj.LinkWidth end

function TLinkWidth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkWidth.group)
end

TLinkWidth.from_obj = TLinkWidth_from_obj

TLinkWidth.proto_property = {'LinkWidth'}

TLinkWidth.default = {''}

TLinkWidth.struct = {{name = 'LinkWidth', is_array = false, struct = nil}}

function TLinkWidth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkWidth', self.LinkWidth, "string", true,
                      errs, need_convert)

    TLinkWidth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkWidth.proto_property, errs,
                                 need_convert)
    return self
end

function TLinkWidth:unpack(_) return self.LinkWidth end

PCIeCard.LinkWidth = TLinkWidth

---@class PCIeCard.LinkWidthAbility
---@field LinkWidthAbility string
local TLinkWidthAbility = {}
TLinkWidthAbility.__index = TLinkWidthAbility
TLinkWidthAbility.group = {}

local function TLinkWidthAbility_from_obj(obj)
    return setmetatable(obj, TLinkWidthAbility)
end

function TLinkWidthAbility.new(LinkWidthAbility)
    return TLinkWidthAbility_from_obj({LinkWidthAbility = LinkWidthAbility})
end
---@param obj PCIeCard.LinkWidthAbility
function TLinkWidthAbility:init_from_obj(obj)
    self.LinkWidthAbility = obj.LinkWidthAbility
end

function TLinkWidthAbility:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkWidthAbility.group)
end

TLinkWidthAbility.from_obj = TLinkWidthAbility_from_obj

TLinkWidthAbility.proto_property = {'LinkWidthAbility'}

TLinkWidthAbility.default = {''}

TLinkWidthAbility.struct = {
    {name = 'LinkWidthAbility', is_array = false, struct = nil}
}

function TLinkWidthAbility:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkWidthAbility', self.LinkWidthAbility,
                      "string", true, errs, need_convert)

    TLinkWidthAbility:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkWidthAbility.proto_property, errs,
                                 need_convert)
    return self
end

function TLinkWidthAbility:unpack(_) return self.LinkWidthAbility end

PCIeCard.LinkWidthAbility = TLinkWidthAbility

---@class PCIeCard.BoardName
---@field BoardName string
local TBoardName = {}
TBoardName.__index = TBoardName
TBoardName.group = {}

local function TBoardName_from_obj(obj) return setmetatable(obj, TBoardName) end

function TBoardName.new(BoardName)
    return TBoardName_from_obj({BoardName = BoardName})
end
---@param obj PCIeCard.BoardName
function TBoardName:init_from_obj(obj) self.BoardName = obj.BoardName end

function TBoardName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardName.group)
end

TBoardName.from_obj = TBoardName_from_obj

TBoardName.proto_property = {'BoardName'}

TBoardName.default = {''}

TBoardName.struct = {{name = 'BoardName', is_array = false, struct = nil}}

function TBoardName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardName', self.BoardName, "string", true,
                      errs, need_convert)

    TBoardName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardName.proto_property, errs,
                                 need_convert)
    return self
end

function TBoardName:unpack(_) return self.BoardName end

PCIeCard.BoardName = TBoardName

---@class PCIeCard.BoardID
---@field BoardID integer
local TBoardID = {}
TBoardID.__index = TBoardID
TBoardID.group = {}

local function TBoardID_from_obj(obj) return setmetatable(obj, TBoardID) end

function TBoardID.new(BoardID) return TBoardID_from_obj({BoardID = BoardID}) end
---@param obj PCIeCard.BoardID
function TBoardID:init_from_obj(obj) self.BoardID = obj.BoardID end

function TBoardID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardID.group)
end

TBoardID.from_obj = TBoardID_from_obj

TBoardID.proto_property = {'BoardID'}

TBoardID.default = {0}

TBoardID.struct = {{name = 'BoardID', is_array = false, struct = nil}}

function TBoardID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardID', self.BoardID, "uint16", true, errs,
                      need_convert)

    TBoardID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardID.proto_property, errs,
                                 need_convert)
    return self
end

function TBoardID:unpack(_) return self.BoardID end

PCIeCard.BoardID = TBoardID

---@class PCIeCard.PcbVersion
---@field PcbVersion string
local TPcbVersion = {}
TPcbVersion.__index = TPcbVersion
TPcbVersion.group = {}

local function TPcbVersion_from_obj(obj) return setmetatable(obj, TPcbVersion) end

function TPcbVersion.new(PcbVersion)
    return TPcbVersion_from_obj({PcbVersion = PcbVersion})
end
---@param obj PCIeCard.PcbVersion
function TPcbVersion:init_from_obj(obj) self.PcbVersion = obj.PcbVersion end

function TPcbVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcbVersion.group)
end

TPcbVersion.from_obj = TPcbVersion_from_obj

TPcbVersion.proto_property = {'PcbVersion'}

TPcbVersion.default = {''}

TPcbVersion.struct = {{name = 'PcbVersion', is_array = false, struct = nil}}

function TPcbVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PcbVersion', self.PcbVersion, "string", true,
                      errs, need_convert)

    TPcbVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcbVersion.proto_property, errs,
                                 need_convert)
    return self
end

function TPcbVersion:unpack(_) return self.PcbVersion end

PCIeCard.PcbVersion = TPcbVersion

---@class PCIeCard.Description
---@field Description string
local TDescription = {}
TDescription.__index = TDescription
TDescription.group = {}

local function TDescription_from_obj(obj) return setmetatable(obj, TDescription) end

function TDescription.new(Description)
    return TDescription_from_obj({Description = Description})
end
---@param obj PCIeCard.Description
function TDescription:init_from_obj(obj) self.Description = obj.Description end

function TDescription:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDescription.group)
end

TDescription.from_obj = TDescription_from_obj

TDescription.proto_property = {'Description'}

TDescription.default = {''}

TDescription.struct = {{name = 'Description', is_array = false, struct = nil}}

function TDescription:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Description', self.Description, "string", true,
                      errs, need_convert)

    TDescription:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDescription.proto_property, errs,
                                 need_convert)
    return self
end

function TDescription:unpack(_) return self.Description end

PCIeCard.Description = TDescription

---@class PCIeCard.FunctionClass
---@field FunctionClass integer
local TFunctionClass = {}
TFunctionClass.__index = TFunctionClass
TFunctionClass.group = {}

local function TFunctionClass_from_obj(obj)
    return setmetatable(obj, TFunctionClass)
end

function TFunctionClass.new(FunctionClass)
    return TFunctionClass_from_obj({FunctionClass = FunctionClass})
end
---@param obj PCIeCard.FunctionClass
function TFunctionClass:init_from_obj(obj) self.FunctionClass =
    obj.FunctionClass end

function TFunctionClass:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunctionClass.group)
end

TFunctionClass.from_obj = TFunctionClass_from_obj

TFunctionClass.proto_property = {'FunctionClass'}

TFunctionClass.default = {0}

TFunctionClass.struct = {
    {name = 'FunctionClass', is_array = false, struct = nil}
}

function TFunctionClass:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FunctionClass', self.FunctionClass, "uint8",
                      true, errs, need_convert)

    TFunctionClass:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunctionClass.proto_property, errs,
                                 need_convert)
    return self
end

function TFunctionClass:unpack(_) return self.FunctionClass end

PCIeCard.FunctionClass = TFunctionClass

---@class PCIeCard.DeviceName
---@field DeviceName string
local TDeviceName = {}
TDeviceName.__index = TDeviceName
TDeviceName.group = {}

local function TDeviceName_from_obj(obj) return setmetatable(obj, TDeviceName) end

function TDeviceName.new(DeviceName)
    return TDeviceName_from_obj({DeviceName = DeviceName})
end
---@param obj PCIeCard.DeviceName
function TDeviceName:init_from_obj(obj) self.DeviceName = obj.DeviceName end

function TDeviceName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceName.group)
end

TDeviceName.from_obj = TDeviceName_from_obj

TDeviceName.proto_property = {'DeviceName'}

TDeviceName.default = {''}

TDeviceName.struct = {{name = 'DeviceName', is_array = false, struct = nil}}

function TDeviceName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceName', self.DeviceName, "string", true,
                      errs, need_convert)

    TDeviceName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceName.proto_property, errs,
                                 need_convert)
    return self
end

function TDeviceName:unpack(_) return self.DeviceName end

PCIeCard.DeviceName = TDeviceName

---@class PCIeCard.SlotID
---@field SlotID integer
local TSlotID = {}
TSlotID.__index = TSlotID
TSlotID.group = {}

local function TSlotID_from_obj(obj) return setmetatable(obj, TSlotID) end

function TSlotID.new(SlotID) return TSlotID_from_obj({SlotID = SlotID}) end
---@param obj PCIeCard.SlotID
function TSlotID:init_from_obj(obj) self.SlotID = obj.SlotID end

function TSlotID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotID.group)
end

TSlotID.from_obj = TSlotID_from_obj

TSlotID.proto_property = {'SlotID'}

TSlotID.default = {0}

TSlotID.struct = {{name = 'SlotID', is_array = false, struct = nil}}

function TSlotID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotID', self.SlotID, "uint8", true, errs,
                      need_convert)

    TSlotID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotID.proto_property, errs,
                                 need_convert)
    return self
end

function TSlotID:unpack(_) return self.SlotID end

PCIeCard.SlotID = TSlotID

---@class PCIeCard.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj) return setmetatable(obj, TName) end

function TName.new(Name) return TName_from_obj({Name = Name}) end
---@param obj PCIeCard.Name
function TName:init_from_obj(obj) self.Name = obj.Name end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, "string", true, errs,
                      need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_) return self.Name end

PCIeCard.Name = TName

PCIeCard.interface = mdb.register_interface(
                         'bmc.kepler.Systems.PCIeDevices.PCIeCard', {
        Name = {'s', nil, true, nil, false},
        SlotID = {'y', nil, true, nil, false},
        DeviceName = {'s', nil, true, nil, false},
        FunctionClass = {'y', nil, true, nil, false},
        Description = {'s', nil, true, nil, false},
        PcbVersion = {'s', nil, true, nil, false},
        BoardID = {'q', nil, true, nil, false},
        BoardName = {'s', nil, true, nil, false},
        LinkWidthAbility = {'s', nil, true, nil, false},
        LinkWidth = {'s', nil, true, nil, false},
        LinkSpeedCapability = {'s', nil, true, nil, false},
        LinkSpeed = {'s', nil, true, nil, false},
        VendorID = {'q', nil, true, nil, false},
        DeviceID = {'q', nil, true, nil, false},
        SubVendorID = {'q', nil, true, nil, false},
        SubDeviceID = {'q', nil, true, nil, false},
        Position = {'s', nil, true, nil, false},
        Manufacturer = {'s', nil, true, nil, false},
        LaneOwner = {'y', nil, true, nil, false},
        FirmwareVersion = {'s', nil, true, nil, false},
        PartNumber = {'s', nil, true, nil, false},
        SerialNumber = {'s', nil, true, nil, false},
        RefComponent = {'s', nil, true, nil, false},
        Health = {'y', nil, true, nil, false},
        Model = {'s', nil, true, nil, false},
        NodeID = {'s', nil, true, nil, false},
        Presence = {'y', nil, true, nil, false},
        CardModel = {'s', {'CONST'}, true, nil, false},
        CardManufacturer = {'s', {'CONST'}, true, nil, false},
        CardForServers = {'ay', {}, true, nil, false}
    }, {}, {})

return PCIeCard
