-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Metric = {}

---@class Metric.CollectSignalSignature
---@field MetricName string
---@field TagPath string
local TCollectSignalSignature = {}
TCollectSignalSignature.__index = TCollectSignalSignature
TCollectSignalSignature.group = {}

local function TCollectSignalSignature_from_obj(obj)
    return setmetatable(obj, TCollectSignalSignature)
end

function TCollectSignalSignature.new(MetricName, TagPath)
    return TCollectSignalSignature_from_obj({
        MetricName = MetricName,
        TagPath = TagPath
    })
end
---@param obj Metric.CollectSignalSignature
function TCollectSignalSignature:init_from_obj(obj)
    self.MetricName = obj.MetricName
    self.TagPath = obj.TagPath
end

function TCollectSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCollectSignalSignature.group)
end

TCollectSignalSignature.from_obj = TCollectSignalSignature_from_obj

TCollectSignalSignature.proto_property = {'MetricName', 'TagPath'}

TCollectSignalSignature.default = {'', ''}

TCollectSignalSignature.struct = {
    {name = 'MetricName', is_array = false, struct = nil},
    {name = 'TagPath', is_array = false, struct = nil}
}

function TCollectSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MetricName', self.MetricName, "string", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'TagPath', self.TagPath, "string", false, errs,
                      need_convert)

    TCollectSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCollectSignalSignature.proto_property,
                                 errs, need_convert)
    return self
end

function TCollectSignalSignature:unpack(_) return self.MetricName, self.TagPath end

Metric.CollectSignalSignature = TCollectSignalSignature

---@class Metric.SynDataAcquisitionEnableRsp
local TSynDataAcquisitionEnableRsp = {}
TSynDataAcquisitionEnableRsp.__index = TSynDataAcquisitionEnableRsp
TSynDataAcquisitionEnableRsp.group = {}

local function TSynDataAcquisitionEnableRsp_from_obj(obj)
    return setmetatable(obj, TSynDataAcquisitionEnableRsp)
end

function TSynDataAcquisitionEnableRsp.new()
    return TSynDataAcquisitionEnableRsp_from_obj({})
end
---@param obj Metric.SynDataAcquisitionEnableRsp
function TSynDataAcquisitionEnableRsp:init_from_obj(obj) end

function TSynDataAcquisitionEnableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TSynDataAcquisitionEnableRsp.group)
end

TSynDataAcquisitionEnableRsp.from_obj = TSynDataAcquisitionEnableRsp_from_obj

TSynDataAcquisitionEnableRsp.proto_property = {}

TSynDataAcquisitionEnableRsp.default = {}

TSynDataAcquisitionEnableRsp.struct = {}

function TSynDataAcquisitionEnableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSynDataAcquisitionEnableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TSynDataAcquisitionEnableRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSynDataAcquisitionEnableRsp:unpack(_) end

Metric.SynDataAcquisitionEnableRsp = TSynDataAcquisitionEnableRsp

---@class Metric.SynDataAcquisitionEnableReq
---@field Enabled integer
local TSynDataAcquisitionEnableReq = {}
TSynDataAcquisitionEnableReq.__index = TSynDataAcquisitionEnableReq
TSynDataAcquisitionEnableReq.group = {}

local function TSynDataAcquisitionEnableReq_from_obj(obj)
    return setmetatable(obj, TSynDataAcquisitionEnableReq)
end

function TSynDataAcquisitionEnableReq.new(Enabled)
    return TSynDataAcquisitionEnableReq_from_obj({Enabled = Enabled})
end
---@param obj Metric.SynDataAcquisitionEnableReq
function TSynDataAcquisitionEnableReq:init_from_obj(obj)
    self.Enabled = obj.Enabled
end

function TSynDataAcquisitionEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TSynDataAcquisitionEnableReq.group)
end

TSynDataAcquisitionEnableReq.from_obj = TSynDataAcquisitionEnableReq_from_obj

TSynDataAcquisitionEnableReq.proto_property = {'Enabled'}

TSynDataAcquisitionEnableReq.default = {0}

TSynDataAcquisitionEnableReq.struct = {
    {name = 'Enabled', is_array = false, struct = nil}
}

function TSynDataAcquisitionEnableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, "uint8", false, errs,
                      need_convert)

    TSynDataAcquisitionEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TSynDataAcquisitionEnableReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSynDataAcquisitionEnableReq:unpack(_) return self.Enabled end

Metric.SynDataAcquisitionEnableReq = TSynDataAcquisitionEnableReq

---@class Metric.GetItemsReq
local TGetItemsReq = {}
TGetItemsReq.__index = TGetItemsReq
TGetItemsReq.group = {}

local function TGetItemsReq_from_obj(obj) return setmetatable(obj, TGetItemsReq) end

function TGetItemsReq.new() return TGetItemsReq_from_obj({}) end
---@param obj Metric.GetItemsReq
function TGetItemsReq:init_from_obj(obj) end

function TGetItemsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetItemsReq.group)
end

TGetItemsReq.from_obj = TGetItemsReq_from_obj

TGetItemsReq.proto_property = {}

TGetItemsReq.default = {}

TGetItemsReq.struct = {}

function TGetItemsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetItemsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetItemsReq.proto_property, errs,
                                 need_convert)
    return self
end

function TGetItemsReq:unpack(_) end

Metric.GetItemsReq = TGetItemsReq

---@class Metric.GetDataReq
---@field MetricName string[]
local TGetDataReq = {}
TGetDataReq.__index = TGetDataReq
TGetDataReq.group = {}

local function TGetDataReq_from_obj(obj) return setmetatable(obj, TGetDataReq) end

function TGetDataReq.new(MetricName)
    return TGetDataReq_from_obj({MetricName = MetricName})
end
---@param obj Metric.GetDataReq
function TGetDataReq:init_from_obj(obj) self.MetricName = obj.MetricName end

function TGetDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDataReq.group)
end

TGetDataReq.from_obj = TGetDataReq_from_obj

TGetDataReq.proto_property = {'MetricName'}

TGetDataReq.default = {{}}

TGetDataReq.struct = {{name = 'MetricName', is_array = true, struct = nil}}

function TGetDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'MetricName', self.MetricName, "string",
                           false, errs, need_convert)

    TGetDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDataReq.proto_property, errs,
                                 need_convert)
    return self
end

function TGetDataReq:unpack(_) return self.MetricName end

Metric.GetDataReq = TGetDataReq

---@class Metric.TagProp
---@field PropName string
---@field PropVal string
local TTagProp = {}
TTagProp.__index = TTagProp
TTagProp.group = {}

local function TTagProp_from_obj(obj) return setmetatable(obj, TTagProp) end

function TTagProp.new(PropName, PropVal)
    return TTagProp_from_obj({PropName = PropName, PropVal = PropVal})
end
---@param obj Metric.TagProp
function TTagProp:init_from_obj(obj)
    self.PropName = obj.PropName
    self.PropVal = obj.PropVal
end

function TTagProp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTagProp.group)
end

TTagProp.from_obj = TTagProp_from_obj

TTagProp.proto_property = {'PropName', 'PropVal'}

TTagProp.default = {'', ''}

TTagProp.struct = {
    {name = 'PropName', is_array = false, struct = nil},
    {name = 'PropVal', is_array = false, struct = nil}
}

function TTagProp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PropName', self.PropName, "string", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'PropVal', self.PropVal, "string", false, errs,
                      need_convert)

    TTagProp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTagProp.proto_property, errs,
                                 need_convert)
    return self
end

function TTagProp:unpack(_) return self.PropName, self.PropVal end

Metric.TagProp = TTagProp

---@class Metric.GetItemsRsp
---@field Component string
---@field Classification Metric.TagProp[]
---@field Identification Metric.TagProp[]
---@field MetricName string[]
local TGetItemsRsp = {}
TGetItemsRsp.__index = TGetItemsRsp
TGetItemsRsp.group = {}

local function TGetItemsRsp_from_obj(obj)
    obj.Classification =
        utils.from_obj(Metric.TagProp, obj.Classification, true)
    obj.Identification =
        utils.from_obj(Metric.TagProp, obj.Identification, true)
    return setmetatable(obj, TGetItemsRsp)
end

function TGetItemsRsp.new(Component, Classification, Identification, MetricName)
    return TGetItemsRsp_from_obj({
        Component = Component,
        Classification = Classification,
        Identification = Identification,
        MetricName = MetricName
    })
end
---@param obj Metric.GetItemsRsp
function TGetItemsRsp:init_from_obj(obj)
    self.Component = obj.Component
    self.Classification = obj.Classification
    self.Identification = obj.Identification
    self.MetricName = obj.MetricName
end

function TGetItemsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetItemsRsp.group)
end

TGetItemsRsp.from_obj = TGetItemsRsp_from_obj

TGetItemsRsp.proto_property = {
    'Component', 'Classification', 'Identification', 'MetricName'
}

TGetItemsRsp.default = {'', {}, {}, {}}

TGetItemsRsp.struct = {
    {name = 'Component', is_array = false, struct = nil},
    {name = 'Classification', is_array = true, struct = Metric.TagProp.struct},
    {name = 'Identification', is_array = true, struct = Metric.TagProp.struct},
    {name = 'MetricName', is_array = true, struct = nil}
}

function TGetItemsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Classification) do
        Metric.TagProp.new(v.PropName, v.PropVal):validate(prefix, errs,
                                                           need_convert)
    end
    for _, v in pairs(self.Identification) do
        Metric.TagProp.new(v.PropName, v.PropVal):validate(prefix, errs,
                                                           need_convert)
    end

    validate.Optional(prefix .. 'Component', self.Component, "string", false,
                      errs, need_convert)
    validate.OptionalArray(prefix .. 'MetricName', self.MetricName, "string",
                           false, errs, need_convert)

    TGetItemsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetItemsRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TGetItemsRsp:unpack(raw)
    return self.Component, utils.unpack(raw, self.Classification, true),
           utils.unpack(raw, self.Identification, true), self.MetricName
end

Metric.GetItemsRsp = TGetItemsRsp

---@class Metric.DataCollectionItem
---@field MetricName string
---@field Data string[]
local TDataCollectionItem = {}
TDataCollectionItem.__index = TDataCollectionItem
TDataCollectionItem.group = {}

local function TDataCollectionItem_from_obj(obj)
    return setmetatable(obj, TDataCollectionItem)
end

function TDataCollectionItem.new(MetricName, Data)
    return TDataCollectionItem_from_obj({MetricName = MetricName, Data = Data})
end
---@param obj Metric.DataCollectionItem
function TDataCollectionItem:init_from_obj(obj)
    self.MetricName = obj.MetricName
    self.Data = obj.Data
end

function TDataCollectionItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDataCollectionItem.group)
end

TDataCollectionItem.from_obj = TDataCollectionItem_from_obj

TDataCollectionItem.proto_property = {'MetricName', 'Data'}

TDataCollectionItem.default = {'', {}}

TDataCollectionItem.struct = {
    {name = 'MetricName', is_array = false, struct = nil},
    {name = 'Data', is_array = true, struct = nil}
}

function TDataCollectionItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MetricName', self.MetricName, "string", false,
                      errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, "string", false, errs,
                           need_convert)

    TDataCollectionItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDataCollectionItem.proto_property, errs,
                                 need_convert)
    return self
end

function TDataCollectionItem:unpack(_) return self.MetricName, self.Data end

Metric.DataCollectionItem = TDataCollectionItem

---@class Metric.GetDataRsp
---@field Val Metric.DataCollectionItem[]
local TGetDataRsp = {}
TGetDataRsp.__index = TGetDataRsp
TGetDataRsp.group = {}

local function TGetDataRsp_from_obj(obj)
    obj.Val = utils.from_obj(Metric.DataCollectionItem, obj.Val, true)
    return setmetatable(obj, TGetDataRsp)
end

function TGetDataRsp.new(Val) return TGetDataRsp_from_obj({Val = Val}) end
---@param obj Metric.GetDataRsp
function TGetDataRsp:init_from_obj(obj) self.Val = obj.Val end

function TGetDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDataRsp.group)
end

TGetDataRsp.from_obj = TGetDataRsp_from_obj

TGetDataRsp.proto_property = {'Val'}

TGetDataRsp.default = {{}}

TGetDataRsp.struct = {
    {name = 'Val', is_array = true, struct = Metric.DataCollectionItem.struct}
}

function TGetDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Val) do
        Metric.DataCollectionItem.new(v.MetricName, v.Data):validate(prefix,
                                                                     errs,
                                                                     need_convert)
    end

    TGetDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDataRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TGetDataRsp:unpack(raw) return utils.unpack(raw, self.Val, true) end

Metric.GetDataRsp = TGetDataRsp

Metric.interface = mdb.register_interface('bmc.kepler.Metric', {}, {
    GetData = {'a{ss}as', 'a(sas)', TGetDataReq, TGetDataRsp},
    GetItems = {'a{ss}', 'sa(ss)a(ss)as', TGetItemsReq, TGetItemsRsp},
    SynDataAcquisitionEnable = {
        'a{ss}y', '', TSynDataAcquisitionEnableReq, TSynDataAcquisitionEnableRsp
    }
}, {CollectSignal = 'a{ss}ss'})

return Metric
