-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FanType = {}

---@class FanType.FanDiameterMm
---@field FanDiameterMm integer
local TFanDiameterMm = {}
TFanDiameterMm.__index = TFanDiameterMm
TFanDiameterMm.group = {}

local function TFanDiameterMm_from_obj(obj)
    return setmetatable(obj, TFanDiameterMm)
end

function TFanDiameterMm.new(FanDiameterMm)
    return TFanDiameterMm_from_obj({FanDiameterMm = FanDiameterMm})
end
---@param obj FanType.FanDiameterMm
function TFanDiameterMm:init_from_obj(obj) self.FanDiameterMm =
    obj.FanDiameterMm end

function TFanDiameterMm:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanDiameterMm.group)
end

TFanDiameterMm.from_obj = TFanDiameterMm_from_obj

TFanDiameterMm.proto_property = {'FanDiameterMm'}

TFanDiameterMm.default = {0}

TFanDiameterMm.struct = {
    {name = 'FanDiameterMm', is_array = false, struct = nil}
}

function TFanDiameterMm:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanDiameterMm', self.FanDiameterMm, "uint16",
                      true, errs, need_convert)

    TFanDiameterMm:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanDiameterMm.proto_property, errs,
                                 need_convert)
    return self
end

function TFanDiameterMm:unpack(_) return self.FanDiameterMm end

FanType.FanDiameterMm = TFanDiameterMm

---@class FanType.PowerRange
---@field PowerRange integer[]
local TPowerRange = {}
TPowerRange.__index = TPowerRange
TPowerRange.group = {}

local function TPowerRange_from_obj(obj) return setmetatable(obj, TPowerRange) end

function TPowerRange.new(PowerRange)
    return TPowerRange_from_obj({PowerRange = PowerRange})
end
---@param obj FanType.PowerRange
function TPowerRange:init_from_obj(obj) self.PowerRange = obj.PowerRange end

function TPowerRange:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerRange.group)
end

TPowerRange.from_obj = TPowerRange_from_obj

TPowerRange.proto_property = {'PowerRange'}

TPowerRange.default = {{}}

TPowerRange.struct = {{name = 'PowerRange', is_array = true, struct = nil}}

function TPowerRange:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PowerRange', self.PowerRange, "uint16",
                           true, errs, need_convert)

    TPowerRange:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerRange.proto_property, errs,
                                 need_convert)
    return self
end

function TPowerRange:unpack(_) return self.PowerRange end

FanType.PowerRange = TPowerRange

---@class FanType.SpeedRange
---@field SpeedRange integer[]
local TSpeedRange = {}
TSpeedRange.__index = TSpeedRange
TSpeedRange.group = {}

local function TSpeedRange_from_obj(obj) return setmetatable(obj, TSpeedRange) end

function TSpeedRange.new(SpeedRange)
    return TSpeedRange_from_obj({SpeedRange = SpeedRange})
end
---@param obj FanType.SpeedRange
function TSpeedRange:init_from_obj(obj) self.SpeedRange = obj.SpeedRange end

function TSpeedRange:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedRange.group)
end

TSpeedRange.from_obj = TSpeedRange_from_obj

TSpeedRange.proto_property = {'SpeedRange'}

TSpeedRange.default = {{}}

TSpeedRange.struct = {{name = 'SpeedRange', is_array = true, struct = nil}}

function TSpeedRange:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SpeedRange', self.SpeedRange, "uint8",
                           true, errs, need_convert)

    TSpeedRange:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedRange.proto_property, errs,
                                 need_convert)
    return self
end

function TSpeedRange:unpack(_) return self.SpeedRange end

FanType.SpeedRange = TSpeedRange

---@class FanType.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj) return setmetatable(obj, TSystemId) end

function TSystemId.new(SystemId) return
    TSystemId_from_obj({SystemId = SystemId}) end
---@param obj FanType.SystemId
function TSystemId:init_from_obj(obj) self.SystemId = obj.SystemId end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, "uint8", true, errs,
                      need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs,
                                 need_convert)
    return self
end

function TSystemId:unpack(_) return self.SystemId end

FanType.SystemId = TSystemId

---@class FanType.BOM
---@field BOM string
local TBOM = {}
TBOM.__index = TBOM
TBOM.group = {}

local function TBOM_from_obj(obj) return setmetatable(obj, TBOM) end

function TBOM.new(BOM) return TBOM_from_obj({BOM = BOM}) end
---@param obj FanType.BOM
function TBOM:init_from_obj(obj) self.BOM = obj.BOM end

function TBOM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBOM.group)
end

TBOM.from_obj = TBOM_from_obj

TBOM.proto_property = {'BOM'}

TBOM.default = {''}

TBOM.struct = {{name = 'BOM', is_array = false, struct = nil}}

function TBOM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BOM', self.BOM, "string", true, errs,
                      need_convert)

    TBOM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBOM.proto_property, errs, need_convert)
    return self
end

function TBOM:unpack(_) return self.BOM end

FanType.BOM = TBOM

---@class FanType.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj) return setmetatable(obj, TPartNumber) end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj FanType.PartNumber
function TPartNumber:init_from_obj(obj) self.PartNumber = obj.PartNumber end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, "string", true,
                      errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs,
                                 need_convert)
    return self
end

function TPartNumber:unpack(_) return self.PartNumber end

FanType.PartNumber = TPartNumber

---@class FanType.MatchedCount
---@field MatchedCount integer
local TMatchedCount = {}
TMatchedCount.__index = TMatchedCount
TMatchedCount.group = {}

local function TMatchedCount_from_obj(obj)
    return setmetatable(obj, TMatchedCount)
end

function TMatchedCount.new(MatchedCount)
    return TMatchedCount_from_obj({MatchedCount = MatchedCount})
end
---@param obj FanType.MatchedCount
function TMatchedCount:init_from_obj(obj) self.MatchedCount = obj.MatchedCount end

function TMatchedCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMatchedCount.group)
end

TMatchedCount.from_obj = TMatchedCount_from_obj

TMatchedCount.proto_property = {'MatchedCount'}

TMatchedCount.default = {0}

TMatchedCount.struct = {{name = 'MatchedCount', is_array = false, struct = nil}}

function TMatchedCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MatchedCount', self.MatchedCount, "uint8",
                      true, errs, need_convert)

    TMatchedCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMatchedCount.proto_property, errs,
                                 need_convert)
    return self
end

function TMatchedCount:unpack(_) return self.MatchedCount end

FanType.MatchedCount = TMatchedCount

---@class FanType.IdentifyRangeHigh
---@field IdentifyRangeHigh integer
local TIdentifyRangeHigh = {}
TIdentifyRangeHigh.__index = TIdentifyRangeHigh
TIdentifyRangeHigh.group = {}

local function TIdentifyRangeHigh_from_obj(obj)
    return setmetatable(obj, TIdentifyRangeHigh)
end

function TIdentifyRangeHigh.new(IdentifyRangeHigh)
    return TIdentifyRangeHigh_from_obj({IdentifyRangeHigh = IdentifyRangeHigh})
end
---@param obj FanType.IdentifyRangeHigh
function TIdentifyRangeHigh:init_from_obj(obj)
    self.IdentifyRangeHigh = obj.IdentifyRangeHigh
end

function TIdentifyRangeHigh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIdentifyRangeHigh.group)
end

TIdentifyRangeHigh.from_obj = TIdentifyRangeHigh_from_obj

TIdentifyRangeHigh.proto_property = {'IdentifyRangeHigh'}

TIdentifyRangeHigh.default = {0}

TIdentifyRangeHigh.struct = {
    {name = 'IdentifyRangeHigh', is_array = false, struct = nil}
}

function TIdentifyRangeHigh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IdentifyRangeHigh', self.IdentifyRangeHigh,
                      "uint32", true, errs, need_convert)

    TIdentifyRangeHigh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIdentifyRangeHigh.proto_property, errs,
                                 need_convert)
    return self
end

function TIdentifyRangeHigh:unpack(_) return self.IdentifyRangeHigh end

FanType.IdentifyRangeHigh = TIdentifyRangeHigh

---@class FanType.IdentifyRangeLow
---@field IdentifyRangeLow integer
local TIdentifyRangeLow = {}
TIdentifyRangeLow.__index = TIdentifyRangeLow
TIdentifyRangeLow.group = {}

local function TIdentifyRangeLow_from_obj(obj)
    return setmetatable(obj, TIdentifyRangeLow)
end

function TIdentifyRangeLow.new(IdentifyRangeLow)
    return TIdentifyRangeLow_from_obj({IdentifyRangeLow = IdentifyRangeLow})
end
---@param obj FanType.IdentifyRangeLow
function TIdentifyRangeLow:init_from_obj(obj)
    self.IdentifyRangeLow = obj.IdentifyRangeLow
end

function TIdentifyRangeLow:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIdentifyRangeLow.group)
end

TIdentifyRangeLow.from_obj = TIdentifyRangeLow_from_obj

TIdentifyRangeLow.proto_property = {'IdentifyRangeLow'}

TIdentifyRangeLow.default = {0}

TIdentifyRangeLow.struct = {
    {name = 'IdentifyRangeLow', is_array = false, struct = nil}
}

function TIdentifyRangeLow:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IdentifyRangeLow', self.IdentifyRangeLow,
                      "uint32", true, errs, need_convert)

    TIdentifyRangeLow:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIdentifyRangeLow.proto_property, errs,
                                 need_convert)
    return self
end

function TIdentifyRangeLow:unpack(_) return self.IdentifyRangeLow end

FanType.IdentifyRangeLow = TIdentifyRangeLow

---@class FanType.RearMaxSpeed
---@field RearMaxSpeed integer
local TRearMaxSpeed = {}
TRearMaxSpeed.__index = TRearMaxSpeed
TRearMaxSpeed.group = {}

local function TRearMaxSpeed_from_obj(obj)
    return setmetatable(obj, TRearMaxSpeed)
end

function TRearMaxSpeed.new(RearMaxSpeed)
    return TRearMaxSpeed_from_obj({RearMaxSpeed = RearMaxSpeed})
end
---@param obj FanType.RearMaxSpeed
function TRearMaxSpeed:init_from_obj(obj) self.RearMaxSpeed = obj.RearMaxSpeed end

function TRearMaxSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearMaxSpeed.group)
end

TRearMaxSpeed.from_obj = TRearMaxSpeed_from_obj

TRearMaxSpeed.proto_property = {'RearMaxSpeed'}

TRearMaxSpeed.default = {0}

TRearMaxSpeed.struct = {{name = 'RearMaxSpeed', is_array = false, struct = nil}}

function TRearMaxSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearMaxSpeed', self.RearMaxSpeed, "uint32",
                      true, errs, need_convert)

    TRearMaxSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearMaxSpeed.proto_property, errs,
                                 need_convert)
    return self
end

function TRearMaxSpeed:unpack(_) return self.RearMaxSpeed end

FanType.RearMaxSpeed = TRearMaxSpeed

---@class FanType.FrontMaxSpeed
---@field FrontMaxSpeed integer
local TFrontMaxSpeed = {}
TFrontMaxSpeed.__index = TFrontMaxSpeed
TFrontMaxSpeed.group = {}

local function TFrontMaxSpeed_from_obj(obj)
    return setmetatable(obj, TFrontMaxSpeed)
end

function TFrontMaxSpeed.new(FrontMaxSpeed)
    return TFrontMaxSpeed_from_obj({FrontMaxSpeed = FrontMaxSpeed})
end
---@param obj FanType.FrontMaxSpeed
function TFrontMaxSpeed:init_from_obj(obj) self.FrontMaxSpeed =
    obj.FrontMaxSpeed end

function TFrontMaxSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontMaxSpeed.group)
end

TFrontMaxSpeed.from_obj = TFrontMaxSpeed_from_obj

TFrontMaxSpeed.proto_property = {'FrontMaxSpeed'}

TFrontMaxSpeed.default = {0}

TFrontMaxSpeed.struct = {
    {name = 'FrontMaxSpeed', is_array = false, struct = nil}
}

function TFrontMaxSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontMaxSpeed', self.FrontMaxSpeed, "uint32",
                      true, errs, need_convert)

    TFrontMaxSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontMaxSpeed.proto_property, errs,
                                 need_convert)
    return self
end

function TFrontMaxSpeed:unpack(_) return self.FrontMaxSpeed end

FanType.FrontMaxSpeed = TFrontMaxSpeed

---@class FanType.IsTwins
---@field IsTwins boolean
local TIsTwins = {}
TIsTwins.__index = TIsTwins
TIsTwins.group = {}

local function TIsTwins_from_obj(obj) return setmetatable(obj, TIsTwins) end

function TIsTwins.new(IsTwins) return TIsTwins_from_obj({IsTwins = IsTwins}) end
---@param obj FanType.IsTwins
function TIsTwins:init_from_obj(obj) self.IsTwins = obj.IsTwins end

function TIsTwins:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsTwins.group)
end

TIsTwins.from_obj = TIsTwins_from_obj

TIsTwins.proto_property = {'IsTwins'}

TIsTwins.default = {false}

TIsTwins.struct = {{name = 'IsTwins', is_array = false, struct = nil}}

function TIsTwins:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsTwins', self.IsTwins, "bool", true, errs,
                      need_convert)

    TIsTwins:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsTwins.proto_property, errs,
                                 need_convert)
    return self
end

function TIsTwins:unpack(_) return self.IsTwins end

FanType.IsTwins = TIsTwins

---@class FanType.IsDefaultType
---@field IsDefaultType boolean
local TIsDefaultType = {}
TIsDefaultType.__index = TIsDefaultType
TIsDefaultType.group = {}

local function TIsDefaultType_from_obj(obj)
    return setmetatable(obj, TIsDefaultType)
end

function TIsDefaultType.new(IsDefaultType)
    return TIsDefaultType_from_obj({IsDefaultType = IsDefaultType})
end
---@param obj FanType.IsDefaultType
function TIsDefaultType:init_from_obj(obj) self.IsDefaultType =
    obj.IsDefaultType end

function TIsDefaultType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsDefaultType.group)
end

TIsDefaultType.from_obj = TIsDefaultType_from_obj

TIsDefaultType.proto_property = {'IsDefaultType'}

TIsDefaultType.default = {false}

TIsDefaultType.struct = {
    {name = 'IsDefaultType', is_array = false, struct = nil}
}

function TIsDefaultType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsDefaultType', self.IsDefaultType, "bool",
                      true, errs, need_convert)

    TIsDefaultType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsDefaultType.proto_property, errs,
                                 need_convert)
    return self
end

function TIsDefaultType:unpack(_) return self.IsDefaultType end

FanType.IsDefaultType = TIsDefaultType

---@class FanType.Index
---@field Index integer
local TIndex = {}
TIndex.__index = TIndex
TIndex.group = {}

local function TIndex_from_obj(obj) return setmetatable(obj, TIndex) end

function TIndex.new(Index) return TIndex_from_obj({Index = Index}) end
---@param obj FanType.Index
function TIndex:init_from_obj(obj) self.Index = obj.Index end

function TIndex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIndex.group)
end

TIndex.from_obj = TIndex_from_obj

TIndex.proto_property = {'Index'}

TIndex.default = {0}

TIndex.struct = {{name = 'Index', is_array = false, struct = nil}}

function TIndex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Index', self.Index, "uint8", true, errs,
                      need_convert)

    TIndex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIndex.proto_property, errs, need_convert)
    return self
end

function TIndex:unpack(_) return self.Index end

FanType.Index = TIndex

---@class FanType.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj) return setmetatable(obj, TName) end

function TName.new(Name) return TName_from_obj({Name = Name}) end
---@param obj FanType.Name
function TName:init_from_obj(obj) self.Name = obj.Name end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, "string", true, errs,
                      need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_) return self.Name end

FanType.Name = TName

FanType.interface = mdb.register_interface('bmc.kepler.Systems.FanType', {
    Name = {'s', nil, true, nil, false},
    Index = {'y', nil, true, nil, false},
    IsDefaultType = {'b', nil, true, nil, false},
    IsTwins = {'b', nil, true, nil, false},
    FrontMaxSpeed = {'u', nil, true, nil, false},
    RearMaxSpeed = {'u', nil, true, nil, false},
    IdentifyRangeLow = {'u', nil, true, nil, false},
    IdentifyRangeHigh = {'u', nil, true, nil, false},
    MatchedCount = {'y', nil, true, nil, false},
    PartNumber = {'s', nil, true, nil, false},
    BOM = {'s', nil, true, nil, false},
    SystemId = {'y', nil, true, nil, false},
    SpeedRange = {'ay', {}, true, nil, false},
    PowerRange = {'aq', {}, true, nil, false},
    FanDiameterMm = {'q', {'CONST'}, true, nil, false}
}, {}, {})

return FanType
