-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Fan = {}

---@class Fan.DeviceName
---@field DeviceName string
local TDeviceName = {}
TDeviceName.__index = TDeviceName
TDeviceName.group = {}

local function TDeviceName_from_obj(obj) return setmetatable(obj, TDeviceName) end

function TDeviceName.new(DeviceName)
    return TDeviceName_from_obj({DeviceName = DeviceName})
end
---@param obj Fan.DeviceName
function TDeviceName:init_from_obj(obj) self.DeviceName = obj.DeviceName end

function TDeviceName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceName.group)
end

TDeviceName.from_obj = TDeviceName_from_obj

TDeviceName.proto_property = {'DeviceName'}

TDeviceName.default = {''}

TDeviceName.struct = {{name = 'DeviceName', is_array = false, struct = nil}}

function TDeviceName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceName', self.DeviceName, "string", true,
                      errs, need_convert)

    TDeviceName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceName.proto_property, errs,
                                 need_convert)
    return self
end

function TDeviceName:unpack(_) return self.DeviceName end

Fan.DeviceName = TDeviceName

---@class Fan.FunctionDesc
---@field FunctionDesc string
local TFunctionDesc = {}
TFunctionDesc.__index = TFunctionDesc
TFunctionDesc.group = {}

local function TFunctionDesc_from_obj(obj)
    return setmetatable(obj, TFunctionDesc)
end

function TFunctionDesc.new(FunctionDesc)
    return TFunctionDesc_from_obj({FunctionDesc = FunctionDesc})
end
---@param obj Fan.FunctionDesc
function TFunctionDesc:init_from_obj(obj) self.FunctionDesc = obj.FunctionDesc end

function TFunctionDesc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunctionDesc.group)
end

TFunctionDesc.from_obj = TFunctionDesc_from_obj

TFunctionDesc.proto_property = {'FunctionDesc'}

TFunctionDesc.default = {''}

TFunctionDesc.struct = {{name = 'FunctionDesc', is_array = false, struct = nil}}

function TFunctionDesc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FunctionDesc', self.FunctionDesc, "string",
                      true, errs, need_convert)

    TFunctionDesc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunctionDesc.proto_property, errs,
                                 need_convert)
    return self
end

function TFunctionDesc:unpack(_) return self.FunctionDesc end

Fan.FunctionDesc = TFunctionDesc

---@class Fan.SpeedStable
---@field SpeedStable boolean
local TSpeedStable = {}
TSpeedStable.__index = TSpeedStable
TSpeedStable.group = {}

local function TSpeedStable_from_obj(obj) return setmetatable(obj, TSpeedStable) end

function TSpeedStable.new(SpeedStable)
    return TSpeedStable_from_obj({SpeedStable = SpeedStable})
end
---@param obj Fan.SpeedStable
function TSpeedStable:init_from_obj(obj) self.SpeedStable = obj.SpeedStable end

function TSpeedStable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedStable.group)
end

TSpeedStable.from_obj = TSpeedStable_from_obj

TSpeedStable.proto_property = {'SpeedStable'}

TSpeedStable.default = {false}

TSpeedStable.struct = {{name = 'SpeedStable', is_array = false, struct = nil}}

function TSpeedStable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpeedStable', self.SpeedStable, "bool", true,
                      errs, need_convert)

    TSpeedStable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedStable.proto_property, errs,
                                 need_convert)
    return self
end

function TSpeedStable:unpack(_) return self.SpeedStable end

Fan.SpeedStable = TSpeedStable

---@class Fan.Position
---@field Position string
local TPosition = {}
TPosition.__index = TPosition
TPosition.group = {}

local function TPosition_from_obj(obj) return setmetatable(obj, TPosition) end

function TPosition.new(Position) return
    TPosition_from_obj({Position = Position}) end
---@param obj Fan.Position
function TPosition:init_from_obj(obj) self.Position = obj.Position end

function TPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPosition.group)
end

TPosition.from_obj = TPosition_from_obj

TPosition.proto_property = {'Position'}

TPosition.default = {''}

TPosition.struct = {{name = 'Position', is_array = false, struct = nil}}

function TPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Position', self.Position, "string", true, errs,
                      need_convert)

    TPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPosition.proto_property, errs,
                                 need_convert)
    return self
end

function TPosition:unpack(_) return self.Position end

Fan.Position = TPosition

---@class Fan.IsTwins
---@field IsTwins boolean
local TIsTwins = {}
TIsTwins.__index = TIsTwins
TIsTwins.group = {}

local function TIsTwins_from_obj(obj) return setmetatable(obj, TIsTwins) end

function TIsTwins.new(IsTwins) return TIsTwins_from_obj({IsTwins = IsTwins}) end
---@param obj Fan.IsTwins
function TIsTwins:init_from_obj(obj) self.IsTwins = obj.IsTwins end

function TIsTwins:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsTwins.group)
end

TIsTwins.from_obj = TIsTwins_from_obj

TIsTwins.proto_property = {'IsTwins'}

TIsTwins.default = {false}

TIsTwins.struct = {{name = 'IsTwins', is_array = false, struct = nil}}

function TIsTwins:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsTwins', self.IsTwins, "bool", true, errs,
                      need_convert)

    TIsTwins:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsTwins.proto_property, errs,
                                 need_convert)
    return self
end

function TIsTwins:unpack(_) return self.IsTwins end

Fan.IsTwins = TIsTwins

---@class Fan.RearMaxSpeed
---@field RearMaxSpeed integer
local TRearMaxSpeed = {}
TRearMaxSpeed.__index = TRearMaxSpeed
TRearMaxSpeed.group = {}

local function TRearMaxSpeed_from_obj(obj)
    return setmetatable(obj, TRearMaxSpeed)
end

function TRearMaxSpeed.new(RearMaxSpeed)
    return TRearMaxSpeed_from_obj({RearMaxSpeed = RearMaxSpeed})
end
---@param obj Fan.RearMaxSpeed
function TRearMaxSpeed:init_from_obj(obj) self.RearMaxSpeed = obj.RearMaxSpeed end

function TRearMaxSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearMaxSpeed.group)
end

TRearMaxSpeed.from_obj = TRearMaxSpeed_from_obj

TRearMaxSpeed.proto_property = {'RearMaxSpeed'}

TRearMaxSpeed.default = {0}

TRearMaxSpeed.struct = {{name = 'RearMaxSpeed', is_array = false, struct = nil}}

function TRearMaxSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearMaxSpeed', self.RearMaxSpeed, "uint32",
                      true, errs, need_convert)

    TRearMaxSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearMaxSpeed.proto_property, errs,
                                 need_convert)
    return self
end

function TRearMaxSpeed:unpack(_) return self.RearMaxSpeed end

Fan.RearMaxSpeed = TRearMaxSpeed

---@class Fan.FrontMaxSpeed
---@field FrontMaxSpeed integer
local TFrontMaxSpeed = {}
TFrontMaxSpeed.__index = TFrontMaxSpeed
TFrontMaxSpeed.group = {}

local function TFrontMaxSpeed_from_obj(obj)
    return setmetatable(obj, TFrontMaxSpeed)
end

function TFrontMaxSpeed.new(FrontMaxSpeed)
    return TFrontMaxSpeed_from_obj({FrontMaxSpeed = FrontMaxSpeed})
end
---@param obj Fan.FrontMaxSpeed
function TFrontMaxSpeed:init_from_obj(obj) self.FrontMaxSpeed =
    obj.FrontMaxSpeed end

function TFrontMaxSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontMaxSpeed.group)
end

TFrontMaxSpeed.from_obj = TFrontMaxSpeed_from_obj

TFrontMaxSpeed.proto_property = {'FrontMaxSpeed'}

TFrontMaxSpeed.default = {0}

TFrontMaxSpeed.struct = {
    {name = 'FrontMaxSpeed', is_array = false, struct = nil}
}

function TFrontMaxSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontMaxSpeed', self.FrontMaxSpeed, "uint32",
                      true, errs, need_convert)

    TFrontMaxSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontMaxSpeed.proto_property, errs,
                                 need_convert)
    return self
end

function TFrontMaxSpeed:unpack(_) return self.FrontMaxSpeed end

Fan.FrontMaxSpeed = TFrontMaxSpeed

---@class Fan.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj) return setmetatable(obj, TPartNumber) end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj Fan.PartNumber
function TPartNumber:init_from_obj(obj) self.PartNumber = obj.PartNumber end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, "string", true,
                      errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs,
                                 need_convert)
    return self
end

function TPartNumber:unpack(_) return self.PartNumber end

Fan.PartNumber = TPartNumber

---@class Fan.IdentifySpeedLevel
---@field IdentifySpeedLevel integer
local TIdentifySpeedLevel = {}
TIdentifySpeedLevel.__index = TIdentifySpeedLevel
TIdentifySpeedLevel.group = {}

local function TIdentifySpeedLevel_from_obj(obj)
    return setmetatable(obj, TIdentifySpeedLevel)
end

function TIdentifySpeedLevel.new(IdentifySpeedLevel)
    return TIdentifySpeedLevel_from_obj({
        IdentifySpeedLevel = IdentifySpeedLevel
    })
end
---@param obj Fan.IdentifySpeedLevel
function TIdentifySpeedLevel:init_from_obj(obj)
    self.IdentifySpeedLevel = obj.IdentifySpeedLevel
end

function TIdentifySpeedLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIdentifySpeedLevel.group)
end

TIdentifySpeedLevel.from_obj = TIdentifySpeedLevel_from_obj

TIdentifySpeedLevel.proto_property = {'IdentifySpeedLevel'}

TIdentifySpeedLevel.default = {0}

TIdentifySpeedLevel.struct = {
    {name = 'IdentifySpeedLevel', is_array = false, struct = nil}
}

function TIdentifySpeedLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IdentifySpeedLevel', self.IdentifySpeedLevel,
                      "uint8", true, errs, need_convert)

    TIdentifySpeedLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIdentifySpeedLevel.proto_property, errs,
                                 need_convert)
    return self
end

function TIdentifySpeedLevel:unpack(_) return self.IdentifySpeedLevel end

Fan.IdentifySpeedLevel = TIdentifySpeedLevel

---@class Fan.MaxSupportedPWM
---@field MaxSupportedPWM integer
local TMaxSupportedPWM = {}
TMaxSupportedPWM.__index = TMaxSupportedPWM
TMaxSupportedPWM.group = {}

local function TMaxSupportedPWM_from_obj(obj)
    return setmetatable(obj, TMaxSupportedPWM)
end

function TMaxSupportedPWM.new(MaxSupportedPWM)
    return TMaxSupportedPWM_from_obj({MaxSupportedPWM = MaxSupportedPWM})
end
---@param obj Fan.MaxSupportedPWM
function TMaxSupportedPWM:init_from_obj(obj)
    self.MaxSupportedPWM = obj.MaxSupportedPWM
end

function TMaxSupportedPWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxSupportedPWM.group)
end

TMaxSupportedPWM.from_obj = TMaxSupportedPWM_from_obj

TMaxSupportedPWM.proto_property = {'MaxSupportedPWM'}

TMaxSupportedPWM.default = {0}

TMaxSupportedPWM.struct = {
    {name = 'MaxSupportedPWM', is_array = false, struct = nil}
}

function TMaxSupportedPWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxSupportedPWM', self.MaxSupportedPWM,
                      "uint32", true, errs, need_convert)

    TMaxSupportedPWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxSupportedPWM.proto_property, errs,
                                 need_convert)
    return self
end

function TMaxSupportedPWM:unpack(_) return self.MaxSupportedPWM end

Fan.MaxSupportedPWM = TMaxSupportedPWM

---@class Fan.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj) return setmetatable(obj, TSystemId) end

function TSystemId.new(SystemId) return
    TSystemId_from_obj({SystemId = SystemId}) end
---@param obj Fan.SystemId
function TSystemId:init_from_obj(obj) self.SystemId = obj.SystemId end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, "uint8", true, errs,
                      need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs,
                                 need_convert)
    return self
end

function TSystemId:unpack(_) return self.SystemId end

Fan.SystemId = TSystemId

---@class Fan.BOM
---@field BOM string
local TBOM = {}
TBOM.__index = TBOM
TBOM.group = {}

local function TBOM_from_obj(obj) return setmetatable(obj, TBOM) end

function TBOM.new(BOM) return TBOM_from_obj({BOM = BOM}) end
---@param obj Fan.BOM
function TBOM:init_from_obj(obj) self.BOM = obj.BOM end

function TBOM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBOM.group)
end

TBOM.from_obj = TBOM_from_obj

TBOM.proto_property = {'BOM'}

TBOM.default = {''}

TBOM.struct = {{name = 'BOM', is_array = false, struct = nil}}

function TBOM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BOM', self.BOM, "string", true, errs,
                      need_convert)

    TBOM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBOM.proto_property, errs, need_convert)
    return self
end

function TBOM:unpack(_) return self.BOM end

Fan.BOM = TBOM

---@class Fan.FanAlarmLed
---@field FanAlarmLed integer
local TFanAlarmLed = {}
TFanAlarmLed.__index = TFanAlarmLed
TFanAlarmLed.group = {}

local function TFanAlarmLed_from_obj(obj) return setmetatable(obj, TFanAlarmLed) end

function TFanAlarmLed.new(FanAlarmLed)
    return TFanAlarmLed_from_obj({FanAlarmLed = FanAlarmLed})
end
---@param obj Fan.FanAlarmLed
function TFanAlarmLed:init_from_obj(obj) self.FanAlarmLed = obj.FanAlarmLed end

function TFanAlarmLed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanAlarmLed.group)
end

TFanAlarmLed.from_obj = TFanAlarmLed_from_obj

TFanAlarmLed.proto_property = {'FanAlarmLed'}

TFanAlarmLed.default = {0}

TFanAlarmLed.struct = {{name = 'FanAlarmLed', is_array = false, struct = nil}}

function TFanAlarmLed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanAlarmLed', self.FanAlarmLed, "uint8", true,
                      errs, need_convert)

    TFanAlarmLed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanAlarmLed.proto_property, errs,
                                 need_convert)
    return self
end

function TFanAlarmLed:unpack(_) return self.FanAlarmLed end

Fan.FanAlarmLed = TFanAlarmLed

---@class Fan.ExpectedPWM
---@field ExpectedPWM number
local TExpectedPWM = {}
TExpectedPWM.__index = TExpectedPWM
TExpectedPWM.group = {}

local function TExpectedPWM_from_obj(obj) return setmetatable(obj, TExpectedPWM) end

function TExpectedPWM.new(ExpectedPWM)
    return TExpectedPWM_from_obj({ExpectedPWM = ExpectedPWM})
end
---@param obj Fan.ExpectedPWM
function TExpectedPWM:init_from_obj(obj) self.ExpectedPWM = obj.ExpectedPWM end

function TExpectedPWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExpectedPWM.group)
end

TExpectedPWM.from_obj = TExpectedPWM_from_obj

TExpectedPWM.proto_property = {'ExpectedPWM'}

TExpectedPWM.default = {0}

TExpectedPWM.struct = {{name = 'ExpectedPWM', is_array = false, struct = nil}}

function TExpectedPWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExpectedPWM', self.ExpectedPWM, "double",
                      false, errs, need_convert)

    TExpectedPWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExpectedPWM.proto_property, errs,
                                 need_convert)
    return self
end

function TExpectedPWM:unpack(_) return self.ExpectedPWM end

Fan.ExpectedPWM = TExpectedPWM

---@class Fan.PWMPercentage
---@field PWMPercentage integer
local TPWMPercentage = {}
TPWMPercentage.__index = TPWMPercentage
TPWMPercentage.group = {}

local function TPWMPercentage_from_obj(obj)
    return setmetatable(obj, TPWMPercentage)
end

function TPWMPercentage.new(PWMPercentage)
    return TPWMPercentage_from_obj({PWMPercentage = PWMPercentage})
end
---@param obj Fan.PWMPercentage
function TPWMPercentage:init_from_obj(obj) self.PWMPercentage =
    obj.PWMPercentage end

function TPWMPercentage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPWMPercentage.group)
end

TPWMPercentage.from_obj = TPWMPercentage_from_obj

TPWMPercentage.proto_property = {'PWMPercentage'}

TPWMPercentage.default = {0}

TPWMPercentage.struct = {
    {name = 'PWMPercentage', is_array = false, struct = nil}
}

function TPWMPercentage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PWMPercentage', self.PWMPercentage, "uint32",
                      true, errs, need_convert)

    TPWMPercentage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPWMPercentage.proto_property, errs,
                                 need_convert)
    return self
end

function TPWMPercentage:unpack(_) return self.PWMPercentage end

Fan.PWMPercentage = TPWMPercentage

---@class Fan.HardwarePWM
---@field HardwarePWM number
local THardwarePWM = {}
THardwarePWM.__index = THardwarePWM
THardwarePWM.group = {}

local function THardwarePWM_from_obj(obj) return setmetatable(obj, THardwarePWM) end

function THardwarePWM.new(HardwarePWM)
    return THardwarePWM_from_obj({HardwarePWM = HardwarePWM})
end
---@param obj Fan.HardwarePWM
function THardwarePWM:init_from_obj(obj) self.HardwarePWM = obj.HardwarePWM end

function THardwarePWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THardwarePWM.group)
end

THardwarePWM.from_obj = THardwarePWM_from_obj

THardwarePWM.proto_property = {'HardwarePWM'}

THardwarePWM.default = {0}

THardwarePWM.struct = {{name = 'HardwarePWM', is_array = false, struct = nil}}

function THardwarePWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HardwarePWM', self.HardwarePWM, "double",
                      false, errs, need_convert)

    THardwarePWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THardwarePWM.proto_property, errs,
                                 need_convert)
    return self
end

function THardwarePWM:unpack(_) return self.HardwarePWM end

Fan.HardwarePWM = THardwarePWM

---@class Fan.RearRPM
---@field RearRPM integer
local TRearRPM = {}
TRearRPM.__index = TRearRPM
TRearRPM.group = {}

local function TRearRPM_from_obj(obj) return setmetatable(obj, TRearRPM) end

function TRearRPM.new(RearRPM) return TRearRPM_from_obj({RearRPM = RearRPM}) end
---@param obj Fan.RearRPM
function TRearRPM:init_from_obj(obj) self.RearRPM = obj.RearRPM end

function TRearRPM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearRPM.group)
end

TRearRPM.from_obj = TRearRPM_from_obj

TRearRPM.proto_property = {'RearRPM'}

TRearRPM.default = {0}

TRearRPM.struct = {{name = 'RearRPM', is_array = false, struct = nil}}

function TRearRPM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearRPM', self.RearRPM, "uint16", true, errs,
                      need_convert)

    TRearRPM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearRPM.proto_property, errs,
                                 need_convert)
    return self
end

function TRearRPM:unpack(_) return self.RearRPM end

Fan.RearRPM = TRearRPM

---@class Fan.FrontRPM
---@field FrontRPM integer
local TFrontRPM = {}
TFrontRPM.__index = TFrontRPM
TFrontRPM.group = {}

local function TFrontRPM_from_obj(obj) return setmetatable(obj, TFrontRPM) end

function TFrontRPM.new(FrontRPM) return
    TFrontRPM_from_obj({FrontRPM = FrontRPM}) end
---@param obj Fan.FrontRPM
function TFrontRPM:init_from_obj(obj) self.FrontRPM = obj.FrontRPM end

function TFrontRPM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontRPM.group)
end

TFrontRPM.from_obj = TFrontRPM_from_obj

TFrontRPM.proto_property = {'FrontRPM'}

TFrontRPM.default = {0}

TFrontRPM.struct = {{name = 'FrontRPM', is_array = false, struct = nil}}

function TFrontRPM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontRPM', self.FrontRPM, "uint16", true, errs,
                      need_convert)

    TFrontRPM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontRPM.proto_property, errs,
                                 need_convert)
    return self
end

function TFrontRPM:unpack(_) return self.FrontRPM end

Fan.FrontRPM = TFrontRPM

---@class Fan.RearStatus
---@field RearStatus integer
local TRearStatus = {}
TRearStatus.__index = TRearStatus
TRearStatus.group = {}

local function TRearStatus_from_obj(obj) return setmetatable(obj, TRearStatus) end

function TRearStatus.new(RearStatus)
    return TRearStatus_from_obj({RearStatus = RearStatus})
end
---@param obj Fan.RearStatus
function TRearStatus:init_from_obj(obj) self.RearStatus = obj.RearStatus end

function TRearStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearStatus.group)
end

TRearStatus.from_obj = TRearStatus_from_obj

TRearStatus.proto_property = {'RearStatus'}

TRearStatus.default = {0}

TRearStatus.struct = {{name = 'RearStatus', is_array = false, struct = nil}}

function TRearStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearStatus', self.RearStatus, "uint8", true,
                      errs, need_convert)

    TRearStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearStatus.proto_property, errs,
                                 need_convert)
    return self
end

function TRearStatus:unpack(_) return self.RearStatus end

Fan.RearStatus = TRearStatus

---@class Fan.FrontStatus
---@field FrontStatus integer
local TFrontStatus = {}
TFrontStatus.__index = TFrontStatus
TFrontStatus.group = {}

local function TFrontStatus_from_obj(obj) return setmetatable(obj, TFrontStatus) end

function TFrontStatus.new(FrontStatus)
    return TFrontStatus_from_obj({FrontStatus = FrontStatus})
end
---@param obj Fan.FrontStatus
function TFrontStatus:init_from_obj(obj) self.FrontStatus = obj.FrontStatus end

function TFrontStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontStatus.group)
end

TFrontStatus.from_obj = TFrontStatus_from_obj

TFrontStatus.proto_property = {'FrontStatus'}

TFrontStatus.default = {0}

TFrontStatus.struct = {{name = 'FrontStatus', is_array = false, struct = nil}}

function TFrontStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontStatus', self.FrontStatus, "uint8", true,
                      errs, need_convert)

    TFrontStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontStatus.proto_property, errs,
                                 need_convert)
    return self
end

function TFrontStatus:unpack(_) return self.FrontStatus end

Fan.FrontStatus = TFrontStatus

---@class Fan.RearSpeed
---@field RearSpeed integer
local TRearSpeed = {}
TRearSpeed.__index = TRearSpeed
TRearSpeed.group = {}

local function TRearSpeed_from_obj(obj) return setmetatable(obj, TRearSpeed) end

function TRearSpeed.new(RearSpeed)
    return TRearSpeed_from_obj({RearSpeed = RearSpeed})
end
---@param obj Fan.RearSpeed
function TRearSpeed:init_from_obj(obj) self.RearSpeed = obj.RearSpeed end

function TRearSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearSpeed.group)
end

TRearSpeed.from_obj = TRearSpeed_from_obj

TRearSpeed.proto_property = {'RearSpeed'}

TRearSpeed.default = {0}

TRearSpeed.struct = {{name = 'RearSpeed', is_array = false, struct = nil}}

function TRearSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearSpeed', self.RearSpeed, "uint16", false,
                      errs, need_convert)

    TRearSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearSpeed.proto_property, errs,
                                 need_convert)
    return self
end

function TRearSpeed:unpack(_) return self.RearSpeed end

Fan.RearSpeed = TRearSpeed

---@class Fan.FrontSpeed
---@field FrontSpeed integer
local TFrontSpeed = {}
TFrontSpeed.__index = TFrontSpeed
TFrontSpeed.group = {}

local function TFrontSpeed_from_obj(obj) return setmetatable(obj, TFrontSpeed) end

function TFrontSpeed.new(FrontSpeed)
    return TFrontSpeed_from_obj({FrontSpeed = FrontSpeed})
end
---@param obj Fan.FrontSpeed
function TFrontSpeed:init_from_obj(obj) self.FrontSpeed = obj.FrontSpeed end

function TFrontSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontSpeed.group)
end

TFrontSpeed.from_obj = TFrontSpeed_from_obj

TFrontSpeed.proto_property = {'FrontSpeed'}

TFrontSpeed.default = {0}

TFrontSpeed.struct = {{name = 'FrontSpeed', is_array = false, struct = nil}}

function TFrontSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontSpeed', self.FrontSpeed, "uint16", false,
                      errs, need_convert)

    TFrontSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontSpeed.proto_property, errs,
                                 need_convert)
    return self
end

function TFrontSpeed:unpack(_) return self.FrontSpeed end

Fan.FrontSpeed = TFrontSpeed

---@class Fan.RearPresence
---@field RearPresence integer
local TRearPresence = {}
TRearPresence.__index = TRearPresence
TRearPresence.group = {}

local function TRearPresence_from_obj(obj)
    return setmetatable(obj, TRearPresence)
end

function TRearPresence.new(RearPresence)
    return TRearPresence_from_obj({RearPresence = RearPresence})
end
---@param obj Fan.RearPresence
function TRearPresence:init_from_obj(obj) self.RearPresence = obj.RearPresence end

function TRearPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearPresence.group)
end

TRearPresence.from_obj = TRearPresence_from_obj

TRearPresence.proto_property = {'RearPresence'}

TRearPresence.default = {0}

TRearPresence.struct = {{name = 'RearPresence', is_array = false, struct = nil}}

function TRearPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearPresence', self.RearPresence, "uint8",
                      false, errs, need_convert)

    TRearPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearPresence.proto_property, errs,
                                 need_convert)
    return self
end

function TRearPresence:unpack(_) return self.RearPresence end

Fan.RearPresence = TRearPresence

---@class Fan.FrontPresence
---@field FrontPresence integer
local TFrontPresence = {}
TFrontPresence.__index = TFrontPresence
TFrontPresence.group = {}

local function TFrontPresence_from_obj(obj)
    return setmetatable(obj, TFrontPresence)
end

function TFrontPresence.new(FrontPresence)
    return TFrontPresence_from_obj({FrontPresence = FrontPresence})
end
---@param obj Fan.FrontPresence
function TFrontPresence:init_from_obj(obj) self.FrontPresence =
    obj.FrontPresence end

function TFrontPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontPresence.group)
end

TFrontPresence.from_obj = TFrontPresence_from_obj

TFrontPresence.proto_property = {'FrontPresence'}

TFrontPresence.default = {0}

TFrontPresence.struct = {
    {name = 'FrontPresence', is_array = false, struct = nil}
}

function TFrontPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontPresence', self.FrontPresence, "uint8",
                      false, errs, need_convert)

    TFrontPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontPresence.proto_property, errs,
                                 need_convert)
    return self
end

function TFrontPresence:unpack(_) return self.FrontPresence end

Fan.FrontPresence = TFrontPresence

---@class Fan.FanEntity
---@field FanEntity string
local TFanEntity = {}
TFanEntity.__index = TFanEntity
TFanEntity.group = {}

local function TFanEntity_from_obj(obj) return setmetatable(obj, TFanEntity) end

function TFanEntity.new(FanEntity)
    return TFanEntity_from_obj({FanEntity = FanEntity})
end
---@param obj Fan.FanEntity
function TFanEntity:init_from_obj(obj) self.FanEntity = obj.FanEntity end

function TFanEntity:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanEntity.group)
end

TFanEntity.from_obj = TFanEntity_from_obj

TFanEntity.proto_property = {'FanEntity'}

TFanEntity.default = {''}

TFanEntity.struct = {{name = 'FanEntity', is_array = false, struct = nil}}

function TFanEntity:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanEntity', self.FanEntity, "string", true,
                      errs, need_convert)

    TFanEntity:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanEntity.proto_property, errs,
                                 need_convert)
    return self
end

function TFanEntity:unpack(_) return self.FanEntity end

Fan.FanEntity = TFanEntity

---@class Fan.FanHealth
---@field FanHealth integer
local TFanHealth = {}
TFanHealth.__index = TFanHealth
TFanHealth.group = {}

local function TFanHealth_from_obj(obj) return setmetatable(obj, TFanHealth) end

function TFanHealth.new(FanHealth)
    return TFanHealth_from_obj({FanHealth = FanHealth})
end
---@param obj Fan.FanHealth
function TFanHealth:init_from_obj(obj) self.FanHealth = obj.FanHealth end

function TFanHealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanHealth.group)
end

TFanHealth.from_obj = TFanHealth_from_obj

TFanHealth.proto_property = {'FanHealth'}

TFanHealth.default = {0}

TFanHealth.struct = {{name = 'FanHealth', is_array = false, struct = nil}}

function TFanHealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanHealth', self.FanHealth, "uint8", true,
                      errs, need_convert)

    TFanHealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanHealth.proto_property, errs,
                                 need_convert)
    return self
end

function TFanHealth:unpack(_) return self.FanHealth end

Fan.FanHealth = TFanHealth

---@class Fan.Coefficient
---@field Coefficient integer
local TCoefficient = {}
TCoefficient.__index = TCoefficient
TCoefficient.group = {}

local function TCoefficient_from_obj(obj) return setmetatable(obj, TCoefficient) end

function TCoefficient.new(Coefficient)
    return TCoefficient_from_obj({Coefficient = Coefficient})
end
---@param obj Fan.Coefficient
function TCoefficient:init_from_obj(obj) self.Coefficient = obj.Coefficient end

function TCoefficient:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCoefficient.group)
end

TCoefficient.from_obj = TCoefficient_from_obj

TCoefficient.proto_property = {'Coefficient'}

TCoefficient.default = {0}

TCoefficient.struct = {{name = 'Coefficient', is_array = false, struct = nil}}

function TCoefficient:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Coefficient', self.Coefficient, "uint8", true,
                      errs, need_convert)

    TCoefficient:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCoefficient.proto_property, errs,
                                 need_convert)
    return self
end

function TCoefficient:unpack(_) return self.Coefficient end

Fan.Coefficient = TCoefficient

---@class Fan.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj) return setmetatable(obj, TModel) end

function TModel.new(Model) return TModel_from_obj({Model = Model}) end
---@param obj Fan.Model
function TModel:init_from_obj(obj) self.Model = obj.Model end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, "string", true, errs,
                      need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_) return self.Model end

Fan.Model = TModel

---@class Fan.Type
---@field Type integer
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj) return setmetatable(obj, TType) end

function TType.new(Type) return TType_from_obj({Type = Type}) end
---@param obj Fan.Type
function TType:init_from_obj(obj) self.Type = obj.Type end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {0}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, "uint8", true, errs,
                      need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_) return self.Type end

Fan.Type = TType

---@class Fan.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj) return setmetatable(obj, TSlot) end

function TSlot.new(Slot) return TSlot_from_obj({Slot = Slot}) end
---@param obj Fan.Slot
function TSlot:init_from_obj(obj) self.Slot = obj.Slot end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, "uint8", true, errs,
                      need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_) return self.Slot end

Fan.Slot = TSlot

---@class Fan.FanId
---@field FanId integer
local TFanId = {}
TFanId.__index = TFanId
TFanId.group = {}

local function TFanId_from_obj(obj) return setmetatable(obj, TFanId) end

function TFanId.new(FanId) return TFanId_from_obj({FanId = FanId}) end
---@param obj Fan.FanId
function TFanId:init_from_obj(obj) self.FanId = obj.FanId end

function TFanId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanId.group)
end

TFanId.from_obj = TFanId_from_obj

TFanId.proto_property = {'FanId'}

TFanId.default = {0}

TFanId.struct = {{name = 'FanId', is_array = false, struct = nil}}

function TFanId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanId', self.FanId, "uint16", true, errs,
                      need_convert)

    TFanId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanId.proto_property, errs, need_convert)
    return self
end

function TFanId:unpack(_) return self.FanId end

Fan.FanId = TFanId

---@class Fan.SetFanPWMRsp
---@field Result integer
local TSetFanPWMRsp = {}
TSetFanPWMRsp.__index = TSetFanPWMRsp
TSetFanPWMRsp.group = {}

local function TSetFanPWMRsp_from_obj(obj)
    return setmetatable(obj, TSetFanPWMRsp)
end

function TSetFanPWMRsp.new(Result)
    return TSetFanPWMRsp_from_obj({Result = Result})
end
---@param obj Fan.SetFanPWMRsp
function TSetFanPWMRsp:init_from_obj(obj) self.Result = obj.Result end

function TSetFanPWMRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFanPWMRsp.group)
end

TSetFanPWMRsp.from_obj = TSetFanPWMRsp_from_obj

TSetFanPWMRsp.proto_property = {'Result'}

TSetFanPWMRsp.default = {0}

TSetFanPWMRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetFanPWMRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "uint8", false, errs,
                      need_convert)

    TSetFanPWMRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFanPWMRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TSetFanPWMRsp:unpack(_) return self.Result end

Fan.SetFanPWMRsp = TSetFanPWMRsp

---@class Fan.SetFanPWMReq
---@field PWM number
local TSetFanPWMReq = {}
TSetFanPWMReq.__index = TSetFanPWMReq
TSetFanPWMReq.group = {}

local function TSetFanPWMReq_from_obj(obj)
    return setmetatable(obj, TSetFanPWMReq)
end

function TSetFanPWMReq.new(PWM) return TSetFanPWMReq_from_obj({PWM = PWM}) end
---@param obj Fan.SetFanPWMReq
function TSetFanPWMReq:init_from_obj(obj) self.PWM = obj.PWM end

function TSetFanPWMReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFanPWMReq.group)
end

TSetFanPWMReq.from_obj = TSetFanPWMReq_from_obj

TSetFanPWMReq.proto_property = {'PWM'}

TSetFanPWMReq.default = {0}

TSetFanPWMReq.struct = {{name = 'PWM', is_array = false, struct = nil}}

function TSetFanPWMReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PWM', self.PWM, "double", false, errs,
                      need_convert)

    TSetFanPWMReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFanPWMReq.proto_property, errs,
                                 need_convert)
    return self
end

function TSetFanPWMReq:unpack(_) return self.PWM end

Fan.SetFanPWMReq = TSetFanPWMReq

Fan.interface = mdb.register_interface('bmc.kepler.Systems.Fan', {
    FanId = {'q', nil, true, nil, false},
    Slot = {'y', nil, true, nil, false},
    Type = {'y', nil, true, nil, false},
    Model = {'s', nil, true, nil, false},
    Coefficient = {'y', nil, true, nil, false},
    FanHealth = {'y', nil, true, nil, false},
    FanEntity = {'s', nil, true, nil, false},
    FrontPresence = {'y', nil, false, nil, false},
    RearPresence = {'y', nil, false, nil, false},
    FrontSpeed = {'q', {'VOLATILE', 'EMIT_CHANGE'}, false, nil, false},
    RearSpeed = {'q', {'VOLATILE', 'EMIT_CHANGE'}, false, nil, false},
    FrontStatus = {'y', nil, true, nil, false},
    RearStatus = {'y', nil, true, nil, false},
    FrontRPM = {'q', nil, true, nil, false},
    RearRPM = {'q', nil, true, nil, false},
    HardwarePWM = {'d', nil, false, nil, false},
    PWMPercentage = {'u', nil, true, nil, false},
    ExpectedPWM = {'d', nil, false, nil, false},
    FanAlarmLed = {'y', nil, true, nil, false},
    BOM = {'s', nil, true, nil, false},
    SystemId = {'y', nil, true, nil, false},
    MaxSupportedPWM = {'u', nil, true, nil, false},
    IdentifySpeedLevel = {'y', nil, true, nil, false},
    PartNumber = {'s', nil, true, nil, false},
    FrontMaxSpeed = {'u', nil, true, nil, false},
    RearMaxSpeed = {'u', nil, true, nil, false},
    IsTwins = {'b', nil, true, nil, false},
    Position = {'s', nil, true, nil, false},
    SpeedStable = {'b', nil, true, nil, false},
    FunctionDesc = {'s', nil, true, nil, false},
    DeviceName = {'s', nil, true, nil, false}
}, {SetFanPWM = {'a{ss}d', 'y', TSetFanPWMReq, TSetFanPWMRsp}}, {})

return Fan
