-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DiskCoolingConfig = {}

---@class DiskCoolingConfig.SysAllSSDsMaxTemperature
---@field SysAllSSDsMaxTemperature number
local TSysAllSSDsMaxTemperature = {}
TSysAllSSDsMaxTemperature.__index = TSysAllSSDsMaxTemperature
TSysAllSSDsMaxTemperature.group = {}

local function TSysAllSSDsMaxTemperature_from_obj(obj)
    return setmetatable(obj, TSysAllSSDsMaxTemperature)
end

function TSysAllSSDsMaxTemperature.new(SysAllSSDsMaxTemperature)
    return TSysAllSSDsMaxTemperature_from_obj({
        SysAllSSDsMaxTemperature = SysAllSSDsMaxTemperature or 32768
    })
end
---@param obj DiskCoolingConfig.SysAllSSDsMaxTemperature
function TSysAllSSDsMaxTemperature:init_from_obj(obj)
    self.SysAllSSDsMaxTemperature = obj.SysAllSSDsMaxTemperature or 32768
end

function TSysAllSSDsMaxTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSysAllSSDsMaxTemperature.group)
end

TSysAllSSDsMaxTemperature.from_obj = TSysAllSSDsMaxTemperature_from_obj

TSysAllSSDsMaxTemperature.proto_property = {'SysAllSSDsMaxTemperature'}

TSysAllSSDsMaxTemperature.default = {0}

TSysAllSSDsMaxTemperature.struct = {
    {name = 'SysAllSSDsMaxTemperature', is_array = false, struct = nil}
}

function TSysAllSSDsMaxTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SysAllSSDsMaxTemperature',
                      self.SysAllSSDsMaxTemperature, "double", true, errs,
                      need_convert)

    TSysAllSSDsMaxTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSysAllSSDsMaxTemperature.proto_property,
                                 errs, need_convert)
    return self
end

function TSysAllSSDsMaxTemperature:unpack(_) return
    self.SysAllSSDsMaxTemperature end

DiskCoolingConfig.SysAllSSDsMaxTemperature = TSysAllSSDsMaxTemperature

---@class DiskCoolingConfig.SysM2sMaxTemperature
---@field SysM2sMaxTemperature number
local TSysM2sMaxTemperature = {}
TSysM2sMaxTemperature.__index = TSysM2sMaxTemperature
TSysM2sMaxTemperature.group = {}

local function TSysM2sMaxTemperature_from_obj(obj)
    return setmetatable(obj, TSysM2sMaxTemperature)
end

function TSysM2sMaxTemperature.new(SysM2sMaxTemperature)
    return TSysM2sMaxTemperature_from_obj({
        SysM2sMaxTemperature = SysM2sMaxTemperature or 32768
    })
end
---@param obj DiskCoolingConfig.SysM2sMaxTemperature
function TSysM2sMaxTemperature:init_from_obj(obj)
    self.SysM2sMaxTemperature = obj.SysM2sMaxTemperature or 32768
end

function TSysM2sMaxTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSysM2sMaxTemperature.group)
end

TSysM2sMaxTemperature.from_obj = TSysM2sMaxTemperature_from_obj

TSysM2sMaxTemperature.proto_property = {'SysM2sMaxTemperature'}

TSysM2sMaxTemperature.default = {0}

TSysM2sMaxTemperature.struct = {
    {name = 'SysM2sMaxTemperature', is_array = false, struct = nil}
}

function TSysM2sMaxTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SysM2sMaxTemperature',
                      self.SysM2sMaxTemperature, "double", true, errs,
                      need_convert)

    TSysM2sMaxTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSysM2sMaxTemperature.proto_property,
                                 errs, need_convert)
    return self
end

function TSysM2sMaxTemperature:unpack(_) return self.SysM2sMaxTemperature end

DiskCoolingConfig.SysM2sMaxTemperature = TSysM2sMaxTemperature

---@class DiskCoolingConfig.SysSSDsMaxTemperature
---@field SysSSDsMaxTemperature number
local TSysSSDsMaxTemperature = {}
TSysSSDsMaxTemperature.__index = TSysSSDsMaxTemperature
TSysSSDsMaxTemperature.group = {}

local function TSysSSDsMaxTemperature_from_obj(obj)
    return setmetatable(obj, TSysSSDsMaxTemperature)
end

function TSysSSDsMaxTemperature.new(SysSSDsMaxTemperature)
    return TSysSSDsMaxTemperature_from_obj({
        SysSSDsMaxTemperature = SysSSDsMaxTemperature or 32768
    })
end
---@param obj DiskCoolingConfig.SysSSDsMaxTemperature
function TSysSSDsMaxTemperature:init_from_obj(obj)
    self.SysSSDsMaxTemperature = obj.SysSSDsMaxTemperature or 32768
end

function TSysSSDsMaxTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSysSSDsMaxTemperature.group)
end

TSysSSDsMaxTemperature.from_obj = TSysSSDsMaxTemperature_from_obj

TSysSSDsMaxTemperature.proto_property = {'SysSSDsMaxTemperature'}

TSysSSDsMaxTemperature.default = {0}

TSysSSDsMaxTemperature.struct = {
    {name = 'SysSSDsMaxTemperature', is_array = false, struct = nil}
}

function TSysSSDsMaxTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SysSSDsMaxTemperature',
                      self.SysSSDsMaxTemperature, "double", true, errs,
                      need_convert)

    TSysSSDsMaxTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSysSSDsMaxTemperature.proto_property,
                                 errs, need_convert)
    return self
end

function TSysSSDsMaxTemperature:unpack(_) return self.SysSSDsMaxTemperature end

DiskCoolingConfig.SysSSDsMaxTemperature = TSysSSDsMaxTemperature

---@class DiskCoolingConfig.SysHDDsMaxTemperature
---@field SysHDDsMaxTemperature number
local TSysHDDsMaxTemperature = {}
TSysHDDsMaxTemperature.__index = TSysHDDsMaxTemperature
TSysHDDsMaxTemperature.group = {}

local function TSysHDDsMaxTemperature_from_obj(obj)
    return setmetatable(obj, TSysHDDsMaxTemperature)
end

function TSysHDDsMaxTemperature.new(SysHDDsMaxTemperature)
    return TSysHDDsMaxTemperature_from_obj({
        SysHDDsMaxTemperature = SysHDDsMaxTemperature or 32768
    })
end
---@param obj DiskCoolingConfig.SysHDDsMaxTemperature
function TSysHDDsMaxTemperature:init_from_obj(obj)
    self.SysHDDsMaxTemperature = obj.SysHDDsMaxTemperature or 32768
end

function TSysHDDsMaxTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSysHDDsMaxTemperature.group)
end

TSysHDDsMaxTemperature.from_obj = TSysHDDsMaxTemperature_from_obj

TSysHDDsMaxTemperature.proto_property = {'SysHDDsMaxTemperature'}

TSysHDDsMaxTemperature.default = {0}

TSysHDDsMaxTemperature.struct = {
    {name = 'SysHDDsMaxTemperature', is_array = false, struct = nil}
}

function TSysHDDsMaxTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SysHDDsMaxTemperature',
                      self.SysHDDsMaxTemperature, "double", true, errs,
                      need_convert)

    TSysHDDsMaxTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSysHDDsMaxTemperature.proto_property,
                                 errs, need_convert)
    return self
end

function TSysHDDsMaxTemperature:unpack(_) return self.SysHDDsMaxTemperature end

DiskCoolingConfig.SysHDDsMaxTemperature = TSysHDDsMaxTemperature

---@class DiskCoolingConfig.DiskRowTemperatureAvailable
---@field DiskRowTemperatureAvailable boolean
local TDiskRowTemperatureAvailable = {}
TDiskRowTemperatureAvailable.__index = TDiskRowTemperatureAvailable
TDiskRowTemperatureAvailable.group = {}

local function TDiskRowTemperatureAvailable_from_obj(obj)
    return setmetatable(obj, TDiskRowTemperatureAvailable)
end

function TDiskRowTemperatureAvailable.new(DiskRowTemperatureAvailable)
    return TDiskRowTemperatureAvailable_from_obj({
        DiskRowTemperatureAvailable = DiskRowTemperatureAvailable or false
    })
end
---@param obj DiskCoolingConfig.DiskRowTemperatureAvailable
function TDiskRowTemperatureAvailable:init_from_obj(obj)
    self.DiskRowTemperatureAvailable = obj.DiskRowTemperatureAvailable or false
end

function TDiskRowTemperatureAvailable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TDiskRowTemperatureAvailable.group)
end

TDiskRowTemperatureAvailable.from_obj = TDiskRowTemperatureAvailable_from_obj

TDiskRowTemperatureAvailable.proto_property = {'DiskRowTemperatureAvailable'}

TDiskRowTemperatureAvailable.default = {false}

TDiskRowTemperatureAvailable.struct = {
    {name = 'DiskRowTemperatureAvailable', is_array = false, struct = nil}
}

function TDiskRowTemperatureAvailable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiskRowTemperatureAvailable',
                      self.DiskRowTemperatureAvailable, "bool", true, errs,
                      need_convert)

    TDiskRowTemperatureAvailable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TDiskRowTemperatureAvailable.proto_property,
                                 errs, need_convert)
    return self
end

function TDiskRowTemperatureAvailable:unpack(_)
    return self.DiskRowTemperatureAvailable
end

DiskCoolingConfig.DiskRowTemperatureAvailable = TDiskRowTemperatureAvailable

DiskCoolingConfig.interface = mdb.register_interface(
                                  'bmc.kepler.Systems.DiskCoolingConfig', {
        DiskRowTemperatureAvailable = {'b', nil, true, false, false},
        SysHDDsMaxTemperature = {'d', nil, true, 32768, false},
        SysSSDsMaxTemperature = {'d', nil, true, 32768, false},
        SysM2sMaxTemperature = {'d', nil, true, 32768, false},
        SysAllSSDsMaxTemperature = {'d', nil, true, 32768, false}
    }, {}, {})

return DiskCoolingConfig
