-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CoolingPolicies = {}

---@class CoolingPolicies.GetSpecificPWMRsp
---@field ControlPWM integer
local TGetSpecificPWMRsp = {}
TGetSpecificPWMRsp.__index = TGetSpecificPWMRsp
TGetSpecificPWMRsp.group = {}

local function TGetSpecificPWMRsp_from_obj(obj)
    return setmetatable(obj, TGetSpecificPWMRsp)
end

function TGetSpecificPWMRsp.new(ControlPWM)
    return TGetSpecificPWMRsp_from_obj({ControlPWM = ControlPWM})
end
---@param obj CoolingPolicies.GetSpecificPWMRsp
function TGetSpecificPWMRsp:init_from_obj(obj) self.ControlPWM = obj.ControlPWM end

function TGetSpecificPWMRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSpecificPWMRsp.group)
end

TGetSpecificPWMRsp.from_obj = TGetSpecificPWMRsp_from_obj

TGetSpecificPWMRsp.proto_property = {'ControlPWM'}

TGetSpecificPWMRsp.default = {0}

TGetSpecificPWMRsp.struct = {
    {name = 'ControlPWM', is_array = false, struct = nil}
}

function TGetSpecificPWMRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ControlPWM', self.ControlPWM, "uint8", false,
                      errs, need_convert)

    TGetSpecificPWMRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSpecificPWMRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TGetSpecificPWMRsp:unpack(_) return self.ControlPWM end

CoolingPolicies.GetSpecificPWMRsp = TGetSpecificPWMRsp

---@class CoolingPolicies.GetSpecificPWMReq
---@field Medium string
---@field PolicyType integer
---@field SmartCoolingMode string
---@field Temperature integer
local TGetSpecificPWMReq = {}
TGetSpecificPWMReq.__index = TGetSpecificPWMReq
TGetSpecificPWMReq.group = {}

local function TGetSpecificPWMReq_from_obj(obj)
    return setmetatable(obj, TGetSpecificPWMReq)
end

function TGetSpecificPWMReq.new(Medium, PolicyType, SmartCoolingMode,
                                Temperature)
    return TGetSpecificPWMReq_from_obj({
        Medium = Medium,
        PolicyType = PolicyType,
        SmartCoolingMode = SmartCoolingMode,
        Temperature = Temperature
    })
end
---@param obj CoolingPolicies.GetSpecificPWMReq
function TGetSpecificPWMReq:init_from_obj(obj)
    self.Medium = obj.Medium
    self.PolicyType = obj.PolicyType
    self.SmartCoolingMode = obj.SmartCoolingMode
    self.Temperature = obj.Temperature
end

function TGetSpecificPWMReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSpecificPWMReq.group)
end

TGetSpecificPWMReq.from_obj = TGetSpecificPWMReq_from_obj

TGetSpecificPWMReq.proto_property = {
    'Medium', 'PolicyType', 'SmartCoolingMode', 'Temperature'
}

TGetSpecificPWMReq.default = {'', 0, '', 0}

TGetSpecificPWMReq.struct = {
    {name = 'Medium', is_array = false, struct = nil},
    {name = 'PolicyType', is_array = false, struct = nil},
    {name = 'SmartCoolingMode', is_array = false, struct = nil},
    {name = 'Temperature', is_array = false, struct = nil}
}

function TGetSpecificPWMReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Medium', self.Medium, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'PolicyType', self.PolicyType, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'SmartCoolingMode', self.SmartCoolingMode,
                      "string", false, errs, need_convert)
    validate.Optional(prefix .. 'Temperature', self.Temperature, "int16", false,
                      errs, need_convert)

    if self.Medium ~= nil then
        validate.Enum(prefix .. 'Medium', self.Medium, '', {"Air", "Liquid"},
                      errs, need_convert)
    end
    if self.PolicyType ~= nil then
        validate.Enum(prefix .. 'PolicyType', self.PolicyType, '', {1, 2}, errs,
                      need_convert)
    end
    if self.SmartCoolingMode ~= nil then
        validate.Enum(prefix .. 'SmartCoolingMode', self.SmartCoolingMode, '',
                      {
            "EnergySaving", "LowNoise", "HighPerformance", "Custom",
            "LiquidCooling"
        }, errs, need_convert)
    end

    TGetSpecificPWMReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSpecificPWMReq.proto_property, errs,
                                 need_convert)
    return self
end

function TGetSpecificPWMReq:unpack(_)
    return self.Medium, self.PolicyType, self.SmartCoolingMode, self.Temperature
end

CoolingPolicies.GetSpecificPWMReq = TGetSpecificPWMReq

CoolingPolicies.interface = mdb.register_interface(
                                'bmc.kepler.Chassis.CoolingPolicies', {}, {
        GetSpecificPWM = {
            'a{ss}sysn', 'y', TGetSpecificPWMReq, TGetSpecificPWMRsp
        }
    }, {})

return CoolingPolicies
