-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CoolingArea = {}

---@class CoolingArea.FanIdxGroup
---@field FanIdxGroup integer[]
local TFanIdxGroup = {}
TFanIdxGroup.__index = TFanIdxGroup
TFanIdxGroup.group = {}

local function TFanIdxGroup_from_obj(obj) return setmetatable(obj, TFanIdxGroup) end

function TFanIdxGroup.new(FanIdxGroup)
    return TFanIdxGroup_from_obj({FanIdxGroup = FanIdxGroup})
end
---@param obj CoolingArea.FanIdxGroup
function TFanIdxGroup:init_from_obj(obj) self.FanIdxGroup = obj.FanIdxGroup end

function TFanIdxGroup:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanIdxGroup.group)
end

TFanIdxGroup.from_obj = TFanIdxGroup_from_obj

TFanIdxGroup.proto_property = {'FanIdxGroup'}

TFanIdxGroup.default = {{}}

TFanIdxGroup.struct = {{name = 'FanIdxGroup', is_array = true, struct = nil}}

function TFanIdxGroup:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FanIdxGroup', self.FanIdxGroup, "uint8",
                           true, errs, need_convert)

    TFanIdxGroup:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanIdxGroup.proto_property, errs,
                                 need_convert)
    return self
end

function TFanIdxGroup:unpack(_) return self.FanIdxGroup end

CoolingArea.FanIdxGroup = TFanIdxGroup

---@class CoolingArea.PolicyIdxGroup
---@field PolicyIdxGroup integer[]
local TPolicyIdxGroup = {}
TPolicyIdxGroup.__index = TPolicyIdxGroup
TPolicyIdxGroup.group = {}

local function TPolicyIdxGroup_from_obj(obj)
    return setmetatable(obj, TPolicyIdxGroup)
end

function TPolicyIdxGroup.new(PolicyIdxGroup)
    return TPolicyIdxGroup_from_obj({PolicyIdxGroup = PolicyIdxGroup})
end
---@param obj CoolingArea.PolicyIdxGroup
function TPolicyIdxGroup:init_from_obj(obj)
    self.PolicyIdxGroup = obj.PolicyIdxGroup
end

function TPolicyIdxGroup:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPolicyIdxGroup.group)
end

TPolicyIdxGroup.from_obj = TPolicyIdxGroup_from_obj

TPolicyIdxGroup.proto_property = {'PolicyIdxGroup'}

TPolicyIdxGroup.default = {{}}

TPolicyIdxGroup.struct = {
    {name = 'PolicyIdxGroup', is_array = true, struct = nil}
}

function TPolicyIdxGroup:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PolicyIdxGroup', self.PolicyIdxGroup,
                           "uint8", true, errs, need_convert)

    TPolicyIdxGroup:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPolicyIdxGroup.proto_property, errs,
                                 need_convert)
    return self
end

function TPolicyIdxGroup:unpack(_) return self.PolicyIdxGroup end

CoolingArea.PolicyIdxGroup = TPolicyIdxGroup

---@class CoolingArea.RequirementIdx
---@field RequirementIdx integer
local TRequirementIdx = {}
TRequirementIdx.__index = TRequirementIdx
TRequirementIdx.group = {}

local function TRequirementIdx_from_obj(obj)
    return setmetatable(obj, TRequirementIdx)
end

function TRequirementIdx.new(RequirementIdx)
    return TRequirementIdx_from_obj({RequirementIdx = RequirementIdx})
end
---@param obj CoolingArea.RequirementIdx
function TRequirementIdx:init_from_obj(obj)
    self.RequirementIdx = obj.RequirementIdx
end

function TRequirementIdx:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRequirementIdx.group)
end

TRequirementIdx.from_obj = TRequirementIdx_from_obj

TRequirementIdx.proto_property = {'RequirementIdx'}

TRequirementIdx.default = {0}

TRequirementIdx.struct = {
    {name = 'RequirementIdx', is_array = false, struct = nil}
}

function TRequirementIdx:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RequirementIdx', self.RequirementIdx, "uint8",
                      true, errs, need_convert)

    TRequirementIdx:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRequirementIdx.proto_property, errs,
                                 need_convert)
    return self
end

function TRequirementIdx:unpack(_) return self.RequirementIdx end

CoolingArea.RequirementIdx = TRequirementIdx

---@class CoolingArea.AreaId
---@field AreaId integer
local TAreaId = {}
TAreaId.__index = TAreaId
TAreaId.group = {}

local function TAreaId_from_obj(obj) return setmetatable(obj, TAreaId) end

function TAreaId.new(AreaId) return TAreaId_from_obj({AreaId = AreaId}) end
---@param obj CoolingArea.AreaId
function TAreaId:init_from_obj(obj) self.AreaId = obj.AreaId end

function TAreaId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAreaId.group)
end

TAreaId.from_obj = TAreaId_from_obj

TAreaId.proto_property = {'AreaId'}

TAreaId.default = {0}

TAreaId.struct = {{name = 'AreaId', is_array = false, struct = nil}}

function TAreaId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AreaId', self.AreaId, "uint8", true, errs,
                      need_convert)

    TAreaId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAreaId.proto_property, errs,
                                 need_convert)
    return self
end

function TAreaId:unpack(_) return self.AreaId end

CoolingArea.AreaId = TAreaId

CoolingArea.interface = mdb.register_interface('bmc.kepler.Systems.CoolingArea',
                                               {
    AreaId = {'y', nil, true, nil, false},
    RequirementIdx = {'y', nil, true, nil, false},
    PolicyIdxGroup = {'ay', nil, true, nil, false},
    FanIdxGroup = {'ay', nil, true, nil, false}
}, {}, {})

return CoolingArea
