-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local AirCoolingConfig = {}

---@class AirCoolingConfig.InitialSpeedPercent
---@field InitialSpeedPercent integer
local TInitialSpeedPercent = {}
TInitialSpeedPercent.__index = TInitialSpeedPercent
TInitialSpeedPercent.group = {}

local function TInitialSpeedPercent_from_obj(obj)
    return setmetatable(obj, TInitialSpeedPercent)
end

function TInitialSpeedPercent.new(InitialSpeedPercent)
    return TInitialSpeedPercent_from_obj({
        InitialSpeedPercent = InitialSpeedPercent or 100
    })
end
---@param obj AirCoolingConfig.InitialSpeedPercent
function TInitialSpeedPercent:init_from_obj(obj)
    self.InitialSpeedPercent = obj.InitialSpeedPercent or 100
end

function TInitialSpeedPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInitialSpeedPercent.group)
end

TInitialSpeedPercent.from_obj = TInitialSpeedPercent_from_obj

TInitialSpeedPercent.proto_property = {'InitialSpeedPercent'}

TInitialSpeedPercent.default = {0}

TInitialSpeedPercent.struct = {
    {name = 'InitialSpeedPercent', is_array = false, struct = nil}
}

function TInitialSpeedPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InitialSpeedPercent', self.InitialSpeedPercent,
                      "uint8", false, errs, need_convert)

    if self.InitialSpeedPercent ~= nil then
        validate.ranges(prefix .. 'InitialSpeedPercent',
                        self.InitialSpeedPercent, 0, 100, errs, need_convert)
    end

    TInitialSpeedPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInitialSpeedPercent.proto_property,
                                 errs, need_convert)
    return self
end

function TInitialSpeedPercent:unpack(_) return self.InitialSpeedPercent end

AirCoolingConfig.InitialSpeedPercent = TInitialSpeedPercent

---@class AirCoolingConfig.MinAllowedSpeedPercent
---@field MinAllowedSpeedPercent integer
local TMinAllowedSpeedPercent = {}
TMinAllowedSpeedPercent.__index = TMinAllowedSpeedPercent
TMinAllowedSpeedPercent.group = {}

local function TMinAllowedSpeedPercent_from_obj(obj)
    return setmetatable(obj, TMinAllowedSpeedPercent)
end

function TMinAllowedSpeedPercent.new(MinAllowedSpeedPercent)
    return TMinAllowedSpeedPercent_from_obj({
        MinAllowedSpeedPercent = MinAllowedSpeedPercent or 255
    })
end
---@param obj AirCoolingConfig.MinAllowedSpeedPercent
function TMinAllowedSpeedPercent:init_from_obj(obj)
    self.MinAllowedSpeedPercent = obj.MinAllowedSpeedPercent or 255
end

function TMinAllowedSpeedPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinAllowedSpeedPercent.group)
end

TMinAllowedSpeedPercent.from_obj = TMinAllowedSpeedPercent_from_obj

TMinAllowedSpeedPercent.proto_property = {'MinAllowedSpeedPercent'}

TMinAllowedSpeedPercent.default = {0}

TMinAllowedSpeedPercent.struct = {
    {name = 'MinAllowedSpeedPercent', is_array = false, struct = nil}
}

function TMinAllowedSpeedPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinAllowedSpeedPercent',
                      self.MinAllowedSpeedPercent, "uint8", false, errs,
                      need_convert)

    TMinAllowedSpeedPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinAllowedSpeedPercent.proto_property,
                                 errs, need_convert)
    return self
end

function TMinAllowedSpeedPercent:unpack(_) return self.MinAllowedSpeedPercent end

AirCoolingConfig.MinAllowedSpeedPercent = TMinAllowedSpeedPercent

---@class AirCoolingConfig.SpeedPercentRange
---@field SpeedPercentRange integer[]
local TSpeedPercentRange = {}
TSpeedPercentRange.__index = TSpeedPercentRange
TSpeedPercentRange.group = {}

local function TSpeedPercentRange_from_obj(obj)
    return setmetatable(obj, TSpeedPercentRange)
end

function TSpeedPercentRange.new(SpeedPercentRange)
    return TSpeedPercentRange_from_obj({SpeedPercentRange = SpeedPercentRange})
end
---@param obj AirCoolingConfig.SpeedPercentRange
function TSpeedPercentRange:init_from_obj(obj)
    self.SpeedPercentRange = obj.SpeedPercentRange
end

function TSpeedPercentRange:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedPercentRange.group)
end

TSpeedPercentRange.from_obj = TSpeedPercentRange_from_obj

TSpeedPercentRange.proto_property = {'SpeedPercentRange'}

TSpeedPercentRange.default = {{}}

TSpeedPercentRange.struct = {
    {name = 'SpeedPercentRange', is_array = true, struct = nil}
}

function TSpeedPercentRange:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SpeedPercentRange',
                           self.SpeedPercentRange, "uint8", true, errs,
                           need_convert)

    TSpeedPercentRange:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedPercentRange.proto_property, errs,
                                 need_convert)
    return self
end

function TSpeedPercentRange:unpack(_) return self.SpeedPercentRange end

AirCoolingConfig.SpeedPercentRange = TSpeedPercentRange

---@class AirCoolingConfig.ManualSpeedPercent
---@field ManualSpeedPercent integer
local TManualSpeedPercent = {}
TManualSpeedPercent.__index = TManualSpeedPercent
TManualSpeedPercent.group = {}

local function TManualSpeedPercent_from_obj(obj)
    return setmetatable(obj, TManualSpeedPercent)
end

function TManualSpeedPercent.new(ManualSpeedPercent)
    return TManualSpeedPercent_from_obj({
        ManualSpeedPercent = ManualSpeedPercent or 10
    })
end
---@param obj AirCoolingConfig.ManualSpeedPercent
function TManualSpeedPercent:init_from_obj(obj)
    self.ManualSpeedPercent = obj.ManualSpeedPercent or 10
end

function TManualSpeedPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManualSpeedPercent.group)
end

TManualSpeedPercent.from_obj = TManualSpeedPercent_from_obj

TManualSpeedPercent.proto_property = {'ManualSpeedPercent'}

TManualSpeedPercent.default = {0}

TManualSpeedPercent.struct = {
    {name = 'ManualSpeedPercent', is_array = false, struct = nil}
}

function TManualSpeedPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManualSpeedPercent', self.ManualSpeedPercent,
                      "uint8", true, errs, need_convert)

    if self.ManualSpeedPercent ~= nil then
        validate.ranges(prefix .. 'ManualSpeedPercent', self.ManualSpeedPercent,
                        0, 100, errs, need_convert)
    end

    TManualSpeedPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManualSpeedPercent.proto_property, errs,
                                 need_convert)
    return self
end

function TManualSpeedPercent:unpack(_) return self.ManualSpeedPercent end

AirCoolingConfig.ManualSpeedPercent = TManualSpeedPercent

---@class AirCoolingConfig.TimeOut
---@field TimeOut integer
local TTimeOut = {}
TTimeOut.__index = TTimeOut
TTimeOut.group = {}

local function TTimeOut_from_obj(obj) return setmetatable(obj, TTimeOut) end

function TTimeOut.new(TimeOut)
    return TTimeOut_from_obj({TimeOut = TimeOut or 30})
end
---@param obj AirCoolingConfig.TimeOut
function TTimeOut:init_from_obj(obj) self.TimeOut = obj.TimeOut or 30 end

function TTimeOut:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimeOut.group)
end

TTimeOut.from_obj = TTimeOut_from_obj

TTimeOut.proto_property = {'TimeOut'}

TTimeOut.default = {0}

TTimeOut.struct = {{name = 'TimeOut', is_array = false, struct = nil}}

function TTimeOut:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeOut', self.TimeOut, "uint32", true, errs,
                      need_convert)

    TTimeOut:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimeOut.proto_property, errs,
                                 need_convert)
    return self
end

function TTimeOut:unpack(_) return self.TimeOut end

AirCoolingConfig.TimeOut = TTimeOut

---@class AirCoolingConfig.CtrlMode
---@field CtrlMode string
local TCtrlMode = {}
TCtrlMode.__index = TCtrlMode
TCtrlMode.group = {}

local function TCtrlMode_from_obj(obj) return setmetatable(obj, TCtrlMode) end

function TCtrlMode.new(CtrlMode)
    return TCtrlMode_from_obj({CtrlMode = CtrlMode or [=[Auto]=]})
end
---@param obj AirCoolingConfig.CtrlMode
function TCtrlMode:init_from_obj(obj) self.CtrlMode = obj.CtrlMode or [=[Auto]=] end

function TCtrlMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCtrlMode.group)
end

TCtrlMode.from_obj = TCtrlMode_from_obj

TCtrlMode.proto_property = {'CtrlMode'}

TCtrlMode.default = {''}

TCtrlMode.struct = {{name = 'CtrlMode', is_array = false, struct = nil}}

function TCtrlMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlMode', self.CtrlMode, "string", true, errs,
                      need_convert)

    if self.CtrlMode ~= nil then
        validate.Enum(prefix .. 'CtrlMode', self.CtrlMode, '',
                      {"Auto", "Manual", "Mixed"}, errs, need_convert)
    end

    TCtrlMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCtrlMode.proto_property, errs,
                                 need_convert)
    return self
end

function TCtrlMode:unpack(_) return self.CtrlMode end

AirCoolingConfig.CtrlMode = TCtrlMode

---@class AirCoolingConfig.SetManualSpeedPercentRsp
local TSetManualSpeedPercentRsp = {}
TSetManualSpeedPercentRsp.__index = TSetManualSpeedPercentRsp
TSetManualSpeedPercentRsp.group = {}

local function TSetManualSpeedPercentRsp_from_obj(obj)
    return setmetatable(obj, TSetManualSpeedPercentRsp)
end

function TSetManualSpeedPercentRsp.new()
    return TSetManualSpeedPercentRsp_from_obj({})
end
---@param obj AirCoolingConfig.SetManualSpeedPercentRsp
function TSetManualSpeedPercentRsp:init_from_obj(obj) end

function TSetManualSpeedPercentRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetManualSpeedPercentRsp.group)
end

TSetManualSpeedPercentRsp.from_obj = TSetManualSpeedPercentRsp_from_obj

TSetManualSpeedPercentRsp.proto_property = {}

TSetManualSpeedPercentRsp.default = {}

TSetManualSpeedPercentRsp.struct = {}

function TSetManualSpeedPercentRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetManualSpeedPercentRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetManualSpeedPercentRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetManualSpeedPercentRsp:unpack(_) end

AirCoolingConfig.SetManualSpeedPercentRsp = TSetManualSpeedPercentRsp

---@class AirCoolingConfig.SetManualSpeedPercentReq
---@field FanId integer
---@field SpeedPercent integer
local TSetManualSpeedPercentReq = {}
TSetManualSpeedPercentReq.__index = TSetManualSpeedPercentReq
TSetManualSpeedPercentReq.group = {}

local function TSetManualSpeedPercentReq_from_obj(obj)
    return setmetatable(obj, TSetManualSpeedPercentReq)
end

function TSetManualSpeedPercentReq.new(FanId, SpeedPercent)
    return TSetManualSpeedPercentReq_from_obj({
        FanId = FanId,
        SpeedPercent = SpeedPercent
    })
end
---@param obj AirCoolingConfig.SetManualSpeedPercentReq
function TSetManualSpeedPercentReq:init_from_obj(obj)
    self.FanId = obj.FanId
    self.SpeedPercent = obj.SpeedPercent
end

function TSetManualSpeedPercentReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetManualSpeedPercentReq.group)
end

TSetManualSpeedPercentReq.from_obj = TSetManualSpeedPercentReq_from_obj

TSetManualSpeedPercentReq.proto_property = {'FanId', 'SpeedPercent'}

TSetManualSpeedPercentReq.default = {0, 0}

TSetManualSpeedPercentReq.struct = {
    {name = 'FanId', is_array = false, struct = nil},
    {name = 'SpeedPercent', is_array = false, struct = nil}
}

function TSetManualSpeedPercentReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanId', self.FanId, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'SpeedPercent', self.SpeedPercent, "uint8",
                      false, errs, need_convert)

    TSetManualSpeedPercentReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetManualSpeedPercentReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetManualSpeedPercentReq:unpack(_) return self.FanId,
                                                    self.SpeedPercent end

AirCoolingConfig.SetManualSpeedPercentReq = TSetManualSpeedPercentReq

---@class AirCoolingConfig.SetCtrlModeRsp
local TSetCtrlModeRsp = {}
TSetCtrlModeRsp.__index = TSetCtrlModeRsp
TSetCtrlModeRsp.group = {}

local function TSetCtrlModeRsp_from_obj(obj)
    return setmetatable(obj, TSetCtrlModeRsp)
end

function TSetCtrlModeRsp.new() return TSetCtrlModeRsp_from_obj({}) end
---@param obj AirCoolingConfig.SetCtrlModeRsp
function TSetCtrlModeRsp:init_from_obj(obj) end

function TSetCtrlModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCtrlModeRsp.group)
end

TSetCtrlModeRsp.from_obj = TSetCtrlModeRsp_from_obj

TSetCtrlModeRsp.proto_property = {}

TSetCtrlModeRsp.default = {}

TSetCtrlModeRsp.struct = {}

function TSetCtrlModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetCtrlModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCtrlModeRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TSetCtrlModeRsp:unpack(_) end

AirCoolingConfig.SetCtrlModeRsp = TSetCtrlModeRsp

---@class AirCoolingConfig.SetCtrlModeReq
---@field CtrlMode string
---@field Timeout integer
local TSetCtrlModeReq = {}
TSetCtrlModeReq.__index = TSetCtrlModeReq
TSetCtrlModeReq.group = {}

local function TSetCtrlModeReq_from_obj(obj)
    return setmetatable(obj, TSetCtrlModeReq)
end

function TSetCtrlModeReq.new(CtrlMode, Timeout)
    return TSetCtrlModeReq_from_obj({CtrlMode = CtrlMode, Timeout = Timeout})
end
---@param obj AirCoolingConfig.SetCtrlModeReq
function TSetCtrlModeReq:init_from_obj(obj)
    self.CtrlMode = obj.CtrlMode
    self.Timeout = obj.Timeout
end

function TSetCtrlModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCtrlModeReq.group)
end

TSetCtrlModeReq.from_obj = TSetCtrlModeReq_from_obj

TSetCtrlModeReq.proto_property = {'CtrlMode', 'Timeout'}

TSetCtrlModeReq.default = {'', 0}

TSetCtrlModeReq.struct = {
    {name = 'CtrlMode', is_array = false, struct = nil},
    {name = 'Timeout', is_array = false, struct = nil}
}

function TSetCtrlModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlMode', self.CtrlMode, "string", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'Timeout', self.Timeout, "uint32", false, errs,
                      need_convert)

    if self.CtrlMode ~= nil then
        validate.Enum(prefix .. 'CtrlMode', self.CtrlMode, '',
                      {"Auto", "Manual", "Mixed"}, errs, need_convert)
    end

    TSetCtrlModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCtrlModeReq.proto_property, errs,
                                 need_convert)
    return self
end

function TSetCtrlModeReq:unpack(_) return self.CtrlMode, self.Timeout end

AirCoolingConfig.SetCtrlModeReq = TSetCtrlModeReq

AirCoolingConfig.interface = mdb.register_interface(
                                 'bmc.kepler.Systems.AirCoolingConfig', {
        CtrlMode = {'s', {'EMIT_CHANGE'}, true, 'Auto', false},
        TimeOut = {'u', {'VOLATILE'}, true, 30, false},
        ManualSpeedPercent = {'y', {'EMIT_CHANGE'}, true, 10, false},
        SpeedPercentRange = {'ay', {'CONST'}, true, nil, false},
        MinAllowedSpeedPercent = {'y', {'EMIT_CHANGE'}, false, 255, false},
        InitialSpeedPercent = {'y', {}, false, 100, false}
    }, {
        SetCtrlMode = {'a{ss}su', '', TSetCtrlModeReq, TSetCtrlModeRsp},
        SetManualSpeedPercent = {
            'a{ss}yy', '', TSetManualSpeedPercentReq, TSetManualSpeedPercentRsp
        }
    }, {})

return AirCoolingConfig
