-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Accessor = {}

---@class Accessor.Status
---@field Status integer
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj) return setmetatable(obj, TStatus) end

function TStatus.new(Status) return TStatus_from_obj({Status = Status or 4}) end
---@param obj Accessor.Status
function TStatus:init_from_obj(obj) self.Status = obj.Status or 4 end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {0}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, "uint8", true, errs,
                      need_convert)

    if self.Status ~= nil then
        validate.Enum(prefix .. 'Status', self.Status, '', {0, 1, 2, 3, 4},
                      errs, need_convert)
    end

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs,
                                 need_convert)
    return self
end

function TStatus:unpack(_) return self.Status end

Accessor.Status = TStatus

---@class Accessor.Value
---@field Value integer
local TValue = {}
TValue.__index = TValue
TValue.group = {}

local function TValue_from_obj(obj) return setmetatable(obj, TValue) end

function TValue.new(Value) return TValue_from_obj({Value = Value}) end
---@param obj Accessor.Value
function TValue:init_from_obj(obj) self.Value = obj.Value end

function TValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValue.group)
end

TValue.from_obj = TValue_from_obj

TValue.proto_property = {'Value'}

TValue.default = {0}

TValue.struct = {{name = 'Value', is_array = false, struct = nil}}

function TValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Value', self.Value, "uint64", false, errs,
                      need_convert)

    TValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValue.proto_property, errs, need_convert)
    return self
end

function TValue:unpack(_) return self.Value end

Accessor.Value = TValue

Accessor.interface = mdb.register_interface('bmc.kepler.Accessor', {
    Value = {'t', nil, false, nil, false},
    Status = {'y', nil, true, 4, false}
}, {}, {})

return Accessor
