--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetInitCoolingUnitLevel = {}

---@class ThermalMgmtIpmiCmds.SetInitCoolingUnitLevelReq
---@field ManufactureId integer
---@field ParamLen integer
---@field Level integer
local TSetInitCoolingUnitLevelReq = {}
TSetInitCoolingUnitLevelReq.__index = TSetInitCoolingUnitLevelReq
TSetInitCoolingUnitLevelReq.group = {}

local function TSetInitCoolingUnitLevelReq_from_obj(obj)
    return setmetatable(obj, TSetInitCoolingUnitLevelReq)
end

function TSetInitCoolingUnitLevelReq.new(ManufactureId, ParamLen, Level)
    return TSetInitCoolingUnitLevelReq_from_obj({
        ManufactureId = ManufactureId,
        ParamLen = ParamLen,
        Level = Level
    })
end
---@param obj ThermalMgmtIpmiCmds.SetInitCoolingUnitLevelReq
function TSetInitCoolingUnitLevelReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.ParamLen = obj.ParamLen
    self.Level = obj.Level
end

function TSetInitCoolingUnitLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetInitCoolingUnitLevelReq.group)
end

TSetInitCoolingUnitLevelReq.from_obj = TSetInitCoolingUnitLevelReq_from_obj

TSetInitCoolingUnitLevelReq.proto_property = {
    'ManufactureId', 'ParamLen', 'Level'
}

TSetInitCoolingUnitLevelReq.default = {0, 0, 0}

TSetInitCoolingUnitLevelReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'ParamLen', is_array = false, struct = nil},
    {name = 'Level', is_array = false, struct = nil}
}

function TSetInitCoolingUnitLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ParamLen', self.ParamLen, "uint16", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'Level', self.Level, "uint8", false, errs,
                      need_convert)

    TSetInitCoolingUnitLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TSetInitCoolingUnitLevelReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetInitCoolingUnitLevelReq:unpack(_)
    return self.ManufactureId, self.ParamLen, self.Level
end

SetInitCoolingUnitLevel.SetInitCoolingUnitLevelReq = TSetInitCoolingUnitLevelReq

---@class ThermalMgmtIpmiCmds.SetInitCoolingUnitLevelRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetInitCoolingUnitLevelRsp = {}
TSetInitCoolingUnitLevelRsp.__index = TSetInitCoolingUnitLevelRsp
TSetInitCoolingUnitLevelRsp.group = {}

local function TSetInitCoolingUnitLevelRsp_from_obj(obj)
    return setmetatable(obj, TSetInitCoolingUnitLevelRsp)
end

function TSetInitCoolingUnitLevelRsp.new(CompletionCode, ManufactureId)
    return TSetInitCoolingUnitLevelRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId
    })
end
---@param obj ThermalMgmtIpmiCmds.SetInitCoolingUnitLevelRsp
function TSetInitCoolingUnitLevelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetInitCoolingUnitLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetInitCoolingUnitLevelRsp.group)
end

TSetInitCoolingUnitLevelRsp.from_obj = TSetInitCoolingUnitLevelRsp_from_obj

TSetInitCoolingUnitLevelRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetInitCoolingUnitLevelRsp.default = {0, 0}

TSetInitCoolingUnitLevelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetInitCoolingUnitLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)

    TSetInitCoolingUnitLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TSetInitCoolingUnitLevelRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetInitCoolingUnitLevelRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetInitCoolingUnitLevel.SetInitCoolingUnitLevelRsp = TSetInitCoolingUnitLevelRsp

return SetInitCoolingUnitLevel
