--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetFanCtlMode = {}

---@class ThermalMgmtIpmiCmds.SetFanCtlModeReq
---@field ManufactureId integer
---@field Mode integer
---@field AddInfo string
local TSetFanCtlModeReq = {}
TSetFanCtlModeReq.__index = TSetFanCtlModeReq
TSetFanCtlModeReq.group = {}

local function TSetFanCtlModeReq_from_obj(obj)
    return setmetatable(obj, TSetFanCtlModeReq)
end

function TSetFanCtlModeReq.new(ManufactureId, Mode, AddInfo)
    return TSetFanCtlModeReq_from_obj({
        ManufactureId = ManufactureId,
        Mode = Mode,
        AddInfo = AddInfo
    })
end
---@param obj ThermalMgmtIpmiCmds.SetFanCtlModeReq
function TSetFanCtlModeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Mode = obj.Mode
    self.AddInfo = obj.AddInfo
end

function TSetFanCtlModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFanCtlModeReq.group)
end

TSetFanCtlModeReq.from_obj = TSetFanCtlModeReq_from_obj

TSetFanCtlModeReq.proto_property = {'ManufactureId', 'Mode', 'AddInfo'}

TSetFanCtlModeReq.default = {0, 0, ''}

TSetFanCtlModeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Mode', is_array = false, struct = nil},
    {name = 'AddInfo', is_array = false, struct = nil}
}

function TSetFanCtlModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'Mode', self.Mode, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'AddInfo', self.AddInfo, "string", false, errs,
                      need_convert)

    TSetFanCtlModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFanCtlModeReq.proto_property, errs,
                                 need_convert)
    return self
end

function TSetFanCtlModeReq:unpack(_)
    return self.ManufactureId, self.Mode, self.AddInfo
end

SetFanCtlMode.SetFanCtlModeReq = TSetFanCtlModeReq

---@class ThermalMgmtIpmiCmds.SetFanCtlModeRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetFanCtlModeRsp = {}
TSetFanCtlModeRsp.__index = TSetFanCtlModeRsp
TSetFanCtlModeRsp.group = {}

local function TSetFanCtlModeRsp_from_obj(obj)
    return setmetatable(obj, TSetFanCtlModeRsp)
end

function TSetFanCtlModeRsp.new(CompletionCode, ManufactureId)
    return TSetFanCtlModeRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId
    })
end
---@param obj ThermalMgmtIpmiCmds.SetFanCtlModeRsp
function TSetFanCtlModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetFanCtlModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFanCtlModeRsp.group)
end

TSetFanCtlModeRsp.from_obj = TSetFanCtlModeRsp_from_obj

TSetFanCtlModeRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetFanCtlModeRsp.default = {0, 0}

TSetFanCtlModeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetFanCtlModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)

    TSetFanCtlModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFanCtlModeRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TSetFanCtlModeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetFanCtlMode.SetFanCtlModeRsp = TSetFanCtlModeRsp

return SetFanCtlMode
