--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetCoolingMode = {}

---@class ThermalMgmtIpmiCmds.SetCoolingModeReq
---@field ManufactureId integer
---@field PolicyOption integer
---@field PolicyValue integer
local TSetCoolingModeReq = {}
TSetCoolingModeReq.__index = TSetCoolingModeReq
TSetCoolingModeReq.group = {}

local function TSetCoolingModeReq_from_obj(obj)
    return setmetatable(obj, TSetCoolingModeReq)
end

function TSetCoolingModeReq.new(ManufactureId, PolicyOption, PolicyValue)
    return TSetCoolingModeReq_from_obj({
        ManufactureId = ManufactureId,
        PolicyOption = PolicyOption,
        PolicyValue = PolicyValue
    })
end
---@param obj ThermalMgmtIpmiCmds.SetCoolingModeReq
function TSetCoolingModeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.PolicyOption = obj.PolicyOption
    self.PolicyValue = obj.PolicyValue
end

function TSetCoolingModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCoolingModeReq.group)
end

TSetCoolingModeReq.from_obj = TSetCoolingModeReq_from_obj

TSetCoolingModeReq.proto_property = {
    'ManufactureId', 'PolicyOption', 'PolicyValue'
}

TSetCoolingModeReq.default = {0, 0, 0}

TSetCoolingModeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'PolicyOption', is_array = false, struct = nil},
    {name = 'PolicyValue', is_array = false, struct = nil}
}

function TSetCoolingModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'PolicyOption', self.PolicyOption, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'PolicyValue', self.PolicyValue, "uint8", false,
                      errs, need_convert)

    TSetCoolingModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCoolingModeReq.proto_property, errs,
                                 need_convert)
    return self
end

function TSetCoolingModeReq:unpack(_)
    return self.ManufactureId, self.PolicyOption, self.PolicyValue
end

SetCoolingMode.SetCoolingModeReq = TSetCoolingModeReq

---@class ThermalMgmtIpmiCmds.SetCoolingModeRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetCoolingModeRsp = {}
TSetCoolingModeRsp.__index = TSetCoolingModeRsp
TSetCoolingModeRsp.group = {}

local function TSetCoolingModeRsp_from_obj(obj)
    return setmetatable(obj, TSetCoolingModeRsp)
end

function TSetCoolingModeRsp.new(CompletionCode, ManufactureId)
    return TSetCoolingModeRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId
    })
end
---@param obj ThermalMgmtIpmiCmds.SetCoolingModeRsp
function TSetCoolingModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetCoolingModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCoolingModeRsp.group)
end

TSetCoolingModeRsp.from_obj = TSetCoolingModeRsp_from_obj

TSetCoolingModeRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetCoolingModeRsp.default = {0, 0}

TSetCoolingModeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetCoolingModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)

    TSetCoolingModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCoolingModeRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TSetCoolingModeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetCoolingMode.SetCoolingModeRsp = TSetCoolingModeRsp

return SetCoolingMode
