--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetValveStandardOpeningDegree = {}

---@class ThermalMgmtIpmiCmds.GetValveStandardOpeningDegreeReq
---@field ManufactureId integer
---@field Index integer
local TGetValveStandardOpeningDegreeReq = {}
TGetValveStandardOpeningDegreeReq.__index = TGetValveStandardOpeningDegreeReq
TGetValveStandardOpeningDegreeReq.group = {}

local function TGetValveStandardOpeningDegreeReq_from_obj(obj)
    return setmetatable(obj, TGetValveStandardOpeningDegreeReq)
end

function TGetValveStandardOpeningDegreeReq.new(ManufactureId, Index)
    return TGetValveStandardOpeningDegreeReq_from_obj({
        ManufactureId = ManufactureId,
        Index = Index
    })
end
---@param obj ThermalMgmtIpmiCmds.GetValveStandardOpeningDegreeReq
function TGetValveStandardOpeningDegreeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Index = obj.Index
end

function TGetValveStandardOpeningDegreeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TGetValveStandardOpeningDegreeReq.group)
end

TGetValveStandardOpeningDegreeReq.from_obj =
    TGetValveStandardOpeningDegreeReq_from_obj

TGetValveStandardOpeningDegreeReq.proto_property = {'ManufactureId', 'Index'}

TGetValveStandardOpeningDegreeReq.default = {0, 0}

TGetValveStandardOpeningDegreeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Index', is_array = false, struct = nil}
}

function TGetValveStandardOpeningDegreeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'Index', self.Index, "uint8", false, errs,
                      need_convert)

    TGetValveStandardOpeningDegreeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TGetValveStandardOpeningDegreeReq.proto_property,
                                 errs, need_convert)
    return self
end

function TGetValveStandardOpeningDegreeReq:unpack(_)
    return self.ManufactureId, self.Index
end

GetValveStandardOpeningDegree.GetValveStandardOpeningDegreeReq =
    TGetValveStandardOpeningDegreeReq

---@class ThermalMgmtIpmiCmds.GetValveStandardOpeningDegreeRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data integer
local TGetValveStandardOpeningDegreeRsp = {}
TGetValveStandardOpeningDegreeRsp.__index = TGetValveStandardOpeningDegreeRsp
TGetValveStandardOpeningDegreeRsp.group = {}

local function TGetValveStandardOpeningDegreeRsp_from_obj(obj)
    return setmetatable(obj, TGetValveStandardOpeningDegreeRsp)
end

function TGetValveStandardOpeningDegreeRsp.new(CompletionCode, ManufactureId,
                                               Data)
    return TGetValveStandardOpeningDegreeRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Data = Data
    })
end
---@param obj ThermalMgmtIpmiCmds.GetValveStandardOpeningDegreeRsp
function TGetValveStandardOpeningDegreeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetValveStandardOpeningDegreeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TGetValveStandardOpeningDegreeRsp.group)
end

TGetValveStandardOpeningDegreeRsp.from_obj =
    TGetValveStandardOpeningDegreeRsp_from_obj

TGetValveStandardOpeningDegreeRsp.proto_property = {
    'CompletionCode', 'ManufactureId', 'Data'
}

TGetValveStandardOpeningDegreeRsp.default = {0, 0, 0}

TGetValveStandardOpeningDegreeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetValveStandardOpeningDegreeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, "uint16", false, errs,
                      need_convert)

    TGetValveStandardOpeningDegreeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TGetValveStandardOpeningDegreeRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TGetValveStandardOpeningDegreeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetValveStandardOpeningDegree.GetValveStandardOpeningDegreeRsp =
    TGetValveStandardOpeningDegreeRsp

return GetValveStandardOpeningDegree
