--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetTotalFanPower = {}

---@class ThermalMgmtIpmiCmds.GetTotalFanPowerReq
---@field ManufactureId integer
local TGetTotalFanPowerReq = {}
TGetTotalFanPowerReq.__index = TGetTotalFanPowerReq
TGetTotalFanPowerReq.group = {}

local function TGetTotalFanPowerReq_from_obj(obj)
    return setmetatable(obj, TGetTotalFanPowerReq)
end

function TGetTotalFanPowerReq.new(ManufactureId)
    return TGetTotalFanPowerReq_from_obj({ManufactureId = ManufactureId})
end
---@param obj ThermalMgmtIpmiCmds.GetTotalFanPowerReq
function TGetTotalFanPowerReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
end

function TGetTotalFanPowerReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTotalFanPowerReq.group)
end

TGetTotalFanPowerReq.from_obj = TGetTotalFanPowerReq_from_obj

TGetTotalFanPowerReq.proto_property = {'ManufactureId'}

TGetTotalFanPowerReq.default = {0}

TGetTotalFanPowerReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}
}

function TGetTotalFanPowerReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)

    TGetTotalFanPowerReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTotalFanPowerReq.proto_property,
                                 errs, need_convert)
    return self
end

function TGetTotalFanPowerReq:unpack(_) return self.ManufactureId end

GetTotalFanPower.GetTotalFanPowerReq = TGetTotalFanPowerReq

---@class ThermalMgmtIpmiCmds.GetTotalFanPowerRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field FanPower integer
---@field Unit integer
local TGetTotalFanPowerRsp = {}
TGetTotalFanPowerRsp.__index = TGetTotalFanPowerRsp
TGetTotalFanPowerRsp.group = {}

local function TGetTotalFanPowerRsp_from_obj(obj)
    return setmetatable(obj, TGetTotalFanPowerRsp)
end

function TGetTotalFanPowerRsp.new(CompletionCode, ManufactureId, FanPower, Unit)
    return TGetTotalFanPowerRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        FanPower = FanPower,
        Unit = Unit
    })
end
---@param obj ThermalMgmtIpmiCmds.GetTotalFanPowerRsp
function TGetTotalFanPowerRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.FanPower = obj.FanPower
    self.Unit = obj.Unit
end

function TGetTotalFanPowerRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTotalFanPowerRsp.group)
end

TGetTotalFanPowerRsp.from_obj = TGetTotalFanPowerRsp_from_obj

TGetTotalFanPowerRsp.proto_property = {
    'CompletionCode', 'ManufactureId', 'FanPower', 'Unit'
}

TGetTotalFanPowerRsp.default = {0, 0, 0, 0}

TGetTotalFanPowerRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'FanPower', is_array = false, struct = nil},
    {name = 'Unit', is_array = false, struct = nil}
}

function TGetTotalFanPowerRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'FanPower', self.FanPower, "uint32", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'Unit', self.Unit, "uint8", false, errs,
                      need_convert)

    TGetTotalFanPowerRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTotalFanPowerRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TGetTotalFanPowerRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.FanPower, self.Unit
end

GetTotalFanPower.GetTotalFanPowerRsp = TGetTotalFanPowerRsp

return GetTotalFanPower
